/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.kernel;

import com.arsdigita.kernel.MDUtil;
import com.arsdigita.kernel.NoValidURLException;
import com.arsdigita.kernel.PackageInstance;
import com.arsdigita.kernel.SiteNode;
import com.arsdigita.kernel.URLFinder;
import com.arsdigita.persistence.DataObject;
import com.arsdigita.persistence.DataQuery;
import com.arsdigita.persistence.OID;
import com.arsdigita.persistence.SessionManager;
import com.arsdigita.persistence.metadata.ObjectType;
import com.arsdigita.persistence.metadata.Property;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.servlet.http.HttpUtils;

public class GenericURLFinder
implements URLFinder {
    public static final String versionId = "$Id: //core-platform/dev/src/com/arsdigita/kernel/GenericURLFinder.java#9 $ by $Author: dennis $, $DateTime: 2004/04/07 16:07:11 $";
    private String m_base;
    private Map m_params = new HashMap();

    public GenericURLFinder(String urlEndingPattern) {
        this.m_base = GenericURLFinder.parseQueryString(urlEndingPattern, this.m_params);
    }

    public String find(OID oid, String context) throws NoValidURLException {
        return this.find(oid);
    }

    public String find(OID oid) throws NoValidURLException {
        DataObject dobj = SessionManager.getSession().retrieve(oid);
        if (dobj == null) {
            throw new NoValidURLException("No such data object " + oid);
        }
        DataObject packageInstanceData = this.getPackageInstanceData(dobj);
        if (packageInstanceData == null) {
            throw new NoValidURLException("Could not find package instance for " + dobj);
        }
        PackageInstance pkg = new PackageInstance(packageInstanceData);
        SiteNode sn = pkg.getDefaultMountPoint();
        if (sn == null) {
            throw new NoValidURLException("Could not find site node for package instance " + pkg);
        }
        return sn.getURL() + this.m_base + this.unparseQueryString(oid);
    }

    private DataObject getPackageInstanceData(DataObject dobj) {
        if (!GenericURLFinder.isACSObject(dobj.getObjectType())) {
            return this.guessPackageInstanceData(dobj);
        }
        String queryName = "com.arsdigita.kernel.PackageInstanceForObject";
        DataQuery query = SessionManager.getSession().retrieveQuery("com.arsdigita.kernel.PackageInstanceForObject");
        query.setParameter("objectID", dobj.get("id"));
        DataObject pkgInst = null;
        if (query.next()) {
            pkgInst = (DataObject)query.get("packageInstance");
        }
        query.close();
        return pkgInst;
    }

    private DataObject guessPackageInstanceData(DataObject dobj) {
        ObjectType o = dobj.getObjectType();
        if (GenericURLFinder.isACSObject(o)) {
            o = GenericURLFinder.getType((String)dobj.get("objectType"));
            dobj.specialize(o);
        }
        if (GenericURLFinder.isPackageInstance(o)) {
            return dobj;
        }
        if (MDUtil.hasPackageInstanceRole(o)) {
            return (DataObject)dobj.get("packageInstance");
        }
        DataObject composite = GenericURLFinder.getComposite(dobj);
        if (composite != null) {
            return this.guessPackageInstanceData(composite);
        }
        return null;
    }

    private static DataObject getComposite(DataObject dobj) {
        Property compositeRole = MDUtil.getCompositeRole(dobj.getObjectType());
        if (compositeRole == null) {
            return null;
        }
        return (DataObject)dobj.get(compositeRole.getName());
    }

    private static boolean isACSObject(ObjectType type) {
        return type.isSubtypeOf(GenericURLFinder.getType("com.arsdigita.kernel.ACSObject"));
    }

    private static boolean isPackageInstance(ObjectType type) {
        return type.isSubtypeOf(GenericURLFinder.getType("com.arsdigita.kernel.PackageInstance"));
    }

    private static ObjectType getType(String typeName) {
        return SessionManager.getMetadataRoot().getObjectType(typeName);
    }

    private String unparseQueryString(OID oid) {
        StringBuffer buf = new StringBuffer(128);
        int sep = 63;
        Iterator keys = this.m_params.keySet().iterator();
        while (keys.hasNext()) {
            String key = (String)keys.next();
            Object value = this.m_params.get(key);
            if (value instanceof String[]) {
                String[] values = (String[])value;
                for (int i = 0; i < values.length; ++i) {
                    if (values[i] == null) continue;
                    GenericURLFinder.appendParam(buf, (char)sep, key, this.getValue(oid, values[i]));
                    sep = 38;
                }
                continue;
            }
            if (value == null) continue;
            GenericURLFinder.appendParam(buf, (char)sep, key, this.getValue(oid, value.toString()));
            sep = 38;
        }
        return buf.toString();
    }

    private String getValue(OID oid, String val) {
        if (val.charAt(0) == ':') {
            return oid.get(val.substring(1)).toString();
        }
        return val;
    }

    private static String parseQueryString(String url, Map params) {
        int qmark = url.indexOf(63);
        if (qmark < 0) {
            return url;
        }
        String base = url.substring(0, qmark);
        String query = url.substring(qmark + 1);
        params.putAll(HttpUtils.parseQueryString((String)query));
        return base;
    }

    private static void appendParam(StringBuffer buf, char sep, String key, String value) {
        buf.append(sep).append(URLEncoder.encode(key)).append('=').append(URLEncoder.encode(value));
    }
}

