/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.kernel;

import com.arsdigita.domain.DomainObject;
import com.arsdigita.domain.DomainObjectFactory;
import com.arsdigita.domain.DomainObjectInstantiator;
import com.arsdigita.initializer.Configuration;
import com.arsdigita.kernel.ACSObjectInstantiator;
import com.arsdigita.kernel.BaseInitializer;
import com.arsdigita.kernel.GenericURLFinder;
import com.arsdigita.kernel.Group;
import com.arsdigita.kernel.URLFinder;
import com.arsdigita.kernel.URLService;
import com.arsdigita.kernel.User;
import com.arsdigita.kernel.permissions.PrivilegeDescriptor;
import com.arsdigita.persistence.DataObject;
import com.arsdigita.persistence.SessionManager;
import com.arsdigita.persistence.TransactionContext;
import org.apache.log4j.Logger;

public class Initializer
extends BaseInitializer {
    public static final String versionId = "$Id: //core-platform/dev/src/com/arsdigita/kernel/Initializer.java#38 $$Author: dennis $$DateTime: 2004/04/07 16:07:11 $";
    private static final Logger s_log = Logger.getLogger((Class)(class$com$arsdigita$kernel$Initializer == null ? (class$com$arsdigita$kernel$Initializer = Initializer.class$("com.arsdigita.kernel.Initializer")) : class$com$arsdigita$kernel$Initializer));
    private Configuration m_conf = new Configuration();
    static /* synthetic */ Class class$com$arsdigita$kernel$Initializer;

    public Configuration getConfiguration() {
        return this.m_conf;
    }

    protected void doStartup() {
        this.setupDomainFactory();
        this.setupURLService();
        TransactionContext txn = SessionManager.getSession().getTransactionContext();
        txn.beginTxn();
        s_log.debug((Object)"Initializing privilege descriptors...");
        PrivilegeDescriptor.initialize();
        s_log.debug((Object)"Done.");
        txn.commitTxn();
    }

    private void setupDomainFactory() {
        ACSObjectInstantiator instantiator = new ACSObjectInstantiator();
        DomainObjectFactory.registerInstantiator("com.arsdigita.kernel.ACSObject", (DomainObjectInstantiator)instantiator);
        DomainObjectFactory.registerInstantiator("com.arsdigita.kernel.Party", (DomainObjectInstantiator)instantiator);
        instantiator = new ACSObjectInstantiator(){

            public DomainObject doNewInstance(DataObject dataObject) {
                return new User(dataObject);
            }
        };
        DomainObjectFactory.registerInstantiator("com.arsdigita.kernel.User", (DomainObjectInstantiator)instantiator);
        instantiator = new ACSObjectInstantiator(){

            public DomainObject doNewInstance(DataObject dataObject) {
                return new Group(dataObject);
            }
        };
        DomainObjectFactory.registerInstantiator("com.arsdigita.kernel.Group", (DomainObjectInstantiator)instantiator);
    }

    private void setupURLService() {
        URLService.registerFinder("com.arsdigita.kernel.PackageInstance", (URLFinder)new GenericURLFinder(""));
    }

    protected void doShutdown() {
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

