/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.kernel;

import com.arsdigita.dispatcher.DispatcherHelper;
import com.arsdigita.dispatcher.RequestContext;
import com.arsdigita.kernel.Kernel;
import com.arsdigita.kernel.KernelContext;
import com.arsdigita.kernel.KernelRequestContext;
import com.arsdigita.kernel.Party;
import com.arsdigita.kernel.User;
import com.arsdigita.web.Web;
import javax.servlet.http.HttpServletRequest;

public class KernelHelper {
    private static String s_siteName = "";
    private static String s_hostName = "";
    private static String s_serverName = "";
    private static String s_serverPort = "";
    private static String s_systemAdministratorEmailAddress = "";

    public static KernelRequestContext getKernelRequestContext(HttpServletRequest req) {
        RequestContext rctx = DispatcherHelper.getRequestContext(req);
        try {
            return (KernelRequestContext)rctx;
        }
        catch (ClassCastException e) {
            throw new IllegalStateException("Request context does not subclass KernelRequestContext: " + rctx.getClass().getName());
        }
    }

    public static HttpServletRequest getRequest() {
        HttpServletRequest r = DispatcherHelper.getRequest();
        if (r == null) {
            throw new IllegalStateException("Request is not set");
        }
        return r;
    }

    public static synchronized String getServerName() {
        return Web.getConfig().getServer().getName();
    }

    public static synchronized String getServerPort() {
        return new Integer(Web.getConfig().getServer().getPort()).toString();
    }

    public static synchronized String getServerURL() {
        StringBuffer sb = new StringBuffer();
        sb.append("http://");
        String serverName = KernelHelper.getServerName();
        if (null == serverName) {
            sb.append("localhost");
        } else {
            sb.append(serverName);
        }
        String serverPort = KernelHelper.getServerPort();
        if (serverPort != null && !serverPort.equals("80")) {
            sb.append(':').append(serverPort);
        }
        return sb.toString();
    }

    public static synchronized String getHostName() {
        return Web.getConfig().getHost().getName();
    }

    public static synchronized String getSiteName() {
        return Web.getConfig().getSiteName();
    }

    public static synchronized String getSystemAdministratorEmailAddress() {
        return s_systemAdministratorEmailAddress;
    }

    public static synchronized boolean emailIsPrimaryIdentifier() {
        return Kernel.getConfig().getPrimaryUserIdentifier().equals("email");
    }

    public static User getCurrentUser(HttpServletRequest request) {
        return KernelHelper.getCurrentUser();
    }

    public static User getCurrentUser() {
        KernelContext kernelContext = Kernel.getContext();
        if (kernelContext.getParty() instanceof User) {
            return (User)kernelContext.getParty();
        }
        return null;
    }

    public static Party getCurrentParty() {
        KernelContext kernelContext = Kernel.getContext();
        return kernelContext.getParty();
    }

    public static Party getCurrentEffectiveParty() {
        KernelContext kernelContext = Kernel.getContext();
        return kernelContext.getEffectiveParty();
    }
}

