/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.kernel;

import com.arsdigita.db.Sequences;
import com.arsdigita.dispatcher.Dispatcher;
import com.arsdigita.domain.DataObjectNotFoundException;
import com.arsdigita.domain.DomainObject;
import com.arsdigita.kernel.PackageEventListener;
import com.arsdigita.kernel.PackageInstance;
import com.arsdigita.kernel.PackageInstanceCollection;
import com.arsdigita.kernel.PackageTypeCollection;
import com.arsdigita.kernel.StyleAssociation;
import com.arsdigita.kernel.Stylesheet;
import com.arsdigita.persistence.DataAssociation;
import com.arsdigita.persistence.DataAssociationCursor;
import com.arsdigita.persistence.DataCollection;
import com.arsdigita.persistence.DataObject;
import com.arsdigita.persistence.OID;
import com.arsdigita.persistence.PersistenceException;
import com.arsdigita.persistence.SessionManager;
import com.arsdigita.util.UncheckedWrapperException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import org.apache.log4j.Logger;

public class PackageType
extends DomainObject {
    public static final String versionId = "$Id: //core-platform/dev/src/com/arsdigita/kernel/PackageType.java#14 $ by $Author: dennis $, $DateTime: 2004/04/07 16:07:11 $";
    private static final Logger s_log = Logger.getLogger((String)(class$com$arsdigita$kernel$PackageType == null ? (class$com$arsdigita$kernel$PackageType = PackageType.class$("com.arsdigita.kernel.PackageType")) : class$com$arsdigita$kernel$PackageType).getName());
    private static HashMap s_dispatchers = new HashMap();
    public static final String BASE_DATA_OBJECT_TYPE = "com.arsdigita.kernel.PackageType";
    static /* synthetic */ Class class$com$arsdigita$kernel$PackageType;

    protected String getBaseDataObjectType() {
        return BASE_DATA_OBJECT_TYPE;
    }

    public PackageType() {
        super(BASE_DATA_OBJECT_TYPE);
    }

    public PackageType(DataObject dataObject) {
        super(dataObject);
    }

    public PackageType(OID oid) throws DataObjectNotFoundException {
        super(oid);
    }

    protected void initialize() {
        super.initialize();
        if (this.isNew() && this.get("id") == null) {
            this.setID(this.generateID());
        }
    }

    protected void beforeSave() throws PersistenceException {
        super.beforeSave();
        if (this.isNew() && this.getDispatcherClass() == null) {
            this.setDispatcherClass("com.arsdigita.dispatcher.JSPApplicationDispatcher");
        }
    }

    public BigDecimal getID() {
        return (BigDecimal)this.get("id");
    }

    private BigDecimal setID(BigDecimal id) {
        if (this.isNew()) {
            this.set("id", id);
            return id;
        }
        return this.getID();
    }

    private BigDecimal generateID() throws PersistenceException {
        try {
            return Sequences.getNextValue();
        }
        catch (SQLException e) {
            String errorMsg = "Unable to generate a unique id.";
            s_log.error((Object)"Unable to generate a unique id.");
            throw new PersistenceException("Unable to generate a unique id.");
        }
    }

    public String getKey() {
        return (String)this.get("packageKey");
    }

    public void setKey(String key) {
        if (this.getKey() == null) {
            this.set("packageKey", key);
        } else if (!this.isNew()) {
            throw new RuntimeException("setKey() cannot be called with a new keyonce the packageType is persisted.");
        }
    }

    public String getDisplayName() {
        return (String)this.get("prettyName");
    }

    public void setDisplayName(String displayName) {
        this.set("prettyName", displayName);
    }

    public String getDisplayPlural() {
        return (String)this.get("prettyPlural");
    }

    public void setDisplayPlural(String displayPlural) {
        this.set("prettyPlural", displayPlural);
    }

    public String getURI() {
        return (String)this.get("packageURI");
    }

    public void setURI(String URI2) {
        this.set("packageURI", URI2);
    }

    public String getDispatcherClass() {
        return (String)this.get("dispatcherClass");
    }

    public void setDispatcherClass(String dispatcherClass) {
        this.set("dispatcherClass", dispatcherClass);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Dispatcher getDispatcher() throws ClassNotFoundException, InstantiationException, IllegalAccessException, InvocationTargetException {
        Object dis;
        HashMap hashMap = s_dispatchers;
        synchronized (hashMap) {
            dis = s_dispatchers.get(this.getOID());
            if (dis == null) {
                Class<?> dispatcherClass = Class.forName(this.getDispatcherClass());
                try {
                    Method method = dispatcherClass.getMethod("newInstance", null);
                    dis = method.invoke(null, new Object[0]);
                }
                catch (NoSuchMethodException e) {
                    dis = dispatcherClass.newInstance();
                }
                s_dispatchers.put(this.getOID(), dis);
            }
        }
        if (dis == null) {
            throw new InstantiationException("Unable to instantiate dispatcher: " + this.getDispatcherClass() + ".");
        }
        return (Dispatcher)dis;
    }

    public PackageInstance createInstance(String displayName) {
        PackageInstance pkg = new PackageInstance();
        return this.initInstance(pkg, displayName);
    }

    public PackageInstance createInstance(Class instanceClass, String displayName) {
        PackageInstance pkg;
        try {
            Constructor constructor = instanceClass.getConstructor(new Class[0]);
            pkg = (PackageInstance)constructor.newInstance(new Object[0]);
        }
        catch (NoSuchMethodException ex) {
            throw new UncheckedWrapperException(ex);
        }
        catch (InstantiationException ex) {
            throw new UncheckedWrapperException(ex);
        }
        catch (IllegalAccessException ex) {
            throw new UncheckedWrapperException(ex);
        }
        catch (InvocationTargetException ex) {
            throw new UncheckedWrapperException(ex);
        }
        return this.initInstance(pkg, displayName);
    }

    private PackageInstance initInstance(PackageInstance pkg, String displayName) {
        pkg.setName(displayName);
        pkg.setType(this);
        pkg.save();
        PackageEventListener[] pels = this.getListeners();
        for (int i = 0; i < pels.length; ++i) {
            PackageEventListener listener = pels[i];
            listener.onCreate(pkg);
        }
        return pkg;
    }

    public void addStylesheet(Stylesheet sheet) {
        sheet.addToAssociation((DataAssociation)this.get("defaultStyle"));
    }

    public Stylesheet[] getStylesheets(Locale locale, String outputType) {
        return StyleAssociation.getStylesheets(this.get("defaultStyle"), locale, outputType);
    }

    public Stylesheet getStylesheet(Locale locale, String outputType) {
        return StyleAssociation.getStylesheet(this.get("defaultStyle"), locale, outputType);
    }

    public void removeStylesheet(Stylesheet sheet) {
        sheet.removeFromAssociation((DataAssociation)this.get("defaultStyle"));
    }

    public void addListener(String listenerClass) {
        if (!this.hasListener(listenerClass)) {
            try {
                this.instantiateListener(listenerClass);
            }
            catch (InstantiationException e) {
                s_log.error((Object)("Unable to add listener because it cannot be instantiated.  Error: " + e.getMessage()));
            }
            ((DataAssociation)this.get("listener")).add(this.createListener(listenerClass));
        }
    }

    public void removeListener(String listenerClass) {
        DataAssociationCursor cursor = this.getListenerCursor();
        cursor.addFilter(cursor.getFilterFactory().equals("listenerClass", listenerClass));
        if (cursor.next()) {
            DataObject listener = cursor.getDataObject();
            ((DataAssociation)this.get("listener")).remove(listener);
        }
        cursor.close();
    }

    public boolean hasListener(String listenerClass) {
        DataAssociationCursor cursor = this.getListenerCursor();
        while (cursor.next()) {
            if (!((String)cursor.get("listenerClass")).equals(listenerClass)) continue;
            cursor.close();
            return true;
        }
        return false;
    }

    private DataObject createListener(String listenerClass) {
        DataCollection dc = SessionManager.getSession().retrieve("com.arsdigita.kernel.PackageListener");
        dc.addFilter(dc.getFilterFactory().equals("listenerClass", listenerClass));
        if (dc.next()) {
            DataObject dataObject = dc.getDataObject();
            dc.close();
            return dataObject;
        }
        DataObject listener = SessionManager.getSession().create("com.arsdigita.kernel.PackageListener");
        listener.set("id", this.generateID());
        listener.set("listenerClass", listenerClass);
        listener.save();
        return listener;
    }

    protected PackageEventListener[] getListeners() {
        ArrayList<PackageEventListener> list = new ArrayList<PackageEventListener>();
        DataAssociationCursor cursor = this.getListenerCursor();
        while (cursor.next()) {
            try {
                list.add(this.instantiateListener((String)cursor.get("listenerClass")));
            }
            catch (InstantiationException e) {
                s_log.error((Object)e.getMessage());
            }
        }
        PackageEventListener[] listeners = new PackageEventListener[list.size()];
        for (int i = 0; i < listeners.length; ++i) {
            listeners[i] = (PackageEventListener)list.get(i);
        }
        return listeners;
    }

    private DataAssociationCursor getListenerCursor() {
        return ((DataAssociation)this.get("listener")).cursor();
    }

    private PackageEventListener instantiateListener(String className) throws InstantiationException {
        try {
            PackageEventListener pel = (PackageEventListener)Class.forName(className).newInstance();
            return pel;
        }
        catch (IllegalAccessException e) {
            String errorMsg = "Unable to access " + className + ":" + e.getMessage();
            s_log.error((Object)errorMsg);
            throw new InstantiationException(errorMsg);
        }
        catch (ClassNotFoundException e) {
            String errorMsg = "Unable to find " + className + ":" + e.getMessage();
            s_log.error((Object)errorMsg);
            throw new InstantiationException(errorMsg);
        }
    }

    public PackageInstanceCollection getInstances() {
        DataAssociation instanceAssociation = (DataAssociation)this.get("packageInstance");
        return new PackageInstanceCollection(instanceAssociation);
    }

    public static PackageType findByKey(String key) throws DataObjectNotFoundException {
        PackageType pt = PackageType.getTypeByKey(key);
        if (pt == null) {
            throw new DataObjectNotFoundException("No package type matching the key '" + key + "' was found.");
        }
        return pt;
    }

    public static boolean typeExists(String key) {
        return PackageType.getTypeByKey(key) != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static PackageType getTypeByKey(String key) {
        DataCollection dc = SessionManager.getSession().retrieve(BASE_DATA_OBJECT_TYPE);
        dc.addFilter(dc.getFilterFactory().equals("packageKey", key));
        PackageType pt = null;
        try {
            if (dc.next()) {
                pt = new PackageType(dc.getDataObject());
            }
        }
        finally {
            dc.close();
        }
        return pt;
    }

    public static PackageType create(String key, String displayName, String displayPlural, String URI2) {
        PackageType pt = new PackageType();
        pt.setKey(key);
        pt.setDisplayName(displayName);
        pt.setDisplayPlural(displayPlural);
        pt.setURI(URI2);
        pt.save();
        return pt;
    }

    public static List getAllPackageKeys() {
        ArrayList<String> keyList = new ArrayList<String>();
        DataCollection dc = SessionManager.getSession().retrieve(BASE_DATA_OBJECT_TYPE);
        while (dc.next()) {
            keyList.add((String)dc.get("packageKey"));
        }
        return keyList;
    }

    public static PackageTypeCollection retrieveAll() {
        DataCollection dataCollection = SessionManager.getSession().retrieve(BASE_DATA_OBJECT_TYPE);
        PackageTypeCollection packageTypeCollection = new PackageTypeCollection(dataCollection);
        return packageTypeCollection;
    }

    public static List getAllPackageIds() {
        ArrayList<BigDecimal> keyList = new ArrayList<BigDecimal>();
        DataCollection dc = SessionManager.getSession().retrieve(BASE_DATA_OBJECT_TYPE);
        while (dc.next()) {
            keyList.add((BigDecimal)dc.get("id"));
        }
        return keyList;
    }

    public String getPackageKey() {
        return this.getKey();
    }

    public String getServletPackage() {
        return (String)this.get("servletPackage");
    }

    public void setServletPackage(String servletPackage) {
        this.set("servletPackage", servletPackage);
    }

    public String getPrettyName() {
        return this.getDisplayName();
    }

    public void setPrettyName(String displayName) {
        this.setDisplayName(displayName);
    }

    public String getPrettyPlural() {
        return (String)this.get("prettyPlural");
    }

    public void setPrettyPlural(String prettyPlural) {
        this.set("prettyPlural", prettyPlural);
    }

    public static PackageType findPackageTypeByKey(String key) throws DataObjectNotFoundException {
        return PackageType.findByKey(key);
    }

    public static PackageType createPackageType(String key, String displayName, String displayPlural, String URI2) {
        return PackageType.create(key, displayName, displayPlural, URI2);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

