/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.kernel.permissions;

import com.arsdigita.domain.DomainQuery;
import com.arsdigita.kernel.EmailAddress;
import com.arsdigita.kernel.PersonName;
import com.arsdigita.kernel.permissions.PrivilegeDescriptor;
import com.arsdigita.persistence.DataObject;
import com.arsdigita.persistence.DataQuery;
import com.arsdigita.persistence.OID;
import java.math.BigDecimal;

public class ObjectPermissionCollection
extends DomainQuery {
    public static final String versionId = "$Id: //core-platform/dev/src/com/arsdigita/kernel/permissions/ObjectPermissionCollection.java#10 $ by $Author: dennis $, $DateTime: 2004/04/07 16:07:11 $";

    protected ObjectPermissionCollection(DataQuery query) {
        super(query);
    }

    public BigDecimal getGranteeID() {
        return (BigDecimal)this.m_dataQuery.get("granteeID");
    }

    public OID getGranteeOID() {
        if (this.granteeIsUser()) {
            return new OID("com.arsdigita.kernel.User", this.m_dataQuery.get("granteeID"));
        }
        return new OID("com.arsdigita.kernel.Group", this.m_dataQuery.get("granteeID"));
    }

    public boolean granteeIsUser() {
        return (Boolean)this.m_dataQuery.get("granteeIsUser");
    }

    public String getGranteeName() {
        if (!this.granteeIsUser()) {
            return (String)this.m_dataQuery.get("granteeName");
        }
        return this.getGranteePersonName().toString();
    }

    public PersonName getGranteePersonName() {
        if (!this.granteeIsUser()) {
            throw new RuntimeException("Grantee is a group, not a user.");
        }
        return new PersonName((DataObject)this.get("granteePersonName"));
    }

    public EmailAddress getGranteeEmail() {
        return new EmailAddress((String)this.m_dataQuery.get("granteeEmail"));
    }

    public PrivilegeDescriptor getPrivilege() {
        return PrivilegeDescriptor.get((String)this.m_dataQuery.get("privilege"));
    }

    public boolean isInherited() {
        return (Boolean)this.m_dataQuery.get("isInherited");
    }
}

