/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.kernel.permissions;

import com.arsdigita.developersupport.DeveloperSupport;
import com.arsdigita.kernel.permissions.PermissionDescriptor;
import com.arsdigita.kernel.permissions.PrivilegeDescriptor;
import com.arsdigita.persistence.DataQuery;
import com.arsdigita.persistence.OID;
import com.arsdigita.persistence.SessionManager;
import com.arsdigita.persistence.TransactionContext;
import com.arsdigita.util.Assert;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import org.apache.log4j.Logger;

public final class PermissionCache {
    private static final Logger s_log = Logger.getLogger((Class)(class$com$arsdigita$kernel$permissions$PermissionCache == null ? (class$com$arsdigita$kernel$permissions$PermissionCache = PermissionCache.class$("com.arsdigita.kernel.permissions.PermissionCache")) : class$com$arsdigita$kernel$permissions$PermissionCache));
    private static PermissionCache s_instance = new PermissionCache();
    private CollectionTxnCache m_prTxnCache = new CollectionTxnCache((class$com$arsdigita$kernel$permissions$PermissionCache == null ? (class$com$arsdigita$kernel$permissions$PermissionCache = PermissionCache.class$("com.arsdigita.kernel.permissions.PermissionCache")) : class$com$arsdigita$kernel$permissions$PermissionCache).getName() + "-perm:");
    private static String privQuery;
    private static ArrayList privNamesList;
    private static ArrayList privColumnList;
    static /* synthetic */ Class class$com$arsdigita$kernel$permissions$PermissionCache;

    private PermissionCache() {
    }

    public static PermissionCache getInstance() {
        return s_instance;
    }

    private static CollectionTxnCache getPermissionsCache() {
        return PermissionCache.getInstance().m_prTxnCache;
    }

    public boolean checkPermission(PermissionDescriptor perm) {
        OID party = perm.getPartyOID();
        OID obj = perm.getACSObjectOID();
        PrivilegeDescriptor priv = perm.getPrivilegeDescriptor();
        CollectionTxnCache cache = PermissionCache.getPermissionsCache();
        Boolean lookupResult = cache.lookup(party, obj, priv);
        if (lookupResult == null) {
            s_log.debug((Object)"Cache miss.");
            HashMap permMap = PermissionCache.getPrivilegesFromDB(party, obj);
            cache.cache(party, obj, permMap);
            lookupResult = cache.lookup(party, obj, priv);
            if (lookupResult == null) {
                return false;
            }
        } else {
            s_log.debug((Object)"Cache hit.");
        }
        return lookupResult;
    }

    private static HashMap getPrivilegesFromDB(OID party, OID obj) {
        HashMap<String, Boolean> prMap = null;
        try {
            Connection conn = SessionManager.getSession().getConnection();
            PreparedStatement stmt = conn.prepareStatement(privQuery);
            stmt.setBigDecimal(1, (BigDecimal)obj.get("id"));
            stmt.setBigDecimal(2, (BigDecimal)party.get("id"));
            long m_start = System.currentTimeMillis();
            ResultSet res = stmt.executeQuery();
            HashMap<String, Object> bindVars = new HashMap<String, Object>();
            bindVars.put("1", obj.get("id"));
            bindVars.put("2", party.get("id"));
            DeveloperSupport.logQuery(conn.hashCode(), "executeQuery", privQuery, bindVars, System.currentTimeMillis() - m_start, null);
            if (res.next()) {
                prMap = new HashMap<String, Boolean>();
                for (int i = 0; i < privNamesList.size(); ++i) {
                    if (res.getBigDecimal((String)privColumnList.get(i)) != null) {
                        prMap.put((String)privNamesList.get(i), new Boolean(true));
                        continue;
                    }
                    prMap.put((String)privNamesList.get(i), new Boolean(false));
                }
            }
            res.close();
            stmt.close();
            return prMap;
        }
        catch (SQLException e) {
            s_log.error((Object)("Couldn't retrieve user privileges! Query:" + privQuery));
            return null;
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        privNamesList = new ArrayList();
        privColumnList = new ArrayList();
        DataQuery dq = SessionManager.getSession().retrieveQuery("com.arsdigita.kernel.permissions.getAllPrivilegeColumnNameMap");
        privQuery = "select ";
        int len = (int)dq.size();
        while (dq.next()) {
            privNamesList.add(dq.getPosition() - 1, dq.get("privilegeName"));
            privColumnList.add(dq.getPosition() - 1, dq.get("columnName"));
            privQuery = privQuery + " max(" + dq.get("columnName") + ") as " + dq.get("columnName");
            privQuery = privQuery + (dq.getPosition() < len ? "," : "");
        }
        privQuery = privQuery + " from dnm_object_1_granted_context dogc,             dnm_granted_context dgc,             dnm_permissions dp,             dnm_group_membership dgm          where dogc.pd_object_id = ?          and dogc.pd_context_id = dgc.pd_object_id          and dgc.pd_context_id = dp.pd_object_id          and dgm.pd_member_id = ?          and dp.pd_grantee_id = dgm.pd_group_id";
    }

    private class CollectionTxnCache {
        private String m_prefix;

        public CollectionTxnCache(String prefix) {
            this.m_prefix = prefix;
        }

        private String attributeName(OID party, OID object) {
            return this.m_prefix + ":" + party.get("id") + ":" + object.get("id");
        }

        public void cache(OID party, OID object, HashMap privilegeMap) {
            this.getTxn().setAttribute(this.attributeName(party, object), privilegeMap);
        }

        public Boolean lookup(OID party, OID object, PrivilegeDescriptor privilege) {
            HashMap cache = (HashMap)this.getTxn().getAttribute(this.attributeName(party, object));
            if (cache == null) {
                return null;
            }
            Boolean result = (Boolean)cache.get(privilege.getName());
            if (result == null) {
                s_log.error((Object)"Could'nt find key in the permission cache", new Throwable());
                return Boolean.FALSE;
            }
            return result;
        }

        private TransactionContext getTxn() {
            TransactionContext txn = SessionManager.getSession().getTransactionContext();
            Assert.exists(txn, txn.getClass());
            Assert.truth(txn.inTxn(), "Not in a transaction");
            return txn;
        }
    }
}

