/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.kernel.permissions;

import com.arsdigita.domain.DomainObject;
import com.arsdigita.domain.GlobalObserver;
import com.arsdigita.kernel.ACSObject;
import com.arsdigita.kernel.Kernel;
import com.arsdigita.kernel.KernelHelper;
import com.arsdigita.kernel.Party;
import com.arsdigita.kernel.permissions.PrivilegeDescriptor;
import com.arsdigita.persistence.DataObject;
import com.arsdigita.persistence.metadata.ObjectType;
import org.apache.log4j.Logger;

public class PermissionsObserver
implements GlobalObserver {
    private static final Logger s_log = Logger.getLogger((Class)(class$com$arsdigita$kernel$permissions$PermissionsObserver == null ? (class$com$arsdigita$kernel$permissions$PermissionsObserver = PermissionsObserver.class$("com.arsdigita.kernel.permissions.PermissionsObserver")) : class$com$arsdigita$kernel$permissions$PermissionsObserver));
    static /* synthetic */ Class class$com$arsdigita$kernel$permissions$PermissionsObserver;

    public void set(DomainObject dobj, String name, Object old_value, Object new_value) {
    }

    public void add(DomainObject dobj, String name, DataObject dataObject) {
    }

    public void remove(DomainObject dobj, String name, DataObject dataObject) {
    }

    public void clear(DomainObject dobj, String name) {
    }

    public void beforeSave(DomainObject dobj) {
        if (this.isKernelMode()) {
            if (s_log.isDebugEnabled()) {
                s_log.debug((Object)("In kernel mode so skipping " + (dobj.isNew() ? "CREATE" : "EDIT") + " privilege check on object " + dobj.getOID()));
            }
            return;
        }
        if (dobj.isNew()) {
            ((ACSObject)dobj).doCreateCheck();
        } else {
            ((ACSObject)dobj).doWriteCheck();
        }
    }

    public void afterSave(DomainObject dobj) {
    }

    public void beforeDelete(DomainObject dobj) {
        if (this.isKernelMode()) {
            if (s_log.isDebugEnabled()) {
                s_log.debug((Object)("In kernel mode so skipping ADMIN privilege check on object " + dobj.getOID()));
            }
            return;
        }
        ((ACSObject)dobj).assertPrivilege(PrivilegeDescriptor.ADMIN);
    }

    public void afterDelete(DomainObject dobj) {
    }

    public boolean shouldObserve(DomainObject dobj) {
        ObjectType type = dobj.getObjectType();
        return type.isSubtypeOf("com.arsdigita.kernel.ACSObject");
    }

    private boolean isKernelMode() {
        Party currentParty = KernelHelper.getCurrentEffectiveParty();
        return currentParty != null && currentParty.getID().equals(Kernel.getSystemParty().getID());
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

