/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.kernel.security;

import com.arsdigita.initializer.Configuration;
import com.arsdigita.initializer.InitializationException;
import com.arsdigita.kernel.Kernel;
import com.arsdigita.kernel.SiteNode;
import com.arsdigita.kernel.security.LoginConfig;
import com.arsdigita.kernel.security.LoginContext;
import com.arsdigita.kernel.security.SecurityConfig;
import com.arsdigita.kernel.security.SecurityHelper;
import com.arsdigita.kernel.security.SecurityParameterProvider;
import com.arsdigita.kernel.security.Util;
import com.arsdigita.util.URLRewriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.security.auth.login.LoginException;
import javax.servlet.http.HttpServletRequest;
import org.apache.log4j.Logger;

public class Initializer
implements com.arsdigita.initializer.Initializer {
    public static final String versionId = "$Id: //core-platform/dev/src/com/arsdigita/kernel/security/Initializer.java#20 $ by $Author: dennis $, $DateTime: 2004/04/07 16:07:11 $";
    private static final Logger s_log = Logger.getLogger((Class)(class$com$arsdigita$kernel$security$Initializer == null ? (class$com$arsdigita$kernel$security$Initializer = Initializer.class$("com.arsdigita.kernel.security.Initializer")) : class$com$arsdigita$kernel$security$Initializer));
    public static String SESSION_TRACKING_PARAM = "sessionTrackingMethod";
    public static String LOGIN_CONFIG_PARAM = "loginConfig";
    public static String SECURITY_HELPER_PARAM = "securityHelperClass";
    public static String EXCLUDED_EXTENSIONS_PARAM = "excludedExtensions";
    public static int SECRET_KEY_BYTES = 16;
    public static String AUTO_REGISTRATION_ON_PARAM = "autoRegistrationOn";
    private static boolean s_autoRegistrationOn;
    private Configuration m_conf = new Configuration();
    private static List s_exts;
    public static String ROOT_PAGE_KEY;
    public static String EDIT_PAGE_KEY;
    public static String LOGIN_PAGE_KEY;
    public static String NEWUSER_PAGE_KEY;
    public static String LOGOUT_PAGE_KEY;
    public static String COOKIES_PAGE_KEY;
    public static String EXPIRED_PAGE_KEY;
    public static String CHANGE_PAGE_KEY;
    public static String RECOVER_PAGE_KEY;
    public static String WORKSPACE_PAGE_KEY;
    public static String LOGIN_REDIRECT_PAGE_KEY;
    public static String PERMISSION_PAGE_KEY;
    public static String PERM_SINGLE_PAGE_KEY;
    private static List s_defaultPageMap;
    private static Map s_pageMap;
    static /* synthetic */ Class class$com$arsdigita$kernel$security$Initializer;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$com$arsdigita$kernel$security$DefaultSecurityHelper;
    static /* synthetic */ Class class$java$util$List;
    static /* synthetic */ Class class$java$lang$Boolean;
    static /* synthetic */ Class class$com$arsdigita$kernel$security$SecurityHelper;

    public Configuration getConfiguration() {
        return this.m_conf;
    }

    public Initializer() throws InitializationException {
        this.m_conf.initParameter(SECURITY_HELPER_PARAM, "The class name of the SecurityHelper implementation", class$java$lang$String == null ? (class$java$lang$String = Initializer.class$("java.lang.String")) : class$java$lang$String, (class$com$arsdigita$kernel$security$DefaultSecurityHelper == null ? (class$com$arsdigita$kernel$security$DefaultSecurityHelper = Initializer.class$("com.arsdigita.kernel.security.DefaultSecurityHelper")) : class$com$arsdigita$kernel$security$DefaultSecurityHelper).getName());
        this.m_conf.initParameter(SESSION_TRACKING_PARAM, "This parameter is obsolete.", class$java$lang$String == null ? (class$java$lang$String = Initializer.class$("java.lang.String")) : class$java$lang$String);
        this.m_conf.initParameter(LOGIN_CONFIG_PARAM, "The login configuration.", class$java$util$List == null ? (class$java$util$List = Initializer.class$("java.util.List")) : class$java$util$List);
        this.m_conf.initParameter(EXCLUDED_EXTENSIONS_PARAM, "List of extensions excluded from authentication cookies. Authentication is checked for all requests, but requests with one of these extensions will never cause a new cookie to be set.  Include a leading dot for each extension.", class$java$util$List == null ? (class$java$util$List = Initializer.class$("java.util.List")) : class$java$util$List, Arrays.asList(".jpg", ".gif", ".png", ".pdf"));
        this.m_conf.initParameter(AUTO_REGISTRATION_ON_PARAM, "When this parameter is set to true, new users get automaticallyredirected to the create new user form", class$java$lang$Boolean == null ? (class$java$lang$Boolean = Initializer.class$("java.lang.Boolean")) : class$java$lang$Boolean, Boolean.TRUE);
    }

    private void loadAutoRegistrationOn() {
        s_autoRegistrationOn = (Boolean)this.m_conf.getParameter(AUTO_REGISTRATION_ON_PARAM);
    }

    public static boolean getAutoRegistrationOn() {
        return s_autoRegistrationOn;
    }

    public void startup() throws InitializationException {
        URLRewriter.addParameterProvider(new SecurityParameterProvider());
        this.loadExcludedExtensions();
        this.loadSecurityHelper();
        this.loadPageMap();
        this.loadLoginConfig();
        this.loadAutoRegistrationOn();
    }

    public static Iterator getExcludedExtensions() {
        if (s_exts == null) {
            return Collections.EMPTY_LIST.iterator();
        }
        return s_exts.iterator();
    }

    private void loadExcludedExtensions() {
        s_exts = (List)this.m_conf.getParameter(EXCLUDED_EXTENSIONS_PARAM);
        Iterator exts = Initializer.getExcludedExtensions();
        while (exts.hasNext()) {
            Object o = exts.next();
            if (o instanceof String) continue;
            throw new InitializationException("Extension must be a string: " + o);
        }
    }

    public static SecurityHelper getSecurityHelper() {
        return Util.getSecurityHelper();
    }

    private void loadSecurityHelper() {
        String name = (String)this.m_conf.getParameter(SECURITY_HELPER_PARAM);
        if (name == null) {
            throw new InitializationException(SECURITY_HELPER_PARAM + " not defined");
        }
        try {
            Class<?> theClass = Class.forName(name);
            if (!(class$com$arsdigita$kernel$security$SecurityHelper == null ? (class$com$arsdigita$kernel$security$SecurityHelper = Initializer.class$("com.arsdigita.kernel.security.SecurityHelper")) : class$com$arsdigita$kernel$security$SecurityHelper).isAssignableFrom(theClass)) {
                throw new InitializationException(SECURITY_HELPER_PARAM + ": " + name + " does not implement interface " + (class$com$arsdigita$kernel$security$SecurityHelper == null ? (class$com$arsdigita$kernel$security$SecurityHelper = Initializer.class$("com.arsdigita.kernel.security.SecurityHelper")) : class$com$arsdigita$kernel$security$SecurityHelper).getName());
            }
            Util.setSecurityHelper(theClass.newInstance());
        }
        catch (ClassNotFoundException e) {
            throw new InitializationException(SECURITY_HELPER_PARAM + ": " + name + " not found: ", e);
        }
        catch (InstantiationException e) {
            throw new InitializationException(SECURITY_HELPER_PARAM + ": " + name + " is not concrete or lacks no-arg constructor: ", e);
        }
        catch (IllegalAccessException e) {
            throw new InitializationException(SECURITY_HELPER_PARAM + ": " + name + " is not public or lacks public constructor: ", e);
        }
    }

    private void loadPageMap() throws InitializationException {
        this.loadPageMap(s_defaultPageMap);
        ArrayList list = new ArrayList(){
            {
                SecurityConfig conf = Kernel.getSecurityConfig();
                this.put(ROOT_PAGE_KEY, conf.getRootPage());
                this.put(LOGIN_PAGE_KEY, conf.getLoginPage());
                this.put(NEWUSER_PAGE_KEY, conf.getNewUserPage());
                this.put(LOGOUT_PAGE_KEY, conf.getLogoutPage());
                this.put(COOKIES_PAGE_KEY, conf.getCookiesPage());
                this.put(CHANGE_PAGE_KEY, conf.getChangePage());
                this.put(RECOVER_PAGE_KEY, conf.getRecoverPage());
                this.put(EXPIRED_PAGE_KEY, conf.getExpiredPage());
                this.put(WORKSPACE_PAGE_KEY, conf.getWorkspacePage());
                this.put(LOGIN_REDIRECT_PAGE_KEY, conf.getLoginRedirectPage());
                this.put(PERMISSION_PAGE_KEY, conf.getPermissionPage());
                this.put(PERM_SINGLE_PAGE_KEY, conf.getPermSinglePage());
            }

            private void put(String key, String value) {
                this.add(Arrays.asList(key, value));
            }
        };
        if (list != null) {
            s_log.info((Object)("Security Initializer: mapping " + list.size() + " pages"));
            this.loadPageMap(list);
        }
    }

    private void loadPageMap(List list) {
        Iterator pairs = list.iterator();
        while (pairs.hasNext()) {
            List pair = (List)pairs.next();
            String key = (String)pair.get(0);
            String url = (String)pair.get(1);
            s_pageMap.put(key, url);
        }
    }

    public static String getURL(String key) {
        return (String)s_pageMap.get(key);
    }

    public static String getFullURL(String key, HttpServletRequest req) {
        String root = Initializer.getRootURL(req);
        String url = Initializer.getURL(key);
        if (s_log.isDebugEnabled()) {
            s_log.debug((Object)("Root is " + root + ", url is " + url));
        }
        if (root == null || key == null) {
            return null;
        }
        return root + url;
    }

    private static String getRootURL(HttpServletRequest req) {
        return SiteNode.getRootSiteNode().getURL();
    }

    private void loadLoginConfig() throws InitializationException {
        this.checkLibrary();
        javax.security.auth.login.Configuration.setConfiguration(this.getLoginConfig());
        this.checkLoginConfig();
    }

    private void checkLibrary() throws InitializationException {
        try {
            ClassLoader.getSystemClassLoader().loadClass("javax.security.auth.Subject");
            ClassLoader.getSystemClassLoader().loadClass("javax.security.auth.login.Configuration");
            ClassLoader.getSystemClassLoader().loadClass("com.sun.security.auth.login.ConfigFile");
            s_log.info((Object)"Security Initializer: JAAS lib found");
        }
        catch (ClassNotFoundException e) {
            Initializer.reportMissingLibrary("Java Authentication and Authorization Service (JAAS)", "jaas.jar");
        }
    }

    private javax.security.auth.login.Configuration getLoginConfig() throws InitializationException {
        List list = (List)this.m_conf.getParameter(LOGIN_CONFIG_PARAM);
        if (list == null) {
            throw new InitializationException(LOGIN_CONFIG_PARAM + " not defined " + "(update enterprise.init to get the default login config; " + "loginConfig replaces loginConfigFileName and eliminates " + "the need to use a separate file for this information)");
        }
        return new LoginConfig(list);
    }

    private void checkLoginConfig() throws InitializationException {
        String[] contexts = new String[]{"Request", "Register"};
        for (int i = 0; i < contexts.length; ++i) {
            try {
                new LoginContext(contexts[i]);
                continue;
            }
            catch (LoginException e) {
                throw new InitializationException("Could not instantiate login context '" + contexts[i] + "'.  " + "Check that it is defined in your login " + "configuration.", e);
            }
        }
    }

    static void reportMissingLibrary(String libraryName, String libraryJar) throws InitializationException {
        throw new InitializationException("Could not find the " + libraryName + ".  " + "This library (" + libraryJar + ") " + "must be on your CLASSPATH or " + "in your extensions directory " + "($JAVA_HOME/jre/lib/ext/).");
    }

    public void shutdown() throws InitializationException {
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        s_exts = null;
        ROOT_PAGE_KEY = "com.arsdigita.page.kernel.root";
        EDIT_PAGE_KEY = "com.arsdigita.page.kernel.edit";
        LOGIN_PAGE_KEY = "com.arsdigita.page.kernel.login";
        NEWUSER_PAGE_KEY = "com.arsdigita.page.kernel.newuser";
        LOGOUT_PAGE_KEY = "com.arsdigita.page.kernel.logout";
        COOKIES_PAGE_KEY = "com.arsdigita.page.kernel.cookies";
        EXPIRED_PAGE_KEY = "com.arsdigita.page.kernel.expired";
        CHANGE_PAGE_KEY = "com.arsdigita.page.kernel.change";
        RECOVER_PAGE_KEY = "com.arsdigita.page.kernel.recover";
        WORKSPACE_PAGE_KEY = "com.arsdigita.page.kernel.workspace";
        LOGIN_REDIRECT_PAGE_KEY = "com.arsdigita.page.kernel.login.redirect";
        PERMISSION_PAGE_KEY = "com.arsdigita.page.kernel.permission";
        PERM_SINGLE_PAGE_KEY = "com.arsdigita.page.kernel.perm-single";
        s_defaultPageMap = new ArrayList(){
            {
                this.put(ROOT_PAGE_KEY, "register/");
                this.put(EDIT_PAGE_KEY, "register/edit-profile");
                this.put(LOGIN_PAGE_KEY, "register/");
                this.put(NEWUSER_PAGE_KEY, "register/new-user");
                this.put(LOGOUT_PAGE_KEY, "register/logout");
                this.put(COOKIES_PAGE_KEY, "register/explain-persistent-cookies");
                this.put(CHANGE_PAGE_KEY, "register/change-password");
                this.put(RECOVER_PAGE_KEY, "register/recover-password");
                this.put(EXPIRED_PAGE_KEY, "register/login-expired");
                this.put(WORKSPACE_PAGE_KEY, "pvt/");
                this.put(LOGIN_REDIRECT_PAGE_KEY, "pvt/");
                this.put(PERMISSION_PAGE_KEY, "permissions/");
                this.put(PERM_SINGLE_PAGE_KEY, "permissions/one");
            }

            private void put(String key, String value) {
                this.add(Arrays.asList(key, value));
            }
        };
        s_pageMap = new HashMap();
    }
}

