/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.kernel.security;

import com.arsdigita.kernel.security.KernelLoginException;
import java.io.IOException;
import java.util.Map;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.LoginException;
import javax.security.auth.spi.LoginModule;
import org.apache.log4j.Logger;

public abstract class PasswordLoginModule
implements LoginModule {
    public static final String versionId = "$Id: //core-platform/dev/src/com/arsdigita/kernel/security/PasswordLoginModule.java#9 $ by $Author: dennis $, $DateTime: 2004/04/07 16:07:11 $";
    private static final Logger s_log = Logger.getLogger((String)(class$com$arsdigita$kernel$security$PasswordLoginModule == null ? (class$com$arsdigita$kernel$security$PasswordLoginModule = PasswordLoginModule.class$("com.arsdigita.kernel.security.PasswordLoginModule")) : class$com$arsdigita$kernel$security$PasswordLoginModule).getName());
    public static final String NAME_KEY = "javax.security.auth.login.name";
    public static final String PASSWORD_KEY = "javax.security.auth.login.password";
    private Subject m_subject;
    private CallbackHandler m_handler;
    private Map m_shared;
    private Map m_options;
    static /* synthetic */ Class class$com$arsdigita$kernel$security$PasswordLoginModule;

    public void initialize(Subject subject, CallbackHandler handler, Map shared, Map options) {
        this.m_subject = subject;
        this.m_handler = handler;
        this.m_shared = shared;
        this.m_options = options;
    }

    public boolean login() throws LoginException {
        s_log.debug((Object)"START login");
        this.checkPassword(this.getUsername(), this.getPassword());
        s_log.debug((Object)"SUCCESS login");
        return true;
    }

    private String getUsername() throws LoginException {
        String username = (String)this.m_shared.get(NAME_KEY);
        if (username != null) {
            return username;
        }
        try {
            NameCallback cb = new NameCallback("Username: ");
            this.m_handler.handle(new Callback[]{cb});
            username = cb.getName();
            this.m_shared.put(NAME_KEY, username);
            return username;
        }
        catch (UnsupportedCallbackException e) {
            throw new KernelLoginException("Could not get username", e);
        }
        catch (IOException e) {
            throw new KernelLoginException("Could not get username", e);
        }
    }

    private char[] getPassword() throws LoginException {
        char[] password = (char[])this.m_shared.get(PASSWORD_KEY);
        if (password != null) {
            return password;
        }
        try {
            PasswordCallback cb = new PasswordCallback("Password: ", false);
            this.m_handler.handle(new Callback[]{cb});
            password = cb.getPassword();
            this.m_shared.put(PASSWORD_KEY, password);
            return password;
        }
        catch (UnsupportedCallbackException e) {
            throw new KernelLoginException("Could not get password", e);
        }
        catch (IOException e) {
            throw new KernelLoginException("Could not get password", e);
        }
    }

    protected abstract void checkPassword(String var1, char[] var2) throws LoginException;

    public abstract boolean commit() throws LoginException;

    public abstract boolean abort() throws LoginException;

    public abstract boolean logout() throws LoginException;

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

