/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.kernel.security;

import com.arsdigita.kernel.security.Credential;
import com.arsdigita.kernel.security.CredentialEncodingException;
import com.arsdigita.kernel.security.URLManager;
import com.arsdigita.kernel.security.UserLoginModule;
import java.math.BigDecimal;
import java.util.Collections;
import java.util.Map;
import javax.security.auth.Subject;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.login.LoginException;
import org.apache.log4j.Logger;

public class RecoveryLoginModule
extends UserLoginModule {
    public static final String versionId = "$Id: //core-platform/dev/src/com/arsdigita/kernel/security/RecoveryLoginModule.java#10 $ by $Author: dennis $, $DateTime: 2004/04/07 16:07:11 $";
    private static final Logger s_log = Logger.getLogger((String)(class$com$arsdigita$kernel$security$RecoveryLoginModule == null ? (class$com$arsdigita$kernel$security$RecoveryLoginModule = RecoveryLoginModule.class$("com.arsdigita.kernel.security.RecoveryLoginModule")) : class$com$arsdigita$kernel$security$RecoveryLoginModule).getName());
    private static final String URL_PARAM_NAME = "ad_user_recover";
    private Subject m_subject;
    private CallbackHandler m_handler;
    private Map m_shared;
    private Map m_options;
    static /* synthetic */ Class class$com$arsdigita$kernel$security$RecoveryLoginModule;

    public RecoveryLoginModule() {
        super(new URLManager(Collections.EMPTY_SET){

            protected boolean shouldSetValue(String value) throws LoginException {
                return false;
            }
        });
    }

    public void initialize(Subject subject, CallbackHandler handler, Map shared, Map options) {
        super.initialize(subject, handler, shared, options);
        this.m_subject = subject;
        this.m_handler = handler;
        this.m_shared = shared;
        this.m_options = options;
    }

    public boolean commit() throws LoginException {
        if (this.credentialIsSet()) {
            this.setRecovering();
        }
        return super.commit();
    }

    public boolean abort() throws LoginException {
        return this.commit();
    }

    protected String getCredentialName() throws LoginException {
        return RecoveryLoginModule.getParamName();
    }

    private void setRecovering() {
        s_log.debug((Object)"setting recovery credential");
        this.m_subject.getPublicCredentials().add(RecoveryLoginModule.getParamName());
    }

    public static boolean isRecovering(Subject subject) {
        return subject.getPublicCredentials().contains(RecoveryLoginModule.getParamName());
    }

    public static String getParamName() {
        return URL_PARAM_NAME;
    }

    public static String getParamValue(BigDecimal userID) throws CredentialEncodingException {
        return Credential.create(userID.toString(), 1200000L).toString();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

