/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.kernel.ui;

import com.arsdigita.bebop.CompoundComponent;
import com.arsdigita.bebop.ExcursionComponent;
import com.arsdigita.bebop.Form;
import com.arsdigita.bebop.FormProcessException;
import com.arsdigita.bebop.FormSection;
import com.arsdigita.bebop.Label;
import com.arsdigita.bebop.ModalContainer;
import com.arsdigita.bebop.Page;
import com.arsdigita.bebop.PageState;
import com.arsdigita.bebop.RequestLocal;
import com.arsdigita.bebop.SimpleContainer;
import com.arsdigita.bebop.event.ActionEvent;
import com.arsdigita.bebop.event.ActionListener;
import com.arsdigita.bebop.event.FormInitListener;
import com.arsdigita.bebop.event.FormProcessListener;
import com.arsdigita.bebop.event.FormSectionEvent;
import com.arsdigita.bebop.event.PrintEvent;
import com.arsdigita.bebop.event.PrintListener;
import com.arsdigita.bebop.form.FormErrorDisplay;
import com.arsdigita.bebop.form.Option;
import com.arsdigita.bebop.form.SingleSelect;
import com.arsdigita.bebop.form.Submit;
import com.arsdigita.bebop.form.TextField;
import com.arsdigita.bebop.parameters.BigDecimalParameter;
import com.arsdigita.domain.DataObjectNotFoundException;
import com.arsdigita.domain.DomainObjectFactory;
import com.arsdigita.globalization.GlobalizedMessage;
import com.arsdigita.kernel.Party;
import com.arsdigita.kernel.PartyCollection;
import com.arsdigita.kernel.ui.Globalized;
import com.arsdigita.persistence.OID;
import com.arsdigita.util.Assert;
import com.arsdigita.util.UncheckedWrapperException;
import java.math.BigDecimal;
import java.util.TooManyListenersException;

public class PartySearchSelect
extends CompoundComponent
implements ExcursionComponent,
Globalized {
    private Search m_partySearch;
    private PartySelect m_partySelect;
    private RequestLocal m_searchResults;

    public PartySearchSelect() {
        this.m_partySearch = new Search();
        this.init();
    }

    public PartySearchSelect(RequestLocal basePartyCollection) {
        this.m_partySearch = new Search(basePartyCollection);
        this.init();
    }

    private void init() {
        this.m_searchResults = new RequestLocal(){

            public Object initialValue(PageState ps) {
                return PartySearchSelect.this.getSearchQuery(ps);
            }
        };
        this.m_partySelect = new PartySelect(this.m_searchResults);
        this.m_partySearch.addCompletionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                PageState ps = e.getPageState();
                PartySearchSelect.this.m_partySelect.setVisible(ps, true);
                PartySearchSelect.this.m_partySearch.setVisible(ps, false);
            }
        });
        this.m_partySelect.addCompletionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                PageState ps = e.getPageState();
                PartySearchSelect.this.m_partySelect.setVisible(ps, false);
                PartySearchSelect.this.m_partySearch.setVisible(ps, true);
                PartySearchSelect.this.fireCompletionEvent(ps);
            }
        });
        this.add(this.m_partySearch);
        this.add(this.m_partySelect);
    }

    public void setBaseQuery(PageState ps, PartyCollection parties) {
        this.m_partySearch.setBaseQuery(ps, parties);
    }

    public PartyCollection getSearchQuery(PageState ps) {
        return this.m_partySearch.getSearchQuery(ps);
    }

    public void addSearchFormSection(FormSection formSection) {
        this.m_partySearch.addFormSection(formSection);
    }

    public Party getSelectedParty(PageState ps) {
        return this.m_partySelect.getSelectedParty(ps);
    }

    public void register(Page p) {
        super.register(p);
        p.setVisibleDefault(this.m_partySelect, false);
        p.setVisibleDefault(this.m_partySearch, true);
    }

    private static class PartySelect
    extends CompoundComponent {
        private Label m_emptyView;
        private Form m_form;
        private SingleSelect m_select;
        private ModalContainer m_selectContainer;
        private RequestLocal m_partyQuery;
        private Submit m_submit;
        private Submit m_cancel;

        public PartySelect(RequestLocal parties) {
            this.m_partyQuery = parties;
            this.m_form = new Form("partyselect");
            this.add(this.m_form);
            this.m_selectContainer = new ModalContainer();
            this.m_form.add(this.m_selectContainer);
            this.m_select = new SingleSelect(new BigDecimalParameter("partySearchResult"));
            this.m_selectContainer.add(this.m_select);
            this.m_selectContainer.setDefaultComponent(this.m_select);
            try {
                this.m_select.addPrintListener(new PrintListener(this){
                    private final /* synthetic */ PartySelect this$0;
                    {
                        this.this$0 = this$0;
                    }

                    public void prepare(PrintEvent evt) {
                        this.this$0.initPartyChoices(evt.getPageState());
                    }
                });
            }
            catch (TooManyListenersException e) {
                Assert.fail(e.getMessage());
            }
            this.m_emptyView = new Label(new GlobalizedMessage("kernel.ui.no_users_or_groups_found", "com.arsdigita.kernel/ui/KernelResources"));
            this.m_emptyView.setFontWeight("i");
            this.m_selectContainer.add(this.m_emptyView);
            this.m_form.add(new Label());
            this.m_cancel = new Submit("Cancel");
            this.m_form.add(this.m_cancel, 4);
            this.m_submit = new Submit("OK");
            this.m_form.add(this.m_submit);
            this.m_form.addInitListener(new FormInitListener(this){
                private final /* synthetic */ PartySelect this$0;
                {
                    this.this$0 = this$0;
                }

                public void init(FormSectionEvent evt) {
                    this.this$0.init(evt.getPageState());
                }
            });
            this.m_form.addProcessListener(new FormProcessListener(this){
                private final /* synthetic */ PartySelect this$0;
                {
                    this.this$0 = this$0;
                }

                public void process(FormSectionEvent evt) throws FormProcessException {
                    this.this$0.process(evt.getPageState());
                }
            });
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void initPartyChoices(PageState ps) {
            PartyCollection parties = (PartyCollection)this.m_partyQuery.get(ps);
            boolean isEmpty = true;
            try {
                while (parties.next()) {
                    isEmpty = false;
                    this.m_select.addOption(new Option(parties.getID().toString(), parties.getDisplayName()), ps);
                }
            }
            finally {
                parties.close();
            }
        }

        protected void init(PageState ps) {
            PartyCollection parties = (PartyCollection)this.m_partyQuery.get(ps);
            if (parties.size() == 0L) {
                this.m_selectContainer.setVisibleComponent(ps, this.m_emptyView);
            } else {
                this.m_selectContainer.setVisibleComponent(ps, this.m_select);
            }
        }

        protected void process(PageState ps) {
            this.fireCompletionEvent(ps);
        }

        public Party getSelectedParty(PageState ps) {
            if (this.m_emptyView.isVisible(ps)) {
                return null;
            }
            if (!this.m_submit.isSelected(ps)) {
                return null;
            }
            BigDecimal partyID = (BigDecimal)this.m_select.getValue(ps);
            if (partyID == null) {
                return null;
            }
            try {
                return (Party)DomainObjectFactory.newInstance(new OID("com.arsdigita.kernel.Party", (Object)partyID));
            }
            catch (DataObjectNotFoundException ex) {
                throw new UncheckedWrapperException(ex.getMessage());
            }
        }
    }

    public static class Search
    extends CompoundComponent {
        private RequestLocal m_partyQuery;
        private SimpleContainer m_formSections;

        public Search() {
            this(new RequestLocal(){

                public Object initialValue(PageState ps) {
                    return Party.retrieveAllParties();
                }
            });
        }

        public Search(RequestLocal basePartyCollection) {
            Assert.assertTrue(basePartyCollection != null);
            this.m_partyQuery = basePartyCollection;
            Form partySearch = new Form("partysearch");
            partySearch.setMethod("post");
            this.add(partySearch);
            partySearch.add(new FormErrorDisplay(partySearch), 64);
            partySearch.add(new Label("Search users and groups whose names contain:"));
            TextField query = new TextField("query");
            partySearch.add(query);
            partySearch.add(new Label(""));
            this.m_formSections = new SimpleContainer();
            partySearch.add(this.m_formSections);
            partySearch.add(new Submit("Search"));
            partySearch.addProcessListener(new FormProcessListener(this, query){
                private final /* synthetic */ TextField val$query;
                private final /* synthetic */ Search this$0;
                {
                    this.this$0 = this$0;
                    this.val$query = val$query;
                }

                public void process(FormSectionEvent e) throws FormProcessException {
                    PageState ps = e.getPageState();
                    PartyCollection parties = Party.retrieveAllParties();
                    parties.filter((String)this.val$query.getValue(ps));
                    Search.access$300(this.this$0).set(ps, (Object)parties);
                    Search.access$400(this.this$0, ps);
                }
            });
        }

        public void setBaseQuery(PageState ps, PartyCollection parties) {
            this.m_partyQuery.set(ps, (Object)parties);
        }

        public PartyCollection getSearchQuery(PageState ps) {
            return (PartyCollection)this.m_partyQuery.get(ps);
        }

        public void addFormSection(FormSection formSection) {
            this.m_formSections.add(formSection);
        }

        static /* synthetic */ RequestLocal access$300(Search x0) {
            return x0.m_partyQuery;
        }

        static /* synthetic */ void access$400(Search x0, PageState x1) {
            x0.fireCompletionEvent(x1);
        }
    }
}

