/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.loader;

import com.arsdigita.domain.DataObjectNotFoundException;
import com.arsdigita.kernel.EmailAddress;
import com.arsdigita.kernel.Kernel;
import com.arsdigita.kernel.KernelExcursion;
import com.arsdigita.kernel.PackageInstance;
import com.arsdigita.kernel.PackageType;
import com.arsdigita.kernel.ResourceType;
import com.arsdigita.kernel.SiteNode;
import com.arsdigita.kernel.Stylesheet;
import com.arsdigita.kernel.User;
import com.arsdigita.kernel.UserAuthentication;
import com.arsdigita.kernel.permissions.PermissionService;
import com.arsdigita.kernel.permissions.PrivilegeDescriptor;
import com.arsdigita.kernel.permissions.UniversalPermissionDescriptor;
import com.arsdigita.kernel.security.KeyStorage;
import com.arsdigita.loader.MimeTypeRow;
import com.arsdigita.loader.PackageLoader;
import com.arsdigita.mimetypes.ImageMimeType;
import com.arsdigita.mimetypes.MimeType;
import com.arsdigita.mimetypes.MimeTypeExtension;
import com.arsdigita.mimetypes.TextMimeType;
import com.arsdigita.runtime.ScriptContext;
import com.arsdigita.search.lucene.Initializer;
import com.arsdigita.util.Assert;
import com.arsdigita.util.StringUtils;
import com.arsdigita.util.UncheckedWrapperException;
import com.arsdigita.util.csv.CSVParameterLoader;
import com.arsdigita.util.parameter.StringParameter;
import com.arsdigita.util.servlet.HttpHost;
import com.arsdigita.web.Application;
import com.arsdigita.web.ApplicationType;
import com.arsdigita.web.Host;
import com.arsdigita.web.Web;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Locale;
import org.apache.log4j.Logger;

public class CoreLoader
extends PackageLoader {
    public static final String versionId = "$Id: //core-platform/dev/src/com/arsdigita/loader/CoreLoader.java#14 $ by $Author: dennis $, $DateTime: 2004/04/07 16:07:11 $";
    private static final Logger s_log = Logger.getLogger((Class)(class$com$arsdigita$loader$CoreLoader == null ? (class$com$arsdigita$loader$CoreLoader = CoreLoader.class$("com.arsdigita.loader.CoreLoader")) : class$com$arsdigita$loader$CoreLoader));
    private StringParameter m_email = new StringParameter("waf.admin.email", 1, null);
    private StringParameter m_screen = new StringParameter("waf.admin.name.screen", 0, null){

        public Object getDefaultValue() {
            String email = CoreLoader.this.getEmail();
            if (email == null) {
                return null;
            }
            int index = email.indexOf("@");
            if (index > 0) {
                return email.substring(0, index);
            }
            return email;
        }
    };
    private StringParameter m_given = new StringParameter("waf.admin.name.given", 1, null);
    private StringParameter m_family = new StringParameter("waf.admin.name.family", 1, null);
    private StringParameter m_password = new StringParameter("waf.admin.password", 1, null);
    private StringParameter m_question = new StringParameter("waf.admin.password.question", 1, null);
    private StringParameter m_answer = new StringParameter("waf.admin.password.answer", 1, null);
    private StringParameter m_stylesheet = new StringParameter("waf.login.stylesheet", 0, "login_en.xsl");
    private StringParameter m_dispatcher = new StringParameter("waf.login.dispatcher", 0, "com.arsdigita.ui.login.SubsiteDispatcher");
    private StringParameter m_resource = new StringParameter("waf.mime.resource", 0, "com/arsdigita/loader/mimetypes.properties");
    private static final String XSL_ROOT = "/packages/acs-admin/xsl/";
    static /* synthetic */ Class class$com$arsdigita$loader$CoreLoader;
    static /* synthetic */ Class class$com$arsdigita$util$servlet$HttpHost;

    public CoreLoader() {
        this.register(this.m_email);
        this.register(this.m_screen);
        this.register(this.m_given);
        this.register(this.m_family);
        this.register(this.m_password);
        this.register(this.m_question);
        this.register(this.m_answer);
        this.register(this.m_stylesheet);
        this.register(this.m_dispatcher);
        this.register(this.m_resource);
        this.loadInfo();
    }

    private String getEmail() {
        return (String)this.get(this.m_email);
    }

    private String getScreen() {
        return (String)this.get(this.m_screen);
    }

    private String getGiven() {
        return (String)this.get(this.m_given);
    }

    private String getFamily() {
        return (String)this.get(this.m_family);
    }

    private String getPassword() {
        return (String)this.get(this.m_password);
    }

    private String getQuestion() {
        return (String)this.get(this.m_question);
    }

    private String getAnswer() {
        return (String)this.get(this.m_answer);
    }

    private String getStylesheet() {
        return (String)this.get(this.m_stylesheet);
    }

    private String getDispatcher() {
        return (String)this.get(this.m_dispatcher);
    }

    private String getResource() {
        return (String)this.get(this.m_resource);
    }

    public void run(ScriptContext ctx) {
        new KernelExcursion(){

            public void excurse() {
                this.setEffectiveParty(Kernel.getSystemParty());
                KeyStorage.KERNEL_KEY_STORE.init();
                CoreLoader.loadHost();
                CoreLoader.this.loadSubsite(CoreLoader.this.loadKernel());
                CoreLoader.this.loadBebop();
                CoreLoader.this.loadWebDev();
                CoreLoader.this.loadSiteMapAdminApp(CoreLoader.this.loadAdminApp());
                CoreLoader.this.loadPermissionsSiteNode();
                CoreLoader.this.loadPortal();
                CoreLoader.this.loadMimeTypes();
            }
        }.run();
    }

    public static void loadHost() {
        HttpHost hhost = Web.getConfig().getHost();
        Assert.exists(hhost, class$com$arsdigita$util$servlet$HttpHost == null ? (class$com$arsdigita$util$servlet$HttpHost = CoreLoader.class$("com.arsdigita.util.servlet.HttpHost")) : class$com$arsdigita$util$servlet$HttpHost);
        Host host = Host.retrieve(hhost);
        if (host == null) {
            Host.create(hhost.getName(), hhost.getPort());
        }
        Initializer.LOADER.load();
    }

    private SiteNode loadKernel() {
        SiteNode rootNode = SiteNode.createSiteNode(null, null);
        this.createSystemAdministrator();
        PackageType subsite = PackageType.create("acs-subsite", "ACS Subsite", "ACS Subsites", "http://arsdigita.com/acs-subsite/");
        PackageInstance subsiteInstance = subsite.createInstance("Main Site");
        rootNode.mountPackage(subsiteInstance);
        return rootNode;
    }

    private void createSystemAdministrator() {
        String DO_NOT_CREATE = "*do not create*";
        String emailAddress = this.getEmail();
        String screenName = this.getScreen();
        String givenName = this.getGiven();
        String familyName = this.getFamily();
        String password = this.getPassword();
        String passwordQuestion = this.getQuestion();
        String passwordAnswer = this.getAnswer();
        if (emailAddress.equals("*do not create*")) {
            s_log.warn((Object)"WARNING: System administrator account not created because email set to '*do not create*'.\n This will cause problems *unless* account is setup another way (for example, by an LDAP initializer).");
            return;
        }
        User sa = new User();
        sa.setPrimaryEmail(new EmailAddress(emailAddress));
        if (screenName != null && screenName.length() > 0) {
            sa.setScreenName(screenName);
        }
        sa.getPersonName().setGivenName(givenName);
        sa.getPersonName().setFamilyName(familyName);
        UserAuthentication auth = UserAuthentication.createForUser(sa);
        auth.setPassword(password);
        auth.setPasswordQuestion(passwordQuestion);
        auth.setPasswordAnswer(passwordAnswer);
        PermissionService.grantPermission(new UniversalPermissionDescriptor(PrivilegeDescriptor.ADMIN, sa));
        s_log.info((Object)("Adding administrator: \"" + givenName + " " + familyName + "\" <" + emailAddress + ">"));
    }

    private void loadSubsite(SiteNode rootNode) {
        String stylesheetName = "";
        String sDispatcher = "";
        PackageInstance packageInstance = rootNode.getPackageInstance();
        if (packageInstance == null) {
            throw new IllegalStateException("No package instance mounted at the root node");
        }
        PackageType subsite = packageInstance.getType();
        String packageKey = subsite.getKey();
        try {
            subsite = PackageType.findByKey(packageKey);
        }
        catch (DataObjectNotFoundException e) {
            throw new IllegalStateException("Package Type with key \"" + packageKey + "\" was not found.\n");
        }
        stylesheetName = "/packages/login/xsl/" + this.getStylesheet();
        s_log.info((Object)("Adding stylesheet: " + stylesheetName));
        subsite.addStylesheet(Stylesheet.createStylesheet(stylesheetName));
        subsite.setDispatcherClass(this.getDispatcher());
    }

    private void loadBebop() {
        PackageType bebop = PackageType.create("bebop", "Bebop", "Bebops", "http://arsdigita.com/bebop/");
        bebop.createInstance("Bebop Service");
        String name = "/packages/bebop/xsl/bebop.xsl";
        Stylesheet partSheet = Stylesheet.createStylesheet(name);
        s_log.info((Object)("Adding stylesheet: " + name));
        bebop.addStylesheet(partSheet);
    }

    private void loadWebDev() {
        PackageType packType = PackageType.create("webdev-support", "WebDeveloper Support", "WebDeveloper Supports", "http://arsdigita.com/webdev-support");
        SiteNode node = SiteNode.createSiteNode("ds");
        node.mountPackage(packType.createInstance("webdev-support"));
        packType.setDispatcherClass("com.arsdigita.webdevsupport.Dispatcher");
    }

    private Application loadAdminApp() {
        ApplicationType adminType = ApplicationType.createApplicationType("admin", "CCM Admin Application", "com.arsdigita.ui.admin.Admin");
        adminType.setDispatcherClass("com.arsdigita.ui.admin.AdminDispatcher");
        adminType.setDescription("CCM user and group administration");
        Stylesheet adminXsl = Stylesheet.createStylesheet("/packages/acs-admin/xsl/admin_en.xsl", Locale.ENGLISH);
        adminType.addStylesheet(adminXsl);
        Application admin = Application.createApplication(adminType, "admin", "CCM Admin", null);
        return admin;
    }

    private void loadSiteMapAdminApp(Application parent) {
        ApplicationType sitemapType = ApplicationType.createApplicationType("sitemap", "SiteMap Admin Application", "com.arsdigita.ui.sitemap.SiteMap");
        sitemapType.setDispatcherClass("com.arsdigita.ui.sitemap.SiteMapDispatcher");
        sitemapType.setDescription("CCM sitemap administration");
        sitemapType.addStylesheet(Stylesheet.createStylesheet("/packages/acs-admin/xsl/sitemap_en.xsl", Locale.ENGLISH));
        Application sitemap = Application.createApplication(sitemapType, "sitemap", "CCM Admin Sitemap", parent);
    }

    private void loadPermissionsSiteNode() {
        PackageType permissionsType;
        SiteNode permissionsNode = SiteNode.createSiteNode("permissions");
        try {
            permissionsType = PackageType.findByKey("acs-permissions");
        }
        catch (DataObjectNotFoundException e) {
            permissionsType = PackageType.create("acs-permissions", "ACS Permissions Package", "ACS Permissions Packages", "http://arsdigita.com/acs-permissions");
        }
        Stylesheet permissionsXsl = Stylesheet.createStylesheet("/packages/permissions/xsl/permissions.xsl");
        permissionsType.addStylesheet(permissionsXsl);
        permissionsType.setDispatcherClass("com.arsdigita.ui.permissions.PermissionsDispatcher");
        PackageInstance permissionsInstance = permissionsType.createInstance("ACS Permissions");
        permissionsNode.mountPackage(permissionsInstance);
    }

    private void loadPortal() {
        s_log.info((Object)"Adding package type: portal");
        PackageType packageType = PackageType.create("portal", "Portal", "Portals", "http://arsdigita.com/portal");
        ResourceType type = ResourceType.createResourceType("Portal", "com.arsdigita.portal.Portal");
        type.setDescription("A Portal!");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadMimeTypes() {
        String resource;
        ClassLoader cload = Thread.currentThread().getContextClassLoader();
        InputStream is = cload.getResourceAsStream(resource = this.getResource());
        if (is == null) {
            throw new IllegalStateException("no such resource: " + resource);
        }
        try {
            MimeTypeRow row = new MimeTypeRow();
            CSVParameterLoader loader = new CSVParameterLoader(new InputStreamReader(is), row.getParameters());
            while (loader.next()) {
                row.load(loader);
                s_log.info((Object)("Adding mimetype: " + row.getType() + " (" + row.getLabel() + ")"));
                MimeType mime = MimeType.createMimeType(row.getType(), row.getJavaClass(), row.getObjectType());
                mime.setLabel(row.getLabel());
                mime.setFileExtension(row.getDefaultExtension());
                if (mime instanceof TextMimeType) {
                    ((TextMimeType)mime).setAllowINSOConvert("1".equals(row.getSizerOrINSO()));
                }
                if (mime instanceof ImageMimeType) {
                    ((ImageMimeType)mime).setImageSizer(row.getSizerOrINSO());
                }
                String[] extensions = StringUtils.split(row.getExtensions(), ',');
                for (int i = 0; i < extensions.length; ++i) {
                    MimeTypeExtension ext = MimeTypeExtension.create(extensions[i], mime.getMimeType());
                    ext.save();
                }
            }
        }
        finally {
            try {
                is.close();
            }
            catch (IOException e) {
                throw new UncheckedWrapperException(e);
            }
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

