/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.logging;

public class Log {
    public static final String versionId = "$Id: //core-platform/dev/src/com/arsdigita/logging/Log.java#7 $ by $Author: dennis $, $DateTime: 2004/04/07 16:07:11 $";
    private static ThreadLocal s_secureState = new ThreadLocal(){

        public Object initialValue() {
            return Boolean.FALSE;
        }
    };

    public static boolean isSecure() {
        return (Boolean)s_secureState.get();
    }

    private static void startSecureLogging() {
        s_secureState.set(Boolean.TRUE);
    }

    private static void resetSecureLogging(Boolean inSecureState) {
        s_secureState.set(inSecureState);
    }

    public static void secure(Runnable r) {
        boolean inSecureState = Log.isSecure();
        Log.startSecureLogging();
        r.run();
        Log.resetSecureLogging(new Boolean(inSecureState));
    }
}

