/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.messaging;

import com.arsdigita.domain.DataObjectNotFoundException;
import com.arsdigita.domain.DomainObjectFactory;
import com.arsdigita.kernel.ACSObject;
import com.arsdigita.kernel.Party;
import com.arsdigita.kernel.permissions.PermissionService;
import com.arsdigita.kernel.permissions.PrivilegeDescriptor;
import com.arsdigita.messaging.MessagePart;
import com.arsdigita.messaging.MessageType;
import com.arsdigita.messaging.MessagingException;
import com.arsdigita.persistence.DataAssociation;
import com.arsdigita.persistence.DataAssociationCursor;
import com.arsdigita.persistence.DataObject;
import com.arsdigita.persistence.OID;
import com.arsdigita.util.HtmlToText;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.ListIterator;
import java.util.StringTokenizer;
import org.apache.log4j.Logger;

public class Message
extends ACSObject
implements MessageType {
    private ArrayList m_attachments;
    public static final String BASE_DATA_OBJECT_TYPE = (class$com$arsdigita$messaging$Message == null ? (class$com$arsdigita$messaging$Message = Message.class$("com.arsdigita.messaging.Message")) : class$com$arsdigita$messaging$Message).getName();
    public static final String SENDER = "sender";
    public static final String REPLY_TO = "replyTo";
    public static final String SUBJECT = "subject";
    public static final String BODY = "body";
    public static final String TYPE = "type";
    public static final String SENT = "sent";
    public static final String INREPLYTO = "inReplyTo";
    public static final String OBJECT_ID = "objectID";
    public static final String MESSAGE_ID = "messageID";
    public static final String MESSAGE_PART = "messagePart";
    private Party m_sender = null;
    private static final Logger s_log = Logger.getLogger((Class)(class$com$arsdigita$messaging$Message == null ? (class$com$arsdigita$messaging$Message = Message.class$("com.arsdigita.messaging.Message")) : class$com$arsdigita$messaging$Message));
    static /* synthetic */ Class class$com$arsdigita$messaging$Message;

    public Message() {
        this(BASE_DATA_OBJECT_TYPE);
    }

    public Message(String type) {
        super(type);
        this.setSentDate(new Date());
    }

    public Message(Party f, String s) {
        this(f, s, null);
    }

    public Message(Party f, String s, String b) {
        this();
        this.setFrom(f);
        this.setSubject(s);
        this.setText(b);
    }

    public Message(DataObject dataObject) {
        super(dataObject);
    }

    public Message(BigDecimal id) throws DataObjectNotFoundException {
        this(new OID(BASE_DATA_OBJECT_TYPE, (Object)id));
    }

    public Message(OID oid) throws DataObjectNotFoundException {
        super(oid);
    }

    protected void getReplyInfo(Message msg) {
        this.set(INREPLYTO, msg.getID());
        this.setRefersTo(msg.getRefersTo());
        String prefix = "Re:";
        String subject = msg.getSubject();
        if (subject.startsWith(prefix)) {
            this.setSubject(subject);
        } else {
            this.setSubject(prefix + " " + subject);
        }
    }

    public String getDisplayName() {
        return this.getSubject();
    }

    public Message reply() throws MessagingException {
        Message reply = new Message();
        reply.getReplyInfo(this);
        return reply;
    }

    public String getSubject() {
        return (String)this.get(SUBJECT);
    }

    public void setSubject(String s) {
        this.set(SUBJECT, s);
    }

    public void setFrom(Party f) {
        this.m_sender = f;
        this.setAssociation(SENDER, f);
    }

    public Party getFrom() {
        DataObject senderData;
        if (this.m_sender == null && (senderData = (DataObject)this.get(SENDER)) != null) {
            this.m_sender = (Party)DomainObjectFactory.newInstance(senderData);
        }
        return this.m_sender;
    }

    public void setReplyTo(String addr) {
        this.set(REPLY_TO, addr);
    }

    public String getReplyTo() {
        return (String)this.get(REPLY_TO);
    }

    public String getBody() {
        return (String)this.get(BODY);
    }

    public String getBodyAsHTML() {
        return Message.generateHTMLText(this.getBody(), this.getBodyType());
    }

    public void setBody(String body, String type) {
        this.set(BODY, body);
        this.set(TYPE, type);
    }

    public void setText(String text) {
        this.setBody(text, "text/plain");
    }

    public String getBodyType() {
        return (String)this.get(TYPE);
    }

    public boolean isMimeType(String mimeType) {
        String primary = Message.getPrimaryType(mimeType);
        return primary.regionMatches(true, 0, Message.getPrimaryType(this.getBodyType()), 0, primary.length());
    }

    private static String getPrimaryType(String type) {
        StringTokenizer st = new StringTokenizer(type, " ;");
        return st.nextToken();
    }

    public Date getSentDate() {
        return (Date)this.get(SENT);
    }

    public void setSentDate(Date sentDate) {
        this.set(SENT, sentDate);
    }

    public BigDecimal getRefersTo() {
        return (BigDecimal)this.get(OBJECT_ID);
    }

    public void setRefersTo(BigDecimal id) {
        this.set(OBJECT_ID, id);
    }

    public void setRefersTo(ACSObject obj) {
        this.setRefersTo(obj.getID());
    }

    public String getRFCMessageID() {
        return (String)this.get(MESSAGE_ID);
    }

    public void setRFCMessageID(String messageID) {
        this.set(MESSAGE_ID, messageID);
    }

    public void attach(String text, String name) {
        this.attach(text, name, null, "attachment");
    }

    public void attach(String text, String name, String description) {
        this.attach(text, name, description, "attachment");
    }

    public void attach(String text, String name, String description, String disposition) {
        MessagePart part = new MessagePart();
        this.attach(part);
        part.setName(name);
        part.setDescription(description);
        part.setDisposition(disposition);
        part.setText(text);
    }

    public void attach(MessagePart part) {
        this.addPart(part);
    }

    public int getAttachmentCount() {
        return this.getParts().size();
    }

    public ListIterator getAttachments() {
        return this.getParts().listIterator();
    }

    private void addPart(MessagePart part) {
        this.getParts().add(part);
        part.addToAssociation(this.getPartAssociation());
    }

    private DataAssociation getPartAssociation() {
        return (DataAssociation)this.get(MESSAGE_PART);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ArrayList getParts() {
        if (this.m_attachments == null) {
            this.m_attachments = new ArrayList();
            if (!this.isNew()) {
                DataAssociationCursor cursor = this.getPartAssociation().cursor();
                try {
                    while (cursor.next()) {
                        this.m_attachments.add(new MessagePart(cursor.getDataObject()));
                    }
                }
                catch (DataObjectNotFoundException ex) {
                    s_log.warn((Object)"error initializing message attachments");
                }
                finally {
                    cursor.close();
                }
            }
        }
        return this.m_attachments;
    }

    public BigDecimal getMessageID() {
        return this.getID();
    }

    public ACSObject getContainer() {
        BigDecimal id = this.getRefersTo();
        if (id != null) {
            OID oid = new OID("com.arsdigita.kernel.ACSObject", (Object)id);
            try {
                return (ACSObject)DomainObjectFactory.newInstance(oid);
            }
            catch (DataObjectNotFoundException dataObjectNotFoundException) {
                // empty catch block
            }
        }
        return null;
    }

    public void doWriteCheck() {
        this.getContainer().assertPrivilege(PrivilegeDescriptor.READ);
    }

    public boolean isContainerModified() {
        return this.isPropertyModified(OBJECT_ID);
    }

    public static String generateHTMLText(String text, String formatType) {
        return HtmlToText.generateHTMLText(text, formatType);
    }

    protected void afterSave() {
        super.afterSave();
        PermissionService.setContext(this, this.getContainer());
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

