/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.messaging;

import com.arsdigita.db.Sequences;
import com.arsdigita.domain.DataObjectNotFoundException;
import com.arsdigita.domain.ObservableDomainObject;
import com.arsdigita.mail.ByteArrayDataSource;
import com.arsdigita.messaging.MessageType;
import com.arsdigita.messaging.MessagingException;
import com.arsdigita.persistence.DataObject;
import com.arsdigita.persistence.OID;
import com.arsdigita.persistence.PersistenceException;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.sql.SQLException;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.activation.FileDataSource;

public class MessagePart
extends ObservableDomainObject
implements MessageType {
    public static final String BASE_DATA_OBJECT_TYPE = (class$com$arsdigita$messaging$MessagePart == null ? (class$com$arsdigita$messaging$MessagePart = MessagePart.class$("com.arsdigita.messaging.MessagePart")) : class$com$arsdigita$messaging$MessagePart).getName();
    private static final String PART_ID = "id";
    private static final String NAME = "name";
    private static final String DESCRIPTION = "description";
    private static final String TYPE = "type";
    private static final String DISPOSITION = "disposition";
    private static final String CONTENT = "content";
    public static final String INLINE = "inline";
    public static final String ATTACHMENT = "attachment";
    static /* synthetic */ Class class$com$arsdigita$messaging$MessagePart;

    public MessagePart() {
        super(BASE_DATA_OBJECT_TYPE);
        this.setID(this.generateID());
    }

    public MessagePart(OID oid) throws DataObjectNotFoundException {
        super(oid);
    }

    public MessagePart(DataObject dataObject) throws DataObjectNotFoundException {
        super(dataObject);
    }

    public MessagePart(String name) {
        this(name, null, ATTACHMENT);
    }

    public MessagePart(String name, String description) {
        this(name, description, ATTACHMENT);
    }

    public MessagePart(String name, String description, String disposition) {
        this();
        this.setName(name);
        this.setDescription(description);
        this.setDisposition(disposition);
    }

    protected String getBaseDataObjectType() {
        return BASE_DATA_OBJECT_TYPE;
    }

    public String getName() {
        return (String)this.get(NAME);
    }

    public void setName(String name) {
        this.set(NAME, name);
    }

    public String getDescription() {
        return (String)this.get(DESCRIPTION);
    }

    public void setDescription(String description) {
        this.set(DESCRIPTION, description);
    }

    public String getContentType() {
        return (String)this.get(TYPE);
    }

    protected void setContentType(String type) {
        this.set(TYPE, type);
    }

    public String getDisposition() {
        return (String)this.get(DISPOSITION);
    }

    public void setDisposition(String disposition) {
        this.set(DISPOSITION, disposition);
    }

    public int getSize() {
        byte[] content = (byte[])this.get(CONTENT);
        return content.length;
    }

    public Object getContent() {
        byte[] bytes = (byte[])this.get(CONTENT);
        Object result = this.getContentType().startsWith("text") ? new String(bytes) : new ByteArrayInputStream(bytes);
        return result;
    }

    public void setText(String text) {
        this.setContent(text, "text/plain");
    }

    public void setContent(String text, String type) {
        this.set(TYPE, type);
        this.set(CONTENT, text.getBytes());
    }

    public void setContent(File file, String name, String description) throws MessagingException {
        DataHandler dh = new DataHandler((DataSource)new FileDataSource(file));
        this.setDataHandler(dh);
        this.setName(name);
        this.setDescription(description);
    }

    public DataHandler getDataHandler() {
        Object content = this.getContent();
        DataHandler dh = null;
        dh = content instanceof InputStream ? new DataHandler((DataSource)new ByteArrayDataSource((InputStream)content, this.getContentType(), this.getName())) : new DataHandler((DataSource)new ByteArrayDataSource((String)content, this.getContentType(), this.getName()));
        return dh;
    }

    public void setDataHandler(DataHandler dh) throws MessagingException {
        this.set(NAME, dh.getName());
        this.set(TYPE, dh.getContentType());
        try {
            int ch;
            InputStream is = dh.getInputStream();
            ByteArrayOutputStream os = new ByteArrayOutputStream();
            while ((ch = is.read()) != -1) {
                os.write(ch);
            }
            this.set(CONTENT, os.toByteArray());
        }
        catch (IOException e) {
            throw new MessagingException("error attaching content: " + e.getMessage());
        }
    }

    private BigDecimal generateID() throws PersistenceException {
        try {
            return Sequences.getNextValue();
        }
        catch (SQLException e) {
            throw new PersistenceException("Unable to generate a unique ID");
        }
    }

    private void setID(BigDecimal id) {
        this.set(PART_ID, id);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

