/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.messaging;

import com.arsdigita.domain.DataObjectNotFoundException;
import com.arsdigita.domain.DomainObjectFactory;
import com.arsdigita.kernel.ACSObject;
import com.arsdigita.kernel.Party;
import com.arsdigita.kernel.permissions.PrivilegeDescriptor;
import com.arsdigita.messaging.ThreadedMessage;
import com.arsdigita.persistence.DataCollection;
import com.arsdigita.persistence.DataObject;
import com.arsdigita.persistence.DataOperation;
import com.arsdigita.persistence.OID;
import com.arsdigita.persistence.SessionManager;
import com.arsdigita.util.Assert;
import java.math.BigDecimal;
import java.util.Date;

public class MessageThread
extends ACSObject {
    public static final String BASE_DATA_OBJECT_TYPE = "com.arsdigita.messaging.Thread";
    private static final String LAST_UPDATE = "lastUpdate";
    private static final String ROOT = "root";
    private static final String AUTHOR = "author";
    private static final String REPLIES = "numReplies";
    private ThreadedMessage m_root = null;
    private Party m_author = null;

    public MessageThread(ThreadedMessage rootMsg) {
        super(BASE_DATA_OBJECT_TYPE);
        this.setRootMessage(rootMsg);
        this.setAuthor(rootMsg.getFrom());
        this.setLatestUpdateDate(rootMsg.getSentDate());
    }

    public MessageThread(DataObject data) {
        super(data);
    }

    public MessageThread(BigDecimal id) throws DataObjectNotFoundException {
        super(new OID(BASE_DATA_OBJECT_TYPE, (Object)id));
    }

    public MessageThread(OID id) throws DataObjectNotFoundException {
        super(id);
    }

    protected void initialize() {
        super.initialize();
        if (this.isNew() && this.get(REPLIES) == null) {
            this.set(REPLIES, new BigDecimal(0.0));
        }
    }

    public ThreadedMessage getRootMessage() {
        DataObject rootData;
        if (this.m_root == null && (rootData = (DataObject)this.get(ROOT)) != null) {
            this.m_root = (ThreadedMessage)DomainObjectFactory.newInstance(rootData);
        }
        return this.m_root;
    }

    public ACSObject getContainer() {
        return this.getRootMessage().getContainer();
    }

    public void doWriteCheck() {
        this.getContainer().assertPrivilege(PrivilegeDescriptor.READ);
    }

    private void setRootMessage(ThreadedMessage rootMsg) {
        this.m_root = rootMsg;
        this.setAssociation(ROOT, rootMsg);
    }

    public long getNumReplies() {
        return ((BigDecimal)this.get(REPLIES)).longValue();
    }

    private void incrNumberOfReplies() {
        DataOperation op = SessionManager.getSession().retrieveDataOperation("com.arsdigita.messaging.incrNumReplies");
        op.setParameter("threadID", this.getID());
        op.execute();
    }

    public Date getLatestUpdateDate() {
        return (Date)this.get(LAST_UPDATE);
    }

    private void setLatestUpdateDate(Date date) {
        this.set(LAST_UPDATE, date);
    }

    public String getSubject() {
        return this.getRootMessage().getSubject();
    }

    public String getAuthorName() {
        DataObject author = (DataObject)this.get(AUTHOR);
        if (author == null) {
            return null;
        }
        return (String)author.get("displayName");
    }

    public Party getAuthor() {
        DataObject authorData;
        if (this.m_author == null && (authorData = (DataObject)this.get(AUTHOR)) != null) {
            this.m_author = (Party)DomainObjectFactory.newInstance(authorData);
        }
        return this.m_author;
    }

    private void setAuthor(Party author) {
        this.m_author = author;
        this.setAssociation(AUTHOR, author);
    }

    void updateForNewMessage(ThreadedMessage msg) {
        Assert.assertTrue(msg.getThread().equals(this));
        this.setLatestUpdateDate(msg.getSentDate());
        this.incrNumberOfReplies();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static MessageThread getFromRootMessage(ThreadedMessage msg) {
        Assert.assertEquals(null, msg.getRoot());
        DataCollection threads = SessionManager.getSession().retrieve(BASE_DATA_OBJECT_TYPE);
        threads.addEqualsFilter("root.id", msg.getID());
        MessageThread t = null;
        try {
            if (threads.next()) {
                t = new MessageThread(threads.getDataObject());
            }
        }
        finally {
            threads.close();
        }
        return t;
    }

    public String toString() {
        return this.getOID().toString();
    }
}

