/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.mimetypes;

import com.arsdigita.db.DbHelper;
import com.arsdigita.domain.DomainObject;
import com.arsdigita.domain.DomainObjectFactory;
import com.arsdigita.domain.DomainObjectInstantiator;
import com.arsdigita.initializer.Configuration;
import com.arsdigita.initializer.InitializationException;
import com.arsdigita.kernel.BaseInitializer;
import com.arsdigita.mimetypes.MimeType;
import com.arsdigita.mimetypes.MimeTypeStatus;
import com.arsdigita.mimetypes.converters.ConvertFormat;
import com.arsdigita.persistence.DataObject;
import com.arsdigita.persistence.SessionManager;
import com.arsdigita.persistence.TransactionContext;
import com.arsdigita.util.Assert;
import com.arsdigita.util.StringUtils;
import java.math.BigDecimal;
import org.apache.log4j.Logger;

public class MimeTypeInitializer
extends BaseInitializer {
    private static final Logger s_log = Logger.getLogger((Class)(class$com$arsdigita$mimetypes$MimeTypeInitializer == null ? (class$com$arsdigita$mimetypes$MimeTypeInitializer = MimeTypeInitializer.class$("com.arsdigita.mimetypes.MimeTypeInitializer")) : class$com$arsdigita$mimetypes$MimeTypeInitializer));
    private final Configuration m_conf = new Configuration();
    public static final String INSO_FILTER_WORKS = "INSOFilterEnabled";
    private static final String rtfTestFile = "{\\rtf1\\ansi\\deff0\n{\\fonttbl{\\f0\\froman\\fprq2\\fcharset0 Times;}}\n{\\colortbl\\red0\\green0\\blue0;\\red255\\green255\\blue255;\\red128\\green128\\blue128;}\n{\\stylesheet{\\s1\\snext1 Standard;}\n}\n{\\info{\\comment StarWriter}{\\vern5690}}\\deftab720\n{\\*\\pgdsctbl\n{\\pgdsc0\\pgdscuse195\\pgwsxn12240\\pghsxn15840\\marglsxn1800\\margrsxn1800\\margtsxn1440\\margbsxn1440\\pgdscnxt0 Standard;}}\n\\paperh15840\\paperw12240\\margl1800\\margr1800\\margt1440\\margb1440\\sectd\\sbknone\\pgwsxn12240\\pghsxn15840\\marglsxn1800\\margrsxn1800\\margtsxn1440\\margbsxn1440\\ftnbj\\ftnstart1\\ftnrstcont\\ftnnar\\aenddoc\\aftnrstcont\\aftnstart1\\aftnnrlc\n\\pard\\plain \\s1\\fs40\\qc test rtf file.\n\\par \\pard\\plain \\s1 \n\\par This app uses the interMedia INSO filtering to automatically convert from an RTF format to html format.\n\\par \n\\par But lets see if it really works.\n\\par \n\\par }\n";
    private static final String rtfTestFileHTML = "<HTML><BODY>\n<P><A NAME=\"s1content\"></A>test rtf file.&nbsp;<BR></P>\n<P>This app uses the interMedia INSO filtering to \nautomatically convert from an RTF format to html \nformat.&nbsp;<BR></P>\n<P>But lets see if it really works.</P>\n</BODY></HTML>\n";
    static /* synthetic */ Class class$com$arsdigita$mimetypes$MimeTypeInitializer;
    static /* synthetic */ Class class$java$lang$Boolean;

    private void updateStatus() {
        MimeTypeStatus ms = MimeTypeStatus.getMimeTypeStatus();
        if (this.isFilterEnabled()) {
            ms.setInsoFilterWorks(new BigDecimal(1.0));
        } else {
            ms.setInsoFilterWorks(new BigDecimal(0.0));
        }
        ms.save();
    }

    private static void registerInstantiator() {
        if (DomainObjectFactory.getInstantiator("com.arsdigita.cms.MimeType") == null) {
            DomainObjectInstantiator instMimeType = new DomainObjectInstantiator(){

                public DomainObject doNewInstance(DataObject dataObject) {
                    return new MimeType(dataObject);
                }
            };
            DomainObjectFactory.registerInstantiator("com.arsdigita.cms.MimeType", instMimeType);
        }
    }

    public MimeTypeInitializer() throws InitializationException {
        this.m_conf.initParameter(INSO_FILTER_WORKS, "Set to true if you have a working INSO filter", class$java$lang$Boolean == null ? (class$java$lang$Boolean = MimeTypeInitializer.class$("java.lang.Boolean")) : class$java$lang$Boolean, Boolean.FALSE);
    }

    public Configuration getConfiguration() {
        return this.m_conf;
    }

    protected void doStartup() {
        boolean isNonOracleDB;
        TransactionContext txn = SessionManager.getSession().getTransactionContext();
        txn.beginTxn();
        boolean bl = isNonOracleDB = DbHelper.getDatabase() != 1;
        if (this.isFilterEnabled() && isNonOracleDB) {
            s_log.warn((Object)("Had INSOFilterEnabled set to true when using a non Oracle database. This is not allowed. Setting to false. Database=" + DbHelper.getDatabaseName(DbHelper.getDatabase())));
            this.disableFilter();
        }
        this.testINSOFilter();
        this.updateStatus();
        MimeTypeInitializer.registerInstantiator();
        txn.commitTxn();
    }

    private void disableFilter() {
        this.m_conf.setParameter(INSO_FILTER_WORKS, Boolean.FALSE);
    }

    protected void doShutdown() {
    }

    private void testINSOFilter() {
        if (!this.isFilterEnabled()) {
            s_log.info((Object)"Not testing INSO filter.");
            return;
        }
        Assert.truth(DbHelper.getDatabase() == 1, "Testing INSO filter on non Oracle DB! Shouldn't happen!");
        s_log.info((Object)"Starting INSO filter test.  If server hangs here,\n  kill the job, then change your enterprise.init setting;' in \n  enterprise.init com.arsdigita.cms.installer.Initializer.");
        String actual = ConvertFormat.toHTML(rtfTestFile.getBytes());
        if (actual == null) {
            s_log.warn((Object)"INSO Filter test failed. Unable to convert test rtf document to html.");
            s_log.warn((Object)"INSO Filter test Expected: '<HTML><BODY>\n<P><A NAME=\"s1content\"></A>test rtf file.&nbsp;<BR></P>\n<P>This app uses the interMedia INSO filtering to \nautomatically convert from an RTF format to html \nformat.&nbsp;<BR></P>\n<P>But lets see if it really works.</P>\n</BODY></HTML>\n'");
            s_log.warn((Object)("INSO Filter test Got: '" + actual + "'"));
            this.disableFilter();
            return;
        }
        String expected = StringUtils.stripWhiteSpace(rtfTestFileHTML).toLowerCase();
        if (expected.equals(actual = StringUtils.stripWhiteSpace(actual).toLowerCase())) {
            s_log.info((Object)"INSO Filter test passed.");
            return;
        }
        if (actual.startsWith("<html><body> <p") && actual.indexOf("but lets see if it really works.") >= 0 && actual.indexOf("this app uses the intermedia inso filtering to automatically convert from an rtf format to html format.") >= 0 && actual.endsWith("</p> </body></html>")) {
            s_log.info((Object)"INSO Filter test passed.");
            return;
        }
        s_log.warn((Object)"INSO Filter test failed. (Will not be able to convert documents to html format by file uploading.)");
        s_log.warn((Object)("INSO Filter test Expected: '" + expected + "'"));
        s_log.warn((Object)("Got: '" + actual + "'"));
        this.disableFilter();
    }

    private boolean isFilterEnabled() {
        Boolean isEnabled = (Boolean)this.m_conf.getParameter(INSO_FILTER_WORKS);
        return isEnabled;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

