/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.mimetypes.image;

import com.arsdigita.mimetypes.image.ImageSizer;
import com.arsdigita.mimetypes.util.GlobalizationUtil;
import java.awt.Dimension;
import java.io.DataInputStream;
import java.io.IOException;
import org.apache.log4j.Logger;

public class JPEGImageSizer
extends ImageSizer {
    public static final String versionId = "$Id: //core-platform/dev/src/com/arsdigita/mimetypes/image/JPEGImageSizer.java#6 $ by $Author: dennis $, $DateTime: 2004/04/07 16:07:11 $";
    private static Logger s_log = Logger.getLogger((Class)(class$com$arsdigita$mimetypes$image$JPEGImageSizer == null ? (class$com$arsdigita$mimetypes$image$JPEGImageSizer = JPEGImageSizer.class$("com.arsdigita.mimetypes.image.JPEGImageSizer")) : class$com$arsdigita$mimetypes$image$JPEGImageSizer));
    private static final byte M_0FF = -1;
    private static final byte M_SOF0 = -64;
    private static final byte M_SOF1 = -63;
    private static final byte M_SOF2 = -62;
    private static final byte M_SOF3 = -61;
    private static final byte M_SOF5 = -59;
    private static final byte M_SOF6 = -58;
    private static final byte M_SOF7 = -57;
    private static final byte M_SOF9 = -55;
    private static final byte M_SOF10 = -54;
    private static final byte M_SOF11 = -53;
    private static final byte M_SOF13 = -51;
    private static final byte M_SOF14 = -50;
    private static final byte M_SOF15 = -49;
    private static final byte M_SOI = -40;
    private static final byte M_EOI = -39;
    private static final byte M_SOS = -38;
    private static final byte M_APP0 = -32;
    private static final byte M_APP12 = -20;
    private static final byte M_COM = -2;
    private short height;
    private short width;
    static /* synthetic */ Class class$com$arsdigita$mimetypes$image$JPEGImageSizer;

    protected JPEGImageSizer() {
    }

    public Dimension computeSize(DataInputStream in) throws IOException {
        this.scanHeader(in);
        return new Dimension(this.width, this.height);
    }

    private byte nextMarker(DataInputStream in) throws IOException {
        int discardedBytes = 0;
        byte c = in.readByte();
        while (c != -1) {
            ++discardedBytes;
            c = in.readByte();
        }
        while ((c = in.readByte()) == -1) {
        }
        if (discardedBytes != 0) {
            s_log.warn((Object)"Warning: garbage data found in JPEG file");
        }
        return c;
    }

    private byte firstMarker(DataInputStream in) throws IOException {
        byte c1 = in.readByte();
        byte c2 = in.readByte();
        if (c1 != -1 || c2 != -40) {
            throw new IOException((String)GlobalizationUtil.globalize("cms.image.not_a_jpeg_file").localize());
        }
        return c2;
    }

    private void skipVariable(DataInputStream in) throws IOException {
        short length = in.readShort();
        if (length < 2) {
            throw new IOException((String)GlobalizationUtil.globalize("cms.image.erroneous_jpeg_marker_length").localize());
        }
        length = (short)(length - 2);
        in.skipBytes(length);
    }

    private String processComment(DataInputStream in) throws IOException {
        boolean lastch = false;
        short length = in.readShort();
        if (length < 2) {
            throw new IOException((String)GlobalizationUtil.globalize("cms.image.erroneous_jpeg_marker_length").localize());
        }
        length = (short)(length - 2);
        byte[] data = new byte[length];
        in.read(data);
        String comment = new String(data);
        return comment;
    }

    private void processSOFn(DataInputStream in, byte marker) throws IOException {
        short length = in.readShort();
        byte data_precision = in.readByte();
        this.height = in.readShort();
        this.width = in.readShort();
        int num_components = in.readByte();
        switch (marker) {
            case -64: {
                String process = "Baseline";
                break;
            }
            case -63: {
                String process = "Extended sequential";
                break;
            }
            case -62: {
                String process = "Progressive";
                break;
            }
            case -61: {
                String process = "Lossless";
                break;
            }
            case -59: {
                String process = "Differential sequential";
                break;
            }
            case -58: {
                String process = "Differential progressive";
                break;
            }
            case -57: {
                String process = "Differential lossless";
                break;
            }
            case -55: {
                String process = "Extended sequential, arithmetic coding";
                break;
            }
            case -54: {
                String process = "Progressive, arithmetic coding";
                break;
            }
            case -53: {
                String process = "Lossless, arithmetic coding";
                break;
            }
            case -51: {
                String process = "Differential sequential arithmetic coding";
                break;
            }
            case -50: {
                String process = "Differential progressive arithmetic coding";
                break;
            }
            case -49: {
                String process = "Differential lossless, arithmetic coding";
                break;
            }
            default: {
                String process = "Unknown";
            }
        }
        if (length != 8 + num_components * 3) {
            s_log.warn((Object)"Bogus SOF marker length");
        }
        for (int ci = 0; ci < num_components; ++ci) {
            in.readByte();
            in.readByte();
            in.readByte();
        }
    }

    private byte scanHeader(DataInputStream in) throws IOException {
        if (this.firstMarker(in) != -40) {
            throw new IOException((String)GlobalizationUtil.globalize("cms.image.expected_soi_marker_first").localize());
        }
        block7: while (true) {
            byte marker = this.nextMarker(in);
            switch (marker) {
                case -64: 
                case -63: 
                case -62: 
                case -61: 
                case -59: 
                case -58: 
                case -57: 
                case -55: 
                case -54: 
                case -53: 
                case -51: 
                case -50: 
                case -49: {
                    this.processSOFn(in, marker);
                    continue block7;
                }
                case -38: {
                    return marker;
                }
                case -39: {
                    return marker;
                }
                case -2: {
                    this.skipVariable(in);
                    continue block7;
                }
                case -20: {
                    this.skipVariable(in);
                    continue block7;
                }
            }
            this.skipVariable(in);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

