/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.notification;

import com.arsdigita.domain.DataObjectNotFoundException;
import com.arsdigita.domain.ObservableDomainObject;
import com.arsdigita.kernel.Party;
import com.arsdigita.mail.Mail;
import com.arsdigita.messaging.Message;
import com.arsdigita.messaging.MessagePart;
import com.arsdigita.notification.Notification;
import com.arsdigita.notification.NotificationConstants;
import com.arsdigita.persistence.OID;
import com.arsdigita.util.HtmlToText;
import com.arsdigita.util.StringUtils;
import java.math.BigDecimal;
import java.util.ListIterator;
import javax.mail.MessagingException;
import org.apache.log4j.Logger;

class QueueItem
extends ObservableDomainObject
implements NotificationConstants {
    public static final String BASE_DATA_OBJECT_TYPE = (class$com$arsdigita$notification$QueueItem == null ? (class$com$arsdigita$notification$QueueItem = QueueItem.class$("com.arsdigita.notification.QueueItem")) : class$com$arsdigita$notification$QueueItem).getName();
    private static final Logger s_log = Logger.getLogger((Class)(class$com$arsdigita$notification$QueueItem == null ? (class$com$arsdigita$notification$QueueItem = QueueItem.class$("com.arsdigita.notification.QueueItem")) : class$com$arsdigita$notification$QueueItem));
    private static HtmlToText s_htmlToText = new HtmlToText();
    private Message m_message;
    static /* synthetic */ Class class$com$arsdigita$notification$QueueItem;

    QueueItem(OID oid) throws DataObjectNotFoundException {
        super(oid);
    }

    QueueItem(Notification n, Party to) {
        super(BASE_DATA_OBJECT_TYPE);
        this.set("requestID", n.getID());
        this.set("partyTo", to.getID());
    }

    void setSuccess(Boolean b) {
        this.set("success", b);
    }

    Message getMessage() throws DataObjectNotFoundException {
        if (this.m_message == null) {
            this.m_message = new Message((BigDecimal)this.get("messageID"));
        }
        return this.m_message;
    }

    String getTo() {
        return (String)this.get("partyToAddr");
    }

    String getFrom() throws DataObjectNotFoundException {
        return this.getMessage().getFrom().getPrimaryEmail().toString();
    }

    String getSubject() throws DataObjectNotFoundException {
        return this.getMessage().getSubject();
    }

    private String getHeader() {
        return StringUtils.nullToEmptyString((String)this.get("header"));
    }

    private String getSignature() {
        return StringUtils.nullToEmptyString((String)this.get("signature"));
    }

    String getBody() throws DataObjectNotFoundException {
        Message msg = this.getMessage();
        String body = msg.isMimeType("text/html") ? s_htmlToText.convert(msg.getBody()) : StringUtils.wrap(msg.getBody());
        StringBuffer sb = new StringBuffer();
        sb.append(StringUtils.addNewline(this.getHeader()));
        sb.append(StringUtils.addNewline(body));
        sb.append(StringUtils.addNewline(this.getSignature()));
        return sb.toString();
    }

    void addAttachments(Mail mail) throws MessagingException {
        Message msg;
        try {
            msg = this.getMessage();
        }
        catch (DataObjectNotFoundException ex) {
            return;
        }
        if (msg.getAttachmentCount() > 0) {
            ListIterator iter = msg.getAttachments();
            while (iter.hasNext()) {
                MessagePart part = (MessagePart)iter.next();
                mail.attach(part.getDataHandler(), part.getDescription(), part.getDisposition());
            }
        }
    }

    BigDecimal getRetryCount() {
        return (BigDecimal)this.get("retryCount");
    }

    void setRetryCount(BigDecimal i) {
        this.set("retryCount", i);
    }

    void incrRetryCount() {
        this.set("retryCount", this.getRetryCount().add(new BigDecimal(1.0)));
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

