/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.notification;

import com.arsdigita.domain.DataObjectNotFoundException;
import com.arsdigita.mail.Mail;
import com.arsdigita.notification.NotificationConstants;
import com.arsdigita.notification.QueueItem;
import com.arsdigita.persistence.DataQuery;
import com.arsdigita.persistence.OID;
import com.arsdigita.persistence.Session;
import com.arsdigita.persistence.SessionManager;
import com.arsdigita.util.UncheckedWrapperException;
import java.math.BigDecimal;
import java.util.TimerTask;
import javax.mail.MessagingException;
import org.apache.log4j.Logger;

class SimpleQueueManager
extends TimerTask
implements NotificationConstants {
    public static final String versionId = "$Id: //core-platform/dev/src/com/arsdigita/notification/SimpleQueueManager.java#10 $ by $Author: dennis $,  $Date: 2004/04/07 $";
    private static final Logger s_log = Logger.getLogger((String)(class$com$arsdigita$notification$SimpleQueueManager == null ? (class$com$arsdigita$notification$SimpleQueueManager = SimpleQueueManager.class$("com.arsdigita.notification.SimpleQueueManager")) : class$com$arsdigita$notification$SimpleQueueManager).getName());
    static /* synthetic */ Class class$com$arsdigita$notification$SimpleQueueManager;

    SimpleQueueManager() {
    }

    public void run() {
        s_log.info((Object)"processing current requests");
        long time = System.currentTimeMillis();
        boolean committedTxn = false;
        Session session = SessionManager.getSession();
        session.getTransactionContext().beginTxn();
        DataQuery query = null;
        try {
            try {
                query = session.retrieveQuery("com.arsdigita.notification.GetSimpleQueuedNotifications");
                while (query.next()) {
                    Boolean success;
                    QueueItem notice;
                    BigDecimal requestID = (BigDecimal)query.get("requestID");
                    BigDecimal partyTo = (BigDecimal)query.get("partyTo");
                    if (s_log.isDebugEnabled()) {
                        s_log.debug((Object)("Process request " + requestID + " party " + partyTo));
                    }
                    try {
                        OID oid = new OID(QueueItem.BASE_DATA_OBJECT_TYPE);
                        oid.set("requestID", requestID);
                        oid.set("partyTo", partyTo);
                        notice = new QueueItem(oid);
                    }
                    catch (DataObjectNotFoundException ex) {
                        s_log.warn((Object)"unable to retrieve notification", (Throwable)ex);
                        continue;
                    }
                    if (s_log.isDebugEnabled()) {
                        s_log.debug((Object)("To: " + notice.getTo() + " From: " + notice.getFrom()));
                    }
                    try {
                        String replyToAddr;
                        Mail mail = new Mail(notice.getTo(), notice.getFrom(), notice.getSubject(), notice.getBody());
                        String messageID = notice.getMessage().getRFCMessageID();
                        if (messageID != null) {
                            mail.setMessageID(messageID);
                        }
                        if ((replyToAddr = notice.getMessage().getReplyTo()) != null) {
                            mail.setReplyTo(replyToAddr);
                        }
                        try {
                            notice.addAttachments(mail);
                        }
                        catch (MessagingException ex) {
                            s_log.warn((Object)"error handling attachments", (Throwable)ex);
                        }
                        mail.send();
                        success = Boolean.TRUE;
                    }
                    catch (DataObjectNotFoundException ex) {
                        s_log.warn((Object)"notification failed: ", (Throwable)ex);
                        success = Boolean.FALSE;
                    }
                    catch (MessagingException ex) {
                        s_log.warn((Object)"notification failed: ", (Throwable)ex);
                        success = Boolean.FALSE;
                    }
                    if (!success.booleanValue()) {
                        notice.incrRetryCount();
                    }
                    notice.setSuccess(success);
                    notice.save();
                }
                session.getTransactionContext().commitTxn();
                committedTxn = true;
            }
            catch (Throwable t) {
                s_log.error((Object)"Unexpected error occured. SimpleQueueManager has been disabled.", t);
                throw new UncheckedWrapperException(t);
            }
            Object var15_17 = null;
            if (!committedTxn) {
                session.getTransactionContext().abortTxn();
            }
            if (query != null) {
                query.close();
            }
        }
        catch (Throwable throwable) {
            Object var15_18 = null;
            if (!committedTxn) {
                session.getTransactionContext().abortTxn();
            }
            if (query != null) {
                query.close();
            }
            throw throwable;
        }
        time = System.currentTimeMillis() - time;
        s_log.info((Object)("SimpleQueueManager executed in " + time + " ms."));
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

