/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.packaging;

import com.arsdigita.packaging.Command;
import com.arsdigita.packaging.Config;
import com.arsdigita.packaging.ConfigRegistry;
import com.arsdigita.util.parameter.Parameter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.cli.PosixParser;

class Clear
extends Command {
    public static final String versionId = "$Id: //core-platform/dev/src/com/arsdigita/packaging/Clear.java#4 $$Author: dennis $$DateTime: 2004/04/07 16:07:11 $";
    private static final Options s_options = Clear.getOptions();

    public Clear() {
        super("clear", "Clear one or more values in a CCM configuration database");
    }

    public boolean run(String[] args) {
        CommandLine line;
        try {
            line = new PosixParser().parse(s_options, args);
        }
        catch (ParseException e) {
            System.err.println(e.getMessage());
            return false;
        }
        if (args.length == 0) {
            this.usage(s_options, System.err, "PARAMETERS");
            return false;
        }
        if (line.hasOption("usage") || line.hasOption("help")) {
            this.usage(s_options, System.out, "PARAMETERS");
            return true;
        }
        ConfigRegistry reg = new ConfigRegistry();
        Config config = new Config(reg);
        config.load(System.err);
        String[] keys = line.getArgs();
        ArrayList<String> errors = new ArrayList<String>();
        ArrayList<Parameter> params = new ArrayList<Parameter>();
        for (int i = 0; i < keys.length; ++i) {
            Parameter param = config.getParameter(keys[i]);
            if (param == null) {
                errors.add("no such parameter: " + keys[i]);
                continue;
            }
            params.add(param);
        }
        if (errors.isEmpty()) {
            Iterator iter = params.iterator();
            while (iter.hasNext()) {
                config.set((Parameter)iter.next(), null);
            }
            if (config.validate(System.err)) {
                try {
                    config.save();
                }
                catch (IOException e) {
                    System.err.println(e.getMessage());
                    return false;
                }
                return true;
            }
            return false;
        }
        Iterator iter = errors.iterator();
        while (iter.hasNext()) {
            System.out.println((String)iter.next());
        }
        return false;
    }
}

