/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.packaging;

import com.arsdigita.packaging.RegistryConfig;
import com.arsdigita.runtime.CCM;
import com.arsdigita.util.Classes;
import com.arsdigita.util.JavaPropertyReader;
import com.arsdigita.util.UncheckedWrapperException;
import com.arsdigita.util.parameter.ErrorList;
import com.arsdigita.util.parameter.ParameterContext;
import com.arsdigita.xml.XML;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.log4j.Logger;
import org.xml.sax.Attributes;
import org.xml.sax.helpers.DefaultHandler;

public class ConfigRegistry {
    public static final String versionId = "$Id: //core-platform/dev/src/com/arsdigita/packaging/ConfigRegistry.java#14 $ by $Author: dennis $, $DateTime: 2004/04/07 16:07:11 $";
    private static final Logger s_log = Logger.getLogger((Class)(class$com$arsdigita$packaging$ConfigRegistry == null ? (class$com$arsdigita$packaging$ConfigRegistry = ConfigRegistry.class$("com.arsdigita.packaging.ConfigRegistry")) : class$com$arsdigita$packaging$ConfigRegistry));
    private URL m_url;
    private ClassLoader m_loader;
    private List m_packages = new ArrayList();
    private List m_contexts = new ArrayList();
    private Map m_storage = new HashMap();
    private List m_loaders = new ArrayList();
    static /* synthetic */ Class class$com$arsdigita$packaging$ConfigRegistry;
    static /* synthetic */ Class class$com$arsdigita$packaging$RegistryConfig;

    public ConfigRegistry(URL url, ClassLoader loader) {
        this.m_url = url;
        this.m_loader = loader;
        this.addContext(class$com$arsdigita$packaging$RegistryConfig == null ? (class$com$arsdigita$packaging$RegistryConfig = ConfigRegistry.class$("com.arsdigita.packaging.RegistryConfig")) : class$com$arsdigita$packaging$RegistryConfig, "registry.properties");
        this.initialize(this.m_url, new ErrorList());
    }

    public ConfigRegistry(URL url) {
        this(url, Thread.currentThread().getContextClassLoader());
    }

    public ConfigRegistry(ClassLoader loader) {
        this(CCM.getConfigURL(), loader);
    }

    public ConfigRegistry() {
        this(CCM.getConfigURL());
    }

    private void initialize(URL url, ErrorList errs) {
        int i;
        URLClassLoader ldr = new URLClassLoader(new URL[]{url}, null);
        RegistryConfig rc = new RegistryConfig();
        this.load(rc, errs, ldr);
        String[] packages = rc.getPackages();
        URL[] parents = rc.getParents();
        for (i = 0; i < packages.length; ++i) {
            if (this.m_packages.contains(packages[i])) continue;
            this.initialize(packages[i]);
        }
        for (i = parents.length - 1; i >= 0; --i) {
            this.initialize(parents[i], errs);
        }
        this.m_loaders.add(ldr);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void initialize(String key) {
        if (this.m_packages.contains(key)) {
            throw new IllegalArgumentException("already loaded: " + key);
        }
        InputStream is = this.m_loader.getResourceAsStream(key + ".config");
        if (is != null) {
            try {
                XML.parse(is, new ConfigRegistryParser());
                this.m_packages.add(key);
            }
            finally {
                try {
                    is.close();
                }
                catch (IOException e) {
                    throw new UncheckedWrapperException(e);
                }
            }
        }
    }

    public List getPackages() {
        return this.m_packages;
    }

    public List getContexts() {
        return this.m_contexts;
    }

    public String getStorage(Class context) {
        if (!this.m_contexts.contains(context)) {
            throw new IllegalArgumentException("no such context: " + context + "; available contexts=" + this.m_contexts + "; context->storage map: " + this.m_storage);
        }
        return (String)this.m_storage.get(context);
    }

    private void addContext(Class context, String storage) {
        this.m_contexts.add(context);
        this.m_storage.put(context, storage);
    }

    public boolean isConfigured(Class context) {
        return this.m_contexts.contains(context);
    }

    public void load(ParameterContext ctx, ErrorList errs) {
        Iterator it = this.m_loaders.iterator();
        while (it.hasNext()) {
            ClassLoader ldr = (ClassLoader)it.next();
            this.load(ctx, errs, ldr);
        }
    }

    public InputStream load(String resource) {
        for (int i = this.m_loaders.size() - 1; i >= 0; --i) {
            ClassLoader ldr = (ClassLoader)this.m_loaders.get(i);
            InputStream is = ldr.getResourceAsStream(resource);
            if (is == null) continue;
            return is;
        }
        return this.m_loader.getResourceAsStream(resource);
    }

    private void load(ParameterContext ctx, ErrorList errs, ClassLoader ldr) {
        Properties props = this.getProperties(ldr, this.getStorage(ctx.getClass()));
        JavaPropertyReader reader = new JavaPropertyReader(props);
        ctx.load(reader, errs);
    }

    private Properties getProperties(ClassLoader ldr, String resource) {
        Properties props = new Properties();
        InputStream is = ldr.getResourceAsStream(resource);
        if (is != null) {
            try {
                props.load(is);
            }
            catch (IOException e) {
                throw new UncheckedWrapperException(e);
            }
            finally {
                try {
                    is.close();
                }
                catch (IOException e) {
                    throw new UncheckedWrapperException(e);
                }
            }
        }
        return props;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class ConfigRegistryParser
    extends DefaultHandler {
        private ConfigRegistryParser() {
        }

        public void startElement(String uri, String localName, String qn, Attributes attrs) {
            if (localName.equals("config")) {
                String klass = attrs.getValue(uri, "class");
                String storage = attrs.getValue(uri, "storage");
                if (klass == null || storage == null) {
                    throw new IllegalArgumentException("class and storage attributes are required");
                }
                Class context = Classes.loadClass(klass);
                ConfigRegistry.this.addContext(context, storage);
            }
        }
    }
}

