/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.packaging;

import com.arsdigita.packaging.Command;
import com.arsdigita.packaging.Config;
import com.arsdigita.packaging.ConfigRegistry;
import com.arsdigita.util.JavaPropertyWriter;
import com.arsdigita.util.parameter.Parameter;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.OptionGroup;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.cli.PosixParser;

class Get
extends Command {
    public static final String versionId = "$Id: //core-platform/dev/src/com/arsdigita/packaging/Get.java#5 $ by $Author: dennis $, $DateTime: 2004/04/07 16:07:11 $";
    private static final Options OPTIONS = Get.getOptions();

    public Get() {
        super("get", "Print one or more values from a CCM configuration database");
    }

    public boolean run(String[] args) {
        List<Parameter> parameters;
        String[] names;
        CommandLine line;
        try {
            line = new PosixParser().parse(OPTIONS, args);
        }
        catch (ParseException e) {
            System.err.println(e.getMessage());
            return false;
        }
        if (args.length == 0) {
            this.usage(OPTIONS, System.err, "[PARAMETERS]");
            return false;
        }
        if (line.hasOption("usage") || line.hasOption("help")) {
            this.usage(OPTIONS, System.out);
            return true;
        }
        ConfigRegistry reg = new ConfigRegistry();
        Config config = new Config(reg);
        config.load(System.err);
        if (line.hasOption("value")) {
            names = new String[]{line.getOptionValue("value")};
            if (line.getArgs().length > 0) {
                System.err.println("--value option does not allow parameters");
                return false;
            }
        } else {
            names = line.getArgs();
        }
        if (line.hasOption("all")) {
            if (names.length > 0) {
                System.err.println("--all option does not allow parameters");
                return false;
            }
            parameters = config.getParameters();
        } else {
            parameters = new ArrayList();
            boolean err = false;
            for (int i = 0; i < names.length; ++i) {
                String name = names[i];
                Parameter param = config.getParameter(name);
                if (param == null) {
                    System.err.println("no such parameter: " + name);
                    err = true;
                    continue;
                }
                parameters.add(param);
            }
            if (err) {
                return false;
            }
        }
        Iterator it = parameters.iterator();
        while (it.hasNext()) {
            Parameter param = (Parameter)it.next();
            Object value = config.get(param);
            Properties props = new Properties();
            JavaPropertyWriter writer = new JavaPropertyWriter(props);
            param.write(writer, value);
            if (line.hasOption("value")) {
                if (props.size() > 1) {
                    System.err.println("not a scalar: " + param.getName());
                    return false;
                }
                System.out.println(props.values().iterator().next());
                continue;
            }
            try {
                this.write(props, System.out);
            }
            catch (IOException e) {
                System.err.println(e.getMessage());
                return false;
            }
        }
        return true;
    }

    private void write(Properties properties, PrintStream out) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        properties.store(baos, null);
        BufferedReader reader = new BufferedReader(new StringReader(baos.toString()));
        String line;
        while ((line = reader.readLine()) != null) {
            if (line.trim().startsWith("#")) continue;
            out.println(line);
        }
        return;
    }

    static {
        OptionGroup group = new OptionGroup();
        OptionBuilder.hasArg((boolean)false);
        OptionBuilder.withLongOpt((String)"all");
        OptionBuilder.withDescription((String)"Lists all configuration parameters");
        group.addOption(OptionBuilder.create());
        OptionBuilder.hasArg();
        OptionBuilder.withLongOpt((String)"value");
        OptionBuilder.withDescription((String)"Prints a scalar value without the key");
        group.addOption(OptionBuilder.create());
        OPTIONS.addOptionGroup(group);
    }
}

