/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.packaging;

import com.arsdigita.core.DBCheck;
import com.arsdigita.loader.PackageLoader;
import com.arsdigita.packaging.Check;
import com.arsdigita.packaging.Command;
import com.arsdigita.packaging.Config;
import com.arsdigita.packaging.ConfigRegistry;
import com.arsdigita.packaging.Loader;
import com.arsdigita.packaging.LoaderInfo;
import com.arsdigita.packaging.ParameterEditor;
import com.arsdigita.packaging.ParameterMap;
import com.arsdigita.packaging.RegistryConfig;
import com.arsdigita.persistence.DedicatedConnectionSource;
import com.arsdigita.persistence.OID;
import com.arsdigita.persistence.Session;
import com.arsdigita.persistence.SessionManager;
import com.arsdigita.persistence.metadata.MetadataRoot;
import com.arsdigita.persistence.pdl.PDLCompiler;
import com.arsdigita.runtime.AbstractScript;
import com.arsdigita.runtime.InteractiveParameterLoader;
import com.arsdigita.runtime.RuntimeConfig;
import com.arsdigita.runtime.Startup;
import com.arsdigita.util.JavaPropertyReader;
import com.arsdigita.util.UncheckedWrapperException;
import com.arsdigita.util.config.JavaPropertyLoader;
import com.arsdigita.util.jdbc.Connections;
import com.arsdigita.util.parameter.CompoundParameterLoader;
import com.arsdigita.util.parameter.Parameter;
import com.arsdigita.util.parameter.ParameterContext;
import com.arsdigita.util.parameter.ParameterReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.cli.PosixParser;

class Load
extends Command {
    public static final String versionId = "$Id: //core-platform/dev/src/com/arsdigita/packaging/Load.java#28 $ by $Author: dennis $, $DateTime: 2004/04/07 16:07:11 $";
    private static final Options OPTIONS = Load.getOptions();
    private static final String INIT = "com.arsdigita.runtime.Initializer";
    private static final int REQ_TABLE = 0;
    private static final int REQ_INITIALIZER = 1;
    private static final int REQ_PACKAGE = 2;
    private static final int PROV_TABLE = 3;
    private static final int PROV_INITIALIZER = 4;
    private static final int PROV_PACKAGE = 5;
    static /* synthetic */ Class class$com$arsdigita$packaging$Load;

    public Load() {
        super("load", "Load a CCM package");
    }

    public boolean run(String[] args) {
        CommandLine line;
        try {
            line = new PosixParser().parse(OPTIONS, args);
        }
        catch (ParseException e) {
            System.err.println(e.getMessage());
            return false;
        }
        List packages = line.getArgList();
        if (packages.isEmpty()) {
            this.usage(OPTIONS, System.err, "PACKAGE-KEYS");
            return false;
        }
        if (line.hasOption("usage") || line.hasOption("help")) {
            this.usage(OPTIONS, System.out, "PACKAGE-KEYS");
            return true;
        }
        boolean all = !line.hasOption("config") && !line.hasOption("schema") && !line.hasOption("data") && !line.hasOption("init");
        RegistryConfig rc = new RegistryConfig();
        rc.load();
        List<String> loaded = Arrays.asList(rc.getPackages());
        HashMap<String, Loader> loaders = new HashMap<String, Loader>();
        ArrayList keys = new ArrayList();
        keys.addAll(packages);
        boolean err = false;
        while (!keys.isEmpty()) {
            String key = (String)keys.remove(0);
            if (loaders.containsKey(key)) continue;
            Loader l = Loader.get(key);
            if (l == null) {
                System.err.println("unable to locate package: " + key);
                err = true;
                continue;
            }
            loaders.put(key, l);
            if (!line.hasOption("recursive")) continue;
            keys.addAll(l.getInfo().getRequiredPackages());
        }
        if (err) {
            return false;
        }
        Loader[] sorted = loaders.values().toArray(new Loader[loaders.size()]);
        Load.sort(sorted);
        if (all) {
            ArrayList missing = new ArrayList();
            Load.addTo(missing, Load.getRequiredPackages(sorted));
            missing.removeAll(Load.getProvidedPackages(sorted));
            missing.removeAll(loaded);
            ArrayList<String> conflicts = new ArrayList<String>(loaded);
            conflicts.retainAll(Load.getProvidedPackages(sorted));
            if (!missing.isEmpty()) {
                System.err.println("required packages: " + missing);
            }
            if (!conflicts.isEmpty()) {
                System.err.println("conflicting packages: " + conflicts);
            }
            if (missing.size() + conflicts.size() > 0) {
                return false;
            }
        }
        ParameterMap contexts = new ParameterMap();
        Properties parameters = new Properties();
        CompoundParameterLoader loader = new CompoundParameterLoader();
        if (line.hasOption("parameter-file")) {
            String file = line.getOptionValue("parameter-file");
            try {
                FileInputStream fis = new FileInputStream(file);
                parameters.load(fis);
                ((InputStream)fis).close();
            }
            catch (IOException e) {
                System.err.println(e.getMessage());
                return false;
            }
            loader.add(new JavaPropertyLoader(parameters));
        }
        if (line.hasOption("parameters")) {
            Properties props = Load.props(line.getOptionValues("parameters"));
            loader.add(new JavaPropertyLoader(props));
            parameters.putAll((Map<?, ?>)props);
        }
        if (line.hasOption("interactive")) {
            loader.add(new InteractiveParameterLoader(System.in, System.out));
        }
        Config config = null;
        try {
            if (all || line.hasOption("config")) {
                ConfigRegistry reg = new ConfigRegistry();
                for (int i = 0; i < sorted.length; ++i) {
                    if (reg.getPackages().contains(sorted[i].getKey())) continue;
                    reg.initialize(sorted[i].getKey());
                }
                config = new Config(reg);
                config.load(System.err);
                Parameter param = config.getParameter("waf.config.packages");
                ParameterContext ctx = config.getContainer(param);
                String[] pkgs = (String[])ctx.get(param);
                for (int i = 0; i < sorted.length; ++i) {
                    if (Load.contains(pkgs, sorted[i].getKey())) continue;
                    pkgs = Load.concat(pkgs, new String[]{sorted[i].getKey()});
                }
                ctx.set(param, pkgs);
                contexts.addContexts(config.getContexts());
            }
            if (all || line.hasOption("data")) {
                for (int i = 0; i < sorted.length; ++i) {
                    contexts.addContexts(sorted[i].getScripts());
                }
            }
            if (!contexts.load((ParameterReader)new JavaPropertyReader(parameters), System.err)) {
                return false;
            }
            if (line.hasOption("interactive")) {
                ParameterEditor editor = new ParameterEditor(contexts, System.in, System.out);
                if (!editor.edit()) {
                    return true;
                }
            } else if (!contexts.validate(System.err)) {
                return false;
            }
            if (!this.saveConfig(config)) {
                return false;
            }
            Session ssn = null;
            if (all || line.hasOption("schema") || line.hasOption("data")) {
                boolean success;
                DBCheck dbcheck = new DBCheck();
                ((AbstractScript)dbcheck).run(null);
                if (dbcheck.getStatus() == null || dbcheck.getStatus().equals(Check.FAIL)) {
                    this.rollbackConfig(config, packages);
                    return false;
                }
                if (all || line.hasOption("schema")) {
                    boolean passed = true;
                    for (int i = 0; i < sorted.length; ++i) {
                        passed &= sorted[i].checkSchema();
                    }
                    if (!passed) {
                        this.rollbackConfig(config, packages);
                        return false;
                    }
                }
                Connection conn = Connections.acquire(RuntimeConfig.getConfig().getJDBCURL());
                ArrayList required = new ArrayList();
                Load.addTo(required, Load.getRequiredTables(sorted));
                ArrayList provided = new ArrayList();
                if (all || line.hasOption("schema")) {
                    required.removeAll(Load.getProvidedTables(sorted));
                    Load.addTo(provided, Load.getProvidedTables(sorted));
                } else if (line.hasOption("data")) {
                    Load.addTo(required, Load.getProvidedTables(sorted));
                }
                List missing = Load.getMissing(conn, required);
                List conflicts = Load.getConflicts(conn, provided);
                if (!missing.isEmpty()) {
                    System.err.println("required tables: " + missing);
                }
                if (!conflicts.isEmpty()) {
                    System.err.println("conflicting tables: " + conflicts);
                }
                if (conflicts.size() > 0 || missing.size() > 0) {
                    this.rollbackConfig(config, packages);
                    return false;
                }
                if (PackageLoader.exists(conn, "inits") && (line.hasOption("init") || all) && !(success = this.checkInitializerDependencies(sorted))) {
                    this.rollbackConfig(config, packages);
                    return false;
                }
                if (all || line.hasOption("schema")) {
                    for (int i = 0; i < sorted.length; ++i) {
                        sorted[i].loadSchema(conn);
                    }
                    try {
                        conn.commit();
                    }
                    catch (SQLException e) {
                        System.err.println(e.getMessage());
                        this.rollbackConfig(config, packages);
                        return false;
                    }
                }
                if (all || line.hasOption("data")) {
                    int i;
                    if (ssn == null) {
                        new Startup().run();
                        ssn = SessionManager.getSession();
                    }
                    boolean passed = true;
                    for (i = 0; i < sorted.length; ++i) {
                        passed &= sorted[i].checkData(ssn);
                    }
                    if (!passed) {
                        this.rollbackConfig(config, packages);
                        return false;
                    }
                    for (i = 0; i < sorted.length; ++i) {
                        sorted[i].loadData(ssn, loader);
                    }
                }
            }
            if (all || line.hasOption("init")) {
                if (ssn == null) {
                    new Startup().run();
                    ssn = SessionManager.getSession();
                }
                for (int i = 0; i < sorted.length; ++i) {
                    sorted[i].loadInits(ssn);
                }
            }
        }
        catch (Throwable t) {
            t.printStackTrace(System.err);
            this.rollbackConfig(config, packages);
            return false;
        }
        return true;
    }

    private boolean checkInitializerDependencies(Loader[] sorted) {
        ArrayList required = new ArrayList();
        ArrayList provided = new ArrayList();
        Load.addTo(required, Load.getRequiredInitializers(sorted));
        required.removeAll(Load.getProvidedInitializers(sorted));
        Load.addTo(provided, Load.getProvidedInitializers(sorted));
        Session boot = Load.session();
        List missing = Load.getMissing(boot, required);
        List conflicts = Load.getConflicts(boot, provided);
        if (!missing.isEmpty()) {
            System.err.println("required initializers: " + missing);
            return false;
        }
        if (!conflicts.isEmpty()) {
            System.err.println("conflicting initializers: " + conflicts);
            return false;
        }
        return true;
    }

    private boolean saveConfig(Config config) {
        if (config != null) {
            try {
                config.save();
            }
            catch (IOException e) {
                System.err.println(e.getMessage());
                return false;
            }
        }
        return true;
    }

    private void rollbackConfig(Config config, List packages) {
        if (config != null) {
            Parameter param = config.getParameter("waf.config.packages");
            ParameterContext ctx = config.getContainer(param);
            String[] pkgs = (String[])ctx.get(param);
            LinkedList<String> original = new LinkedList<String>();
            for (int i = 0; i < pkgs.length; ++i) {
                boolean isnew = false;
                for (int j = 0; j < packages.size(); ++j) {
                    if (pkgs[i].toString() != packages.get(j).toString()) continue;
                    isnew = true;
                }
                if (isnew) continue;
                original.add(pkgs[i]);
            }
            String[] orig = new String[original.size()];
            for (int i = 0; i < original.size(); ++i) {
                orig[i] = (String)original.get(i);
            }
            ctx.set(param, orig);
            this.saveConfig(config);
        }
    }

    private static List getMissing(Connection conn, List tables) {
        ArrayList<String> missing = new ArrayList<String>();
        Iterator it = tables.iterator();
        while (it.hasNext()) {
            String table = (String)it.next();
            if (PackageLoader.exists(conn, table)) continue;
            missing.add(table);
        }
        return missing;
    }

    private static List getConflicts(Connection conn, List tables) {
        ArrayList<String> conflicts = new ArrayList<String>();
        Iterator it = tables.iterator();
        while (it.hasNext()) {
            String table = (String)it.next();
            if (!PackageLoader.exists(conn, table)) continue;
            conflicts.add(table);
        }
        return conflicts;
    }

    private static List getMissing(Session ssn, List inits) {
        ArrayList<String> missing = new ArrayList<String>();
        Iterator it = inits.iterator();
        while (it.hasNext()) {
            String init = (String)it.next();
            OID oid = new OID(ssn.getMetadataRoot().getObjectType(INIT), (Object)init);
            if (ssn.retrieve(oid) != null) continue;
            missing.add(init);
        }
        return missing;
    }

    private static List getConflicts(Session ssn, List inits) {
        ArrayList<String> conflicts = new ArrayList<String>();
        Iterator it = inits.iterator();
        while (it.hasNext()) {
            String init = (String)it.next();
            OID oid = new OID(ssn.getMetadataRoot().getObjectType(INIT), (Object)init);
            if (ssn.retrieve(oid) == null) continue;
            conflicts.add(init);
        }
        return conflicts;
    }

    private static String[] concat(String[] a, String[] b) {
        if (a == null) {
            return b;
        }
        if (b == null) {
            return a;
        }
        String[] result = new String[a.length + b.length];
        System.arraycopy(a, 0, result, 0, a.length);
        System.arraycopy(b, 0, result, a.length, b.length);
        return result;
    }

    private static boolean contains(String[] array, String str) {
        for (int i = 0; i < array.length; ++i) {
            if (!array[i].equals(str)) continue;
            return true;
        }
        return false;
    }

    private static Session session() {
        Session ssn = SessionManager.getSession("loader");
        if (ssn == null) {
            String pdl = "/com/arsdigita/runtime/Initializer.pdl";
            MetadataRoot root = new MetadataRoot();
            PDLCompiler compiler = new PDLCompiler();
            compiler.parse(new InputStreamReader((class$com$arsdigita$packaging$Load == null ? (class$com$arsdigita$packaging$Load = Load.class$("com.arsdigita.packaging.Load")) : class$com$arsdigita$packaging$Load).getResourceAsStream(pdl)), pdl);
            compiler.emit(root);
            DedicatedConnectionSource source = new DedicatedConnectionSource(RuntimeConfig.getConfig().getJDBCURL());
            ssn = SessionManager.open("loader", root, source);
        }
        return ssn;
    }

    static Properties props(String[] args) {
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            OutputStreamWriter w = new OutputStreamWriter(baos);
            for (int i = 0; i < args.length; ++i) {
                w.write(args[i]);
                w.write("\n");
            }
            ((Writer)w).flush();
            Properties props = new Properties();
            props.load(new ByteArrayInputStream(baos.toByteArray()));
            return props;
        }
        catch (IOException e) {
            throw new UncheckedWrapperException(e);
        }
    }

    private static void sort(Loader[] loaders) {
        int before;
        HashSet all = new HashSet();
        for (int i = 0; i < loaders.length; ++i) {
            all.addAll(loaders[i].getProvided());
        }
        HashSet provided = new HashSet();
        ArrayList<Loader> sorted = new ArrayList<Loader>();
        ArrayList<Loader> in = new ArrayList<Loader>(Arrays.asList(loaders));
        do {
            before = in.size();
            Iterator it = in.iterator();
            while (it.hasNext()) {
                Loader loader = (Loader)it.next();
                Set required = loader.getRequired();
                required.retainAll(all);
                if (!provided.containsAll(required)) continue;
                sorted.add(loader);
                provided.addAll(loader.getProvided());
                it.remove();
            }
        } while (in.size() < before);
        if (in.size() > 0) {
            throw new IllegalStateException("circular dependencies: " + in);
        }
        int index = 0;
        Iterator it = sorted.iterator();
        while (it.hasNext()) {
            loaders[index++] = (Loader)it.next();
        }
    }

    /*
     * WARNING - void declaration
     */
    private static List get(Loader[] loaders, int type) {
        ArrayList result = new ArrayList();
        for (int i = 0; i < loaders.length; ++i) {
            void var5_5;
            LoaderInfo info = loaders[i].getInfo();
            switch (type) {
                case 0: {
                    ArrayList<String> c = info.getRequiredTables();
                    break;
                }
                case 1: {
                    ArrayList<String> c = info.getRequiredInitializers();
                    break;
                }
                case 2: {
                    ArrayList<String> c = info.getRequiredPackages();
                    break;
                }
                case 3: {
                    ArrayList<String> c = info.getProvidedTables();
                    break;
                }
                case 4: {
                    ArrayList<String> c = info.getProvidedInitializers();
                    break;
                }
                case 5: {
                    ArrayList<String> c = new ArrayList<String>();
                    c.add(loaders[i].getKey());
                    break;
                }
                default: {
                    throw new IllegalArgumentException("unknown type: " + type);
                }
            }
            Load.addTo(result, (List)var5_5);
        }
        return result;
    }

    private static List getRequiredTables(Loader[] loaders) {
        return Load.get(loaders, 0);
    }

    private static List getProvidedTables(Loader[] loaders) {
        return Load.get(loaders, 3);
    }

    private static List getRequiredInitializers(Loader[] loaders) {
        return Load.get(loaders, 1);
    }

    private static List getProvidedInitializers(Loader[] loaders) {
        return Load.get(loaders, 4);
    }

    private static List getRequiredPackages(Loader[] loaders) {
        return Load.get(loaders, 2);
    }

    private static List getProvidedPackages(Loader[] loaders) {
        return Load.get(loaders, 5);
    }

    private static void addTo(List a, List b) {
        Iterator it = b.iterator();
        while (it.hasNext()) {
            Object o = it.next();
            if (a.contains(o)) continue;
            a.add(o);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        OptionBuilder.hasArg((boolean)false);
        OptionBuilder.withLongOpt((String)"config");
        OptionBuilder.withDescription((String)"Load configuration");
        OPTIONS.addOption(OptionBuilder.create());
        OptionBuilder.hasArg((boolean)false);
        OptionBuilder.withLongOpt((String)"schema");
        OptionBuilder.withDescription((String)"Load schema");
        OPTIONS.addOption(OptionBuilder.create());
        OptionBuilder.hasArg((boolean)false);
        OptionBuilder.withLongOpt((String)"data");
        OptionBuilder.withDescription((String)"Load data");
        OPTIONS.addOption(OptionBuilder.create());
        OptionBuilder.hasArg((boolean)false);
        OptionBuilder.withLongOpt((String)"init");
        OptionBuilder.withDescription((String)"Load initializers");
        OPTIONS.addOption(OptionBuilder.create());
        OptionBuilder.hasArg();
        OptionBuilder.withLongOpt((String)"parameter-file");
        OptionBuilder.withArgName((String)"FILE");
        OptionBuilder.withDescription((String)"Use key-value pairs from FILE");
        OPTIONS.addOption(OptionBuilder.create());
        OptionBuilder.hasArg((boolean)false);
        OptionBuilder.withLongOpt((String)"interactive");
        OptionBuilder.withDescription((String)"Prompt for required parameter values");
        OPTIONS.addOption(OptionBuilder.create());
        OptionBuilder.hasArgs();
        OptionBuilder.withLongOpt((String)"parameters");
        OptionBuilder.withArgName((String)"KEY=VALUE ...");
        OptionBuilder.withDescription((String)"Use key-value pairs from command line");
        OPTIONS.addOption(OptionBuilder.create());
        OptionBuilder.hasArg((boolean)false);
        OptionBuilder.withLongOpt((String)"recursive");
        OptionBuilder.withDescription((String)"Recursively load required packages");
        OPTIONS.addOption(OptionBuilder.create());
    }
}

