/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.packaging;

import com.arsdigita.db.DbHelper;
import com.arsdigita.kernel.Kernel;
import com.arsdigita.kernel.KernelExcursion;
import com.arsdigita.loader.PackageLoader;
import com.arsdigita.packaging.Checklist;
import com.arsdigita.packaging.LoaderInfo;
import com.arsdigita.persistence.DataAssociation;
import com.arsdigita.persistence.DataObject;
import com.arsdigita.persistence.OID;
import com.arsdigita.persistence.Session;
import com.arsdigita.persistence.TransactionContext;
import com.arsdigita.runtime.CompoundInitializer;
import com.arsdigita.runtime.Initializer;
import com.arsdigita.runtime.Script;
import com.arsdigita.runtime.ScriptContext;
import com.arsdigita.runtime.Startup;
import com.arsdigita.util.Classes;
import com.arsdigita.util.UncheckedWrapperException;
import com.arsdigita.util.parameter.ParameterLoader;
import java.io.IOException;
import java.io.InputStream;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.log4j.Logger;

class Loader {
    private static final Logger s_log = Logger.getLogger((Class)(class$com$arsdigita$packaging$Loader == null ? (class$com$arsdigita$packaging$Loader = Loader.class$("com.arsdigita.packaging.Loader")) : class$com$arsdigita$packaging$Loader));
    public static final String versionId = "$Id: //core-platform/dev/src/com/arsdigita/packaging/Loader.java#12 $ by $Author: dennis $, $DateTime: 2004/04/07 16:07:11 $";
    private static final String INIT = "com.arsdigita.runtime.Initializer";
    private String m_key;
    private LoaderInfo m_info;
    private Checklist m_checks;
    private List m_scripts;
    static /* synthetic */ Class class$com$arsdigita$packaging$Loader;

    public static Loader get(String pkg) {
        ClassLoader ldr = (class$com$arsdigita$packaging$Loader == null ? (class$com$arsdigita$packaging$Loader = Loader.class$("com.arsdigita.packaging.Loader")) : class$com$arsdigita$packaging$Loader).getClassLoader();
        InputStream is = ldr.getResourceAsStream(pkg + ".load");
        if (is == null) {
            return null;
        }
        LoaderInfo info = new LoaderInfo(is);
        try {
            is.close();
        }
        catch (IOException e) {
            throw new UncheckedWrapperException(e);
        }
        return new Loader(pkg, info, Checklist.get(pkg));
    }

    public Loader(String key, LoaderInfo info, Checklist checks) {
        this.m_key = key;
        this.m_info = info;
        this.m_checks = checks;
        this.m_scripts = new ArrayList();
        Iterator it = this.m_info.getDataScripts().iterator();
        while (it.hasNext()) {
            String script = (String)it.next();
            this.m_scripts.add(Classes.newInstance(script));
        }
    }

    public String getKey() {
        return this.m_key;
    }

    public LoaderInfo getInfo() {
        return this.m_info;
    }

    public List getScripts() {
        return this.m_scripts;
    }

    public boolean checkSchema() {
        if (this.m_checks == null) {
            return true;
        }
        return this.m_checks.run(0, new ScriptContext(null, null));
    }

    public void loadSchema(Connection conn) {
        int db = DbHelper.getDatabase(conn);
        String dir = DbHelper.getDatabaseDirectory(db);
        List scripts = this.m_info.getSchemaScripts();
        Iterator it = scripts.iterator();
        while (it.hasNext()) {
            String script = (String)it.next();
            s_log.info((Object)("Loading schema for " + script));
            PackageLoader.load(conn, script + "/" + dir + "-create.sql");
        }
    }

    public boolean checkData(Session ssn) {
        if (this.m_checks == null) {
            return true;
        }
        return this.m_checks.run(1, new ScriptContext(ssn, null));
    }

    public void loadData(Session ssn, ParameterLoader loader) {
        List inits = this.m_info.getProvidedInitializers();
        CompoundInitializer ini = new CompoundInitializer();
        Iterator it = inits.iterator();
        while (it.hasNext()) {
            String init = (String)it.next();
            s_log.info((Object)("Running initializer " + init));
            ini.add((Initializer)Classes.newInstance(init));
        }
        Startup.run(ssn, ini);
        TransactionContext txn = ssn.getTransactionContext();
        txn.beginTxn();
        final ScriptContext ctx = new ScriptContext(ssn, loader);
        new KernelExcursion(){

            protected void excurse() {
                this.setEffectiveParty(Kernel.getSystemParty());
                Iterator it = Loader.this.m_scripts.iterator();
                while (it.hasNext()) {
                    Script script = (Script)it.next();
                    s_log.info((Object)("Running data loader " + script.getClass().getName()));
                    script.run(ctx);
                }
            }
        }.run();
        if (txn.inTxn()) {
            txn.commitTxn();
        }
    }

    public void loadInits(Session ssn) {
        TransactionContext txn = ssn.getTransactionContext();
        txn.beginTxn();
        List inits = this.m_info.getProvidedInitializers();
        List required = this.m_info.getRequiredInitializers();
        Iterator it = inits.iterator();
        while (it.hasNext()) {
            String init = (String)it.next();
            DataObject dataobject = ssn.create(new OID(INIT, (Object)init));
            DataAssociation da = (DataAssociation)dataobject.get("requirements");
            Iterator reqit = required.iterator();
            while (reqit.hasNext()) {
                String reqinit = (String)reqit.next();
                da.add(ssn.retrieve(new OID(INIT, (Object)reqinit)));
            }
        }
        if (txn.inTxn()) {
            txn.commitTxn();
        }
    }

    Set getRequired() {
        HashSet result = new HashSet();
        result.addAll(this.m_info.getRequiredTables());
        result.addAll(this.m_info.getRequiredInitializers());
        result.addAll(this.m_info.getRequiredPackages());
        return result;
    }

    Set getProvided() {
        HashSet<String> result = new HashSet<String>();
        result.addAll(this.m_info.getProvidedTables());
        result.addAll(this.m_info.getProvidedInitializers());
        result.add(this.m_key);
        return result;
    }

    public String toString() {
        return "<loader for " + this.m_key + ">";
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

