/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.packaging;

import com.arsdigita.xml.XML;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.xml.sax.Attributes;
import org.xml.sax.helpers.DefaultHandler;

class LoaderInfo {
    public static final String versionId = "$Id: //core-platform/dev/src/com/arsdigita/packaging/LoaderInfo.java#5 $ by $Author: dennis $, $DateTime: 2004/04/07 16:07:11 $";
    private List m_requiredTables = new ArrayList();
    private List m_providedTables = new ArrayList();
    private List m_requiredInitializers = new ArrayList();
    private List m_providedInitializers = new ArrayList();
    private List m_schemaScripts = new ArrayList();
    private List m_dataScripts = new ArrayList();
    private List m_requiredPackages = new ArrayList();
    private static final String PROVIDES = "provides";
    private static final String REQUIRES = "requires";
    private static final String TABLE = "table";
    private static final String INITIALIZER = "initializer";
    private static final String PACKAGE = "package";
    private static final String SCRIPTS = "scripts";
    private static final String SCHEMA = "schema";
    private static final String DATA = "data";
    private static final String NAME = "name";
    private static final String CLASS = "class";
    private static final String DIRECTORY = "directory";

    public LoaderInfo(InputStream is) {
        XML.parse(is, new LoaderInfoHandler());
    }

    public List getRequiredTables() {
        return this.m_requiredTables;
    }

    public List getProvidedTables() {
        return this.m_providedTables;
    }

    public List getRequiredInitializers() {
        return this.m_requiredInitializers;
    }

    public List getProvidedInitializers() {
        return this.m_providedInitializers;
    }

    public List getRequiredPackages() {
        return this.m_requiredPackages;
    }

    public List getSchemaScripts() {
        return this.m_schemaScripts;
    }

    public List getDataScripts() {
        return this.m_dataScripts;
    }

    private class LoaderInfoHandler
    extends DefaultHandler {
        private List m_context = new ArrayList();

        private LoaderInfoHandler() {
        }

        public void startElement(String uri, String name, String qn, Attributes attrs) {
            if (name.equals(LoaderInfo.TABLE)) {
                String table = attrs.getValue(uri, LoaderInfo.NAME);
                if (table == null) {
                    throw new IllegalStateException("table element requires name attribute");
                }
                if (this.m_context.contains(LoaderInfo.REQUIRES)) {
                    LoaderInfo.this.m_requiredTables.add(table);
                } else if (this.m_context.contains(LoaderInfo.PROVIDES)) {
                    LoaderInfo.this.m_providedTables.add(table);
                } else {
                    throw new IllegalStateException("table element must appear inside requires or provides");
                }
            }
            if (name.equals(LoaderInfo.INITIALIZER)) {
                String init = attrs.getValue(uri, LoaderInfo.CLASS);
                if (init == null) {
                    throw new IllegalStateException("init element requires class attribute");
                }
                if (this.m_context.contains(LoaderInfo.REQUIRES)) {
                    LoaderInfo.this.m_requiredInitializers.add(init);
                } else if (this.m_context.contains(LoaderInfo.PROVIDES)) {
                    LoaderInfo.this.m_providedInitializers.add(init);
                } else {
                    throw new IllegalStateException("initializer element must appear inside requires or provides");
                }
            }
            if (name.equals(LoaderInfo.PACKAGE)) {
                String key = attrs.getValue(uri, LoaderInfo.NAME);
                if (key == null) {
                    throw new IllegalStateException("package element requires name attribute");
                }
                if (this.m_context.contains(LoaderInfo.REQUIRES)) {
                    LoaderInfo.this.m_requiredPackages.add(key);
                } else {
                    throw new IllegalStateException("package element must appear inside requires");
                }
            }
            if (name.equals(LoaderInfo.SCHEMA)) {
                if (!this.m_context.contains(LoaderInfo.SCRIPTS)) {
                    throw new IllegalStateException("schema element must appear inside scripts");
                }
                String dir = attrs.getValue(uri, LoaderInfo.DIRECTORY);
                if (dir == null) {
                    throw new IllegalStateException("schema element requires directory attribute");
                }
                LoaderInfo.this.m_schemaScripts.add(dir);
            }
            if (name.equals(LoaderInfo.DATA)) {
                if (!this.m_context.contains(LoaderInfo.SCRIPTS)) {
                    throw new IllegalStateException("data element must appear inside scripts");
                }
                String klass = attrs.getValue(uri, LoaderInfo.CLASS);
                if (klass == null) {
                    throw new IllegalStateException("data element requires class attribute");
                }
                LoaderInfo.this.m_dataScripts.add(klass);
            }
            this.m_context.add(name);
        }

        public void endElement(String uri, String name, String qn) {
            this.m_context.remove(this.m_context.lastIndexOf(name));
        }
    }
}

