/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.packaging;

import com.arsdigita.packaging.Clear;
import com.arsdigita.packaging.Command;
import com.arsdigita.packaging.Get;
import com.arsdigita.packaging.Help;
import com.arsdigita.packaging.Load;
import com.arsdigita.packaging.Set;
import com.arsdigita.packaging.Status;
import com.arsdigita.packaging.Unload;
import com.arsdigita.packaging.Upgrade;
import com.arsdigita.packaging.Usage;
import com.arsdigita.packaging.Which;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class MasterTool {
    public static final String versionId = "$Id: //core-platform/dev/src/com/arsdigita/packaging/MasterTool.java#10 $$Author: dennis $$DateTime: 2004/04/07 16:07:11 $";
    private static final Logger s_log = Logger.getLogger((Class)(class$com$arsdigita$packaging$MasterTool == null ? (class$com$arsdigita$packaging$MasterTool = MasterTool.class$("com.arsdigita.packaging.MasterTool")) : class$com$arsdigita$packaging$MasterTool));
    static /* synthetic */ Class class$com$arsdigita$packaging$MasterTool;

    private static void usage(Commands cmds, PrintStream out) {
        out.println("usage: ccm [OPTIONS | COMMAND]");
        out.println();
        out.println("Options:");
        out.println("  --help     Display help");
        out.println("  --usage    Print this message");
        out.println();
        out.println("Commands:");
        out.print(cmds.getCommands());
    }

    public static final void main(String[] args) {
        String name;
        Command cmd;
        PrintStream out = System.out;
        PrintStream err = System.err;
        Commands cmds = new Commands();
        Help help = new Help();
        Usage usage = new Usage();
        cmds.add(help, true);
        cmds.add(usage, true);
        cmds.add(new Load());
        cmds.add(new Unload(), true);
        cmds.add(new Upgrade());
        cmds.add(new Get());
        cmds.add(new Set());
        cmds.add(new Clear());
        cmds.add(new Status());
        cmds.add(new Which());
        if (args.length == 0) {
            MasterTool.usage(cmds, err);
            System.exit(1);
        }
        if ((cmd = cmds.get(name = args[0])) == null) {
            err.println("no such command: " + name);
            System.exit(1);
        }
        String[] command = new String[args.length - 1];
        System.arraycopy(args, 1, command, 0, command.length);
        boolean result = cmd.run(command);
        if (cmd == help || cmd == usage) {
            MasterTool.usage(cmds, out);
        }
        if (result) {
            System.exit(0);
        } else {
            System.exit(1);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static final class Commands {
        private List m_commands = new ArrayList();
        private Map m_map = new HashMap();
        private int m_maxName = 0;
        private HashSet m_hidden = new HashSet();

        public void add(Command command, boolean hidden) {
            this.m_commands.add(command);
            String name = command.getName();
            this.m_map.put(name, command);
            int length = name.length();
            if (length > this.m_maxName) {
                this.m_maxName = length;
            }
            if (hidden) {
                this.m_hidden.add(command);
            }
        }

        public void add(Command command) {
            this.add(command, false);
        }

        public Command get(String name) {
            return (Command)this.m_map.get(name);
        }

        public String getCommands() {
            StringBuffer result = new StringBuffer();
            Iterator it = this.m_commands.iterator();
            while (it.hasNext()) {
                Command cmd = (Command)it.next();
                if (this.m_hidden.contains(cmd)) continue;
                String line = "  " + cmd.getName();
                result.append(line);
                for (int i = 0; i < this.m_maxName + 6 - line.length(); ++i) {
                    result.append(" ");
                }
                result.append(cmd.getSummary() + "\n");
            }
            return result.toString();
        }
    }
}

