/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.packaging;

import com.arsdigita.util.UncheckedWrapperException;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

class Menu {
    public static final String versionId = "$Id: //core-platform/dev/src/com/arsdigita/packaging/Menu.java#5 $ by $Author: dennis $, $DateTime: 2004/04/07 16:07:11 $";
    public static final Layout VERTICAL = new Layout();
    public static final Layout HORIZONTAL = new Layout();
    public static final Item GAP = new Item(){

        public String getDescription() {
            return null;
        }

        public void act() {
        }
    };
    private List m_entries = new ArrayList();
    private Map m_keys = new HashMap();
    private BufferedReader m_in;
    private PrintStream m_out;
    private int m_padd;

    public Menu(BufferedReader in, PrintStream out) {
        this.m_in = in;
        this.m_out = out;
        this.m_padd = 0;
    }

    public void add(Item item) {
        this.add(null, item);
    }

    public void add(String key, Item item) {
        this.add(key, item, VERTICAL);
    }

    public void add(String key, Item item, Layout layout) {
        Entry entry = new Entry(key, item, layout);
        this.m_entries.add(entry);
        if (key != null) {
            this.m_keys.put(key, entry);
            int length = key.length();
            if (length > this.m_padd) {
                this.m_padd = length;
            }
        }
    }

    public void display() {
        boolean first = true;
        int column = 0;
        Iterator it = this.m_entries.iterator();
        while (it.hasNext()) {
            String description;
            Entry entry = (Entry)it.next();
            Item item = entry.getItem();
            String key = entry.getKey();
            Layout layout = entry.getLayout();
            StringBuffer buf = new StringBuffer();
            if (key != null) {
                for (int i = 0; i < this.m_padd + 2 - key.length(); ++i) {
                    buf.append(" ");
                }
                buf.append("[" + key + "]");
            }
            if ((description = item.getDescription()) != null) {
                buf.append(" " + description);
            }
            if (!first && layout == VERTICAL || column + buf.length() > 79) {
                this.m_out.println();
                column = 0;
            }
            this.m_out.print(buf.toString());
            column += buf.length();
            if (!first) continue;
            first = false;
        }
        this.m_out.println();
    }

    public Item choose(String prompt) {
        Entry entry;
        while (true) {
            String line;
            this.m_out.print(prompt);
            this.m_out.flush();
            try {
                line = this.m_in.readLine();
            }
            catch (IOException e) {
                throw new UncheckedWrapperException(e);
            }
            if (line == null) {
                return null;
            }
            if ((line = line.trim()).equals("")) continue;
            entry = (Entry)this.m_keys.get(line);
            if (entry != null) break;
            this.m_out.println("  * no such item: " + line);
        }
        return entry.getItem();
    }

    private class Entry {
        private String m_key;
        private Item m_item;
        private Layout m_layout;

        public Entry(String key, Item item, Layout layout) {
            this.m_key = key;
            this.m_item = item;
            this.m_layout = layout;
        }

        public String getKey() {
            return this.m_key;
        }

        public Item getItem() {
            return this.m_item;
        }

        public Layout getLayout() {
            return this.m_layout;
        }
    }

    static interface Item {
        public String getDescription();

        public void act();
    }

    static final class Layout {
        private Layout() {
        }
    }
}

