/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.packaging;

import com.arsdigita.packaging.Command;
import com.arsdigita.packaging.Config;
import com.arsdigita.packaging.ConfigRegistry;
import com.arsdigita.packaging.Load;
import com.arsdigita.packaging.ParameterEditor;
import com.arsdigita.util.JavaPropertyReader;
import com.arsdigita.util.parameter.ParameterReader;
import java.io.IOException;
import java.util.Iterator;
import java.util.Properties;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.cli.PosixParser;

class Set
extends Command {
    public static final String versionId = "$Id: //core-platform/dev/src/com/arsdigita/packaging/Set.java#6 $ by $Author: dennis $, $DateTime: 2004/04/07 16:07:11 $";
    private static final Options OPTIONS = Set.getOptions();

    public Set() {
        super("set", "Set one or more values in a CCM configuration database");
    }

    public boolean run(String[] args) {
        CommandLine line;
        try {
            line = new PosixParser().parse(OPTIONS, args);
        }
        catch (ParseException e) {
            System.err.println(e.getMessage());
            return false;
        }
        if (args.length == 0) {
            this.usage(OPTIONS, System.err, "[KEY=VALUE...]");
            return false;
        }
        if (line.hasOption("usage") || line.hasOption("help")) {
            this.usage(OPTIONS, System.out, "[KEY=VALUE...]");
            return true;
        }
        ConfigRegistry reg = new ConfigRegistry();
        Config config = new Config(reg);
        config.load(System.err);
        Properties props = Load.props(line.getArgs());
        boolean valid = true;
        Iterator<Object> it = props.keySet().iterator();
        while (it.hasNext()) {
            String param = (String)it.next();
            if (config.getParameter(param) != null) continue;
            System.out.println("no such parameter: " + param);
            valid = false;
        }
        if (!valid) {
            return false;
        }
        if (!config.load((ParameterReader)new JavaPropertyReader(props), System.err)) {
            return false;
        }
        if (line.hasOption("interactive")) {
            ParameterEditor editor = new ParameterEditor(config, System.in, System.out);
            if (!editor.edit()) {
                return true;
            }
        } else if (!config.validate(System.err)) {
            return false;
        }
        try {
            config.save();
        }
        catch (IOException e) {
            System.err.println(e.getMessage());
            return false;
        }
        return true;
    }

    static {
        OptionBuilder.hasArg((boolean)false);
        OptionBuilder.withLongOpt((String)"interactive");
        OptionBuilder.withDescription((String)"Interactively edit configuration values");
        OPTIONS.addOption(OptionBuilder.create());
    }
}

