/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.packaging;

import com.arsdigita.packaging.Command;
import com.arsdigita.packaging.Files;
import com.arsdigita.runtime.CCM;
import java.io.File;
import java.io.FileFilter;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.cli.PosixParser;

class Unload
extends Command {
    public static final String versionId = "$Id: //core-platform/dev/src/com/arsdigita/packaging/Unload.java#5 $ by $Author: dennis $, $DateTime: 2004/04/07 16:07:11 $";
    private static final Options OPTIONS = new Options();
    private static final Set EXCLUDE;

    public Unload() {
        super("unload", "Unload configuration");
    }

    public boolean run(String[] args) {
        CommandLine line;
        try {
            line = new PosixParser().parse(OPTIONS, args);
        }
        catch (ParseException e) {
            System.err.println(e.getMessage());
            return false;
        }
        String[] packages = line.getArgs();
        if (packages.length == 0) {
            this.usage(OPTIONS, System.err);
            return false;
        }
        if (line.hasOption("config")) {
            File conf = CCM.getConfigDirectory();
            File[] files = conf.listFiles(new FileFilter(){

                public boolean accept(File file) {
                    return !EXCLUDE.contains(file.getName());
                }
            });
            for (int i = 0; i < files.length; ++i) {
                Files.delete(files[i]);
            }
        }
        return true;
    }

    static {
        OptionBuilder.hasArg((boolean)false);
        OptionBuilder.withLongOpt((String)"config");
        OptionBuilder.withDescription((String)"Unload configuration");
        OPTIONS.addOption(OptionBuilder.create());
        EXCLUDE = new HashSet();
        EXCLUDE.add("resin.conf");
        EXCLUDE.add("resin.pid");
        EXCLUDE.add("server.xml");
    }
}

