/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.persistence;

import com.arsdigita.persistence.C;
import com.arsdigita.persistence.DataAssociation;
import com.arsdigita.persistence.DataAssociationCursor;
import com.arsdigita.persistence.DataAssociationCursorImpl;
import com.arsdigita.persistence.DataCollection;
import com.arsdigita.persistence.DataObject;
import com.arsdigita.persistence.OID;
import com.arsdigita.persistence.PersistenceException;
import com.arsdigita.persistence.Session;
import com.arsdigita.persistence.metadata.Property;
import com.redhat.persistence.ProtoException;

class DataAssociationImpl
extends DataAssociationCursorImpl
implements DataAssociation {
    public static final String versionId = "$Id: //core-platform/dev/src/com/arsdigita/persistence/DataAssociationImpl.java#20 $ by $Author: dennis $, $DateTime: 2004/04/07 16:07:11 $";
    private com.redhat.persistence.Session m_pssn;
    private DataObject m_data;
    private Property m_prop;
    private com.redhat.persistence.metadata.Property m_pprop;

    DataAssociationImpl(Session ssn, DataObject data, Property prop) {
        super(ssn, data, prop);
        this.setAssociation(this);
        this.m_pssn = ssn.getProtoSession();
        this.m_data = data;
        this.m_prop = prop;
        this.m_pprop = C.prop(this.m_pssn.getRoot(), prop);
    }

    public DataObject add(DataObject obj) {
        try {
            return (DataObject)this.m_pssn.add(this.m_data, this.m_pprop, obj);
        }
        catch (ProtoException pe) {
            throw PersistenceException.newInstance(pe);
        }
    }

    com.redhat.persistence.metadata.Property getProperty() {
        return this.m_pprop;
    }

    public void clear() {
        this.m_pssn.clear(this.m_data, this.m_pprop);
    }

    public DataCollection getDataCollection() {
        return this.cursor();
    }

    public DataAssociationCursor getDataAssociationCursor() {
        DataAssociationCursorImpl dac = new DataAssociationCursorImpl(this.getSession(), this.m_data, this.m_prop);
        dac.setAssociation(this);
        return dac;
    }

    public DataAssociationCursor cursor() {
        return this.getDataAssociationCursor();
    }

    public void remove(DataObject obj) {
        try {
            this.m_pssn.remove(this.m_data, this.m_pprop, obj);
        }
        catch (ProtoException pe) {
            throw PersistenceException.newInstance(pe);
        }
    }

    public void remove(OID oid) {
        this.remove(this.getSession().retrieve(oid));
    }

    public boolean isModified() {
        return !this.m_pssn.isFlushed(this.m_data, this.m_pprop);
    }
}

