/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.persistence;

import com.arsdigita.persistence.AfterEvent;
import com.arsdigita.persistence.AfterSaveEvent;
import com.arsdigita.persistence.BeforeEvent;
import com.arsdigita.persistence.BeforeSaveEvent;
import com.arsdigita.persistence.C;
import com.arsdigita.persistence.DataAssociationImpl;
import com.arsdigita.persistence.DataEvent;
import com.arsdigita.persistence.DataObject;
import com.arsdigita.persistence.DataObserver;
import com.arsdigita.persistence.OID;
import com.arsdigita.persistence.PersistenceException;
import com.arsdigita.persistence.Session;
import com.arsdigita.persistence.SessionManager;
import com.arsdigita.persistence.metadata.ObjectType;
import com.arsdigita.persistence.metadata.Property;
import com.redhat.persistence.PropertyMap;
import com.redhat.persistence.ProtoException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

class DataObjectImpl
implements DataObject {
    public static final String versionId = "$Id: //core-platform/dev/src/com/arsdigita/persistence/DataObjectImpl.java#23 $ by $Author: dennis $, $DateTime: 2004/04/07 16:07:11 $";
    static final Logger s_log = Logger.getLogger((Class)(class$com$arsdigita$persistence$DataObjectImpl == null ? (class$com$arsdigita$persistence$DataObjectImpl = DataObjectImpl.class$("com.arsdigita.persistence.DataObjectImpl")) : class$com$arsdigita$persistence$DataObjectImpl));
    private com.redhat.persistence.Session m_ssn;
    private OID m_oid;
    private List m_observers = new ArrayList();
    private Map m_disconnect = null;
    private boolean m_manualDisconnect = false;
    private Throwable m_invalidStack = null;
    private boolean m_valid = true;
    private boolean m_transactionDone = false;
    PropertyMap p_pMap;
    com.redhat.persistence.metadata.ObjectType p_objectType;
    private ObserverEntry m_firing = null;
    static /* synthetic */ Class class$com$arsdigita$persistence$DataObjectImpl;

    DataObjectImpl(ObjectType type) {
        this.m_oid = new OID(type);
    }

    DataObjectImpl(OID oid) {
        this.m_oid = oid;
    }

    void setSession(com.redhat.persistence.Session ssn) {
        this.m_ssn = ssn;
    }

    private com.redhat.persistence.Session getSsn() {
        if (this.isDisconnected()) {
            throw new IllegalStateException("There was an error in disconnected object implementation. Disconnected data object can not access session.");
        }
        if (!this.isDisconnected() && this.m_ssn != null && SessionManager.getSession() != null && this.m_ssn != SessionManager.getSession().getProtoSession()) {
            throw new PersistenceException("This data object: (" + this + ") is being accessed from " + "another thread before its originating transaction has " + "terminated.");
        }
        return this.m_ssn;
    }

    private com.redhat.persistence.metadata.Property convert(String property) {
        return C.prop(this.m_ssn.getRoot(), this.getObjectType().getProperty(property));
    }

    public Session getSession() {
        if (this.isDisconnected()) {
            return SessionManager.getSession();
        }
        return Session.getSessionFromProto(this.getSsn());
    }

    public ObjectType getObjectType() {
        return this.m_oid.getObjectType();
    }

    public OID getOID() {
        return this.m_oid;
    }

    public Object get(String property) {
        this.validate();
        Property prop = this.getObjectType().getProperty(property);
        if (prop == null) {
            throw new PersistenceException("no such property: " + property + " for " + this);
        }
        if (prop.isCollection()) {
            if (this.isDisconnected()) {
                return new DataAssociationImpl(SessionManager.getSession(), this, prop);
            }
            return new DataAssociationImpl(this.getSession(), this, prop);
        }
        if (prop.isKeyProperty()) {
            return this.m_oid.get(property);
        }
        if (this.m_oid.isInitialized()) {
            DataObjectImpl dobj;
            if (this.isDisconnected()) {
                this.doDisconnect();
                Object obj = this.m_disconnect.get(prop);
                if (this.m_disconnect.containsKey(prop) && (!(obj instanceof DataObjectImpl) || ((DataObjectImpl)obj).isValid())) {
                    return obj;
                }
                obj = this.get(SessionManager.getSession().getProtoSession(), this.convert(property));
                if (obj instanceof DataObjectImpl) {
                    DataObjectImpl dobj2 = (DataObjectImpl)obj;
                    dobj2.disconnect();
                    if (!dobj2.isValid()) {
                        throw new IllegalStateException("got invalid data object from session: " + obj);
                    }
                }
                this.m_disconnect.put(prop, obj);
                return obj;
            }
            Object result = this.get(this.getSsn(), this.convert(property));
            if (result instanceof DataObjectImpl && (dobj = (DataObjectImpl)result).isDisconnected()) {
                result = this.getSession().retrieve(dobj.getOID());
            }
            return result;
        }
        return null;
    }

    private void doDisconnect() {
        if (this.m_disconnect != null) {
            return;
        }
        this.m_disconnect = new HashMap();
        if (this.m_ssn.isDeleted(this)) {
            return;
        }
        if (!this.m_manualDisconnect && s_log.isDebugEnabled()) {
            s_log.debug((Object)("autodisconnect: " + this.getOID()), new Throwable());
        }
        com.redhat.persistence.Session ssn = SessionManager.getSession().getProtoSession();
        Iterator it = this.getObjectType().getProperties();
        while (it.hasNext()) {
            Property p = (Property)it.next();
            if (p.isCollection() || p.isKeyProperty() || !p.getType().isSimple()) continue;
            this.m_disconnect.put(p, this.get(ssn, C.prop(this.m_ssn.getRoot(), p)));
        }
        this.m_ssn.releaseObject(this);
    }

    public void set(String property, Object value) {
        this.validateWrite();
        if ("".equals(value)) {
            value = null;
        }
        try {
            Property prop = this.getObjectType().getProperty(property);
            if (prop == null) {
                throw new PersistenceException("no such property: " + property + " for " + this);
            }
            if (prop.isKeyProperty()) {
                this.m_oid.set(property, value);
                if (this.m_oid.isInitialized()) {
                    this.getSsn().create(this);
                }
            } else {
                this.getSsn().set(this, this.convert(property), value);
            }
        }
        catch (ProtoException pe) {
            throw PersistenceException.newInstance(pe);
        }
    }

    public boolean isNew() {
        this.validate();
        if (this.isDisconnected()) {
            return false;
        }
        return !this.m_oid.isInitialized() || this.getSsn().isNew(this) && !this.getSsn().isPersisted(this);
    }

    public boolean isDeleted() {
        this.validate();
        if (this.isDisconnected()) {
            return false;
        }
        return this.getSsn().isDeleted(this);
    }

    public boolean isCommitted() {
        this.validate();
        if (this.isDisconnected()) {
            return false;
        }
        return this.m_oid.isInitialized() && !this.getSsn().isNew(this);
    }

    public boolean isDisconnected() {
        return this.m_manualDisconnect || this.m_transactionDone || !this.isValid();
    }

    void invalidate(boolean connectedOnly, boolean error) {
        if (!this.isValid()) {
            return;
        }
        if (error || !connectedOnly && this.m_ssn.isModified(this)) {
            this.m_valid = false;
            if (s_log.isDebugEnabled()) {
                this.m_invalidStack = new Throwable();
            }
        } else if (connectedOnly && this.m_manualDisconnect) {
            this.doDisconnect();
        }
        this.m_transactionDone = true;
    }

    public void disconnect() {
        if (!this.m_oid.isInitialized()) {
            throw new PersistenceException("can't disconnect uninitialized: " + this);
        }
        this.m_manualDisconnect = true;
        this.m_ssn.releaseObject(this);
    }

    public boolean isModified() {
        this.validate();
        if (this.isDisconnected()) {
            return false;
        }
        return !this.getSsn().isFlushed(this);
    }

    public boolean isPropertyModified(String name) {
        this.validate();
        if (this.isDisconnected()) {
            return false;
        }
        return !this.getSsn().isFlushed(this, this.convert(name));
    }

    public boolean isValid() {
        return this.m_valid;
    }

    private void validate() {
        if (!this.isValid()) {
            if (s_log.isDebugEnabled()) {
                s_log.debug((Object)"invalid data object invalidated at: ", this.m_invalidStack);
            }
            throw new PersistenceException("invalid data object: " + this);
        }
    }

    private void validateWrite() {
        this.validate();
        if (this.isDisconnected()) {
            throw new PersistenceException("can not write to disconnected data object: " + this);
        }
    }

    public void delete() {
        this.validateWrite();
        try {
            this.getSsn().delete(this);
            this.getSsn().flush();
            this.getSsn().assertFlushed(this);
        }
        catch (ProtoException pe) {
            throw PersistenceException.newInstance(pe);
        }
    }

    public void specialize(String subtypeName) {
        this.validate();
        ObjectType subtype = this.getSession().getMetadataRoot().getObjectType(subtypeName);
        if (subtype == null) {
            throw new PersistenceException("No such type: " + subtypeName);
        }
        this.specialize(subtype);
    }

    public void specialize(ObjectType subtype) {
        this.p_pMap = null;
        this.p_objectType = null;
        this.validate();
        this.m_oid.specialize(subtype);
    }

    public void save() {
        this.validateWrite();
        try {
            if (this.getSsn().isDeleted(this)) {
                throw new PersistenceException("can't save a deleted object");
            }
            this.getSession().m_beforeFP.fireNow(new BeforeSaveEvent(this));
            if (!this.getSsn().isFlushed(this)) {
                this.getSsn().flush();
                this.assertFlushed();
            } else {
                this.getSession().m_afterFP.fireNow(new AfterSaveEvent(this));
            }
        }
        catch (ProtoException pe) {
            throw PersistenceException.newInstance(pe);
        }
    }

    private void assertFlushed() {
        Iterator it = this.getObjectType().getProperties();
        while (it.hasNext()) {
            Property p = (Property)it.next();
            if (this.getSsn().isFlushed(this, C.prop(this.m_ssn.getRoot(), p))) continue;
            this.getSsn().assertFlushed(this);
        }
    }

    public void addObserver(DataObserver observer) {
        this.validate();
        if (observer == null) {
            throw new IllegalArgumentException("Can't add a null observer.");
        }
        ObserverEntry entry = new ObserverEntry(observer);
        if (!this.m_observers.contains(entry)) {
            if (this.m_firing != null) {
                throw new IllegalStateException("Can't add a new observer from within another observer.\nTrying to add: " + observer + "\n" + "Currently firing: " + this.m_firing + "\n" + "Current observers: " + this.m_observers);
            }
            this.m_observers.add(entry);
        }
    }

    void scheduleObserver(DataEvent event) {
        Iterator it = this.m_observers.iterator();
        while (it.hasNext()) {
            ObserverEntry entry = (ObserverEntry)it.next();
            DataObserver observer = entry.getObserver();
            if (!(event instanceof AfterEvent)) continue;
            entry.scheduleEvent(((AfterEvent)((Object)event)).getBefore(), event);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void fireObserver(DataEvent event) {
        for (int i = 0; i < this.m_observers.size(); ++i) {
            BeforeEvent be;
            ObserverEntry entry = (ObserverEntry)this.m_observers.get(i);
            DataObserver observer = entry.getObserver();
            if (entry.isFiring(event)) {
                if (!s_log.isDebugEnabled()) continue;
                s_log.debug((Object)("isFiring: " + event));
                continue;
            }
            if (event instanceof AfterEvent) {
                AfterEvent ae = (AfterEvent)((Object)event);
                if (entry.isFiring(ae.getBefore())) {
                    entry.scheduleEvent(ae.getBefore(), event);
                    continue;
                }
            } else if (event instanceof BeforeEvent && entry.isFiring((be = (BeforeEvent)((Object)event)).getAfter())) {
                entry.scheduleEvent(be.getAfter(), event);
                continue;
            }
            try {
                DataEvent waiting;
                if (event instanceof BeforeEvent && (waiting = entry.clearFiring(event)) != null) {
                    this.fireObserver(waiting);
                }
                entry.setFiring(event);
                event.invoke(observer);
                waiting = entry.clearFiring(event);
                if (waiting == null) continue;
                this.fireObserver(waiting);
                continue;
            }
            finally {
                entry.clearFiring(event);
            }
        }
    }

    private Object get(com.redhat.persistence.Session s, com.redhat.persistence.metadata.Property p) {
        try {
            return s.get((Object)this, p);
        }
        catch (ProtoException pe) {
            throw PersistenceException.newInstance(pe);
        }
    }

    public boolean equals(Object o) {
        if (o instanceof DataObject) {
            return this.m_oid.equals(((DataObject)o).getOID());
        }
        return false;
    }

    public int hashCode() {
        return this.m_oid.hashCode();
    }

    public String toString() {
        return this.m_oid.toString();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private final class ObserverEntry {
        private DataObserver m_observer;
        private Set m_firing = new HashSet();
        private Map m_waiting = new HashMap();

        private ObserverEntry(DataObserver observer) {
            this.m_observer = observer;
        }

        public DataObserver getObserver() {
            return this.m_observer;
        }

        public boolean isFiring(DataEvent event) {
            return this.m_firing.contains(event);
        }

        public boolean isWaiting(DataEvent event) {
            return this.m_waiting.containsValue(event);
        }

        public void setFiring(DataEvent event) {
            if (this.isWaiting(event)) {
                Iterator it = this.m_waiting.entrySet().iterator();
                while (it.hasNext()) {
                    Map.Entry me = it.next();
                    DataEvent value = (DataEvent)me.getValue();
                    if (!value.equals(event)) continue;
                    this.m_waiting.remove(me.getKey());
                    break;
                }
            }
            this.m_firing.add(event);
            DataObjectImpl.this.m_firing = this;
        }

        public void scheduleEvent(DataEvent now, DataEvent waiting) {
            if (!this.isFiring(waiting)) {
                this.m_waiting.put(now, waiting);
            }
        }

        public DataEvent clearFiring(DataEvent event) {
            this.m_firing.remove(event);
            DataObjectImpl.this.m_firing = null;
            return (DataEvent)this.m_waiting.remove(event);
        }

        public int hashCode() {
            return this.m_observer.hashCode();
        }

        public boolean equals(Object other) {
            if (other instanceof ObserverEntry && other != null) {
                return this.m_observer.equals(((ObserverEntry)other).m_observer);
            }
            return super.equals(other);
        }

        public String toString() {
            return "Observer: " + this.m_observer;
        }
    }
}

