/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.persistence;

import com.arsdigita.persistence.DataQueryImpl;
import com.arsdigita.persistence.FilterImpl;
import com.arsdigita.persistence.Utilities;
import com.redhat.persistence.common.Path;
import com.redhat.persistence.oql.Condition;
import com.redhat.persistence.oql.Equals;
import com.redhat.persistence.oql.Expression;
import com.redhat.persistence.oql.Literal;
import com.redhat.persistence.oql.Not;
import com.redhat.persistence.oql.Static;
import java.util.Map;

class EqualsFilter
extends FilterImpl {
    public static final String versionId = "$Id: //core-platform/dev/src/com/arsdigita/persistence/EqualsFilter.java#4 $ by $Author: dennis $, $DateTime: 2004/04/07 16:07:11 $";
    private final String m_attribute;
    private final String m_bindName;
    private final boolean m_not;

    static FilterImpl eq(String attribute, Object value) {
        return new EqualsFilter(attribute, value, false);
    }

    static FilterImpl notEq(String attribute, Object value) {
        return new EqualsFilter(attribute, value, true);
    }

    private EqualsFilter(String attribute, Object value, boolean not) {
        this.m_attribute = attribute;
        this.m_not = not;
        String string = this.m_bindName = value == null ? null : FilterImpl.bindName(this.m_attribute);
        if (this.m_bindName != null) {
            this.set(this.m_bindName, value);
        }
    }

    private boolean isValueNull() {
        return this.m_bindName == null;
    }

    protected Expression makeExpression(DataQueryImpl query, Map bindings) {
        Expression variable;
        Path path = Path.get(this.m_attribute);
        if (query.hasProperty(path = query.unalias(path))) {
            path = query.mapAndAddPath(path);
            variable = Expression.valueOf(path);
        } else {
            String expr = query.unalias(this.m_attribute);
            expr = query.mapAndAddPaths(expr);
            variable = new Static(expr);
        }
        Literal value = this.isValueNull() ? new Literal(null) : new Literal(this.getBindings().get(this.m_bindName));
        Condition expr = new Equals(variable, value);
        if (this.m_not) {
            expr = new Not(expr);
        }
        return expr;
    }

    public String getConditions() {
        String connector = this.m_not ? "!=" : "=";
        String conditions = this.isValueNull() ? FilterImpl.createNullString(connector, this.m_attribute) : this.m_attribute + connector + " :" + this.m_bindName;
        return conditions;
    }

    public String toString() {
        return "Equals Filter: " + this.m_attribute + " = " + this.m_bindName + Utilities.LINE_BREAK + "  Values: " + this.getBindings();
    }
}

