/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.persistence;

import com.arsdigita.db.DbHelper;
import com.arsdigita.developersupport.DeveloperSupportProfiler;
import com.arsdigita.persistence.AddEvent;
import com.arsdigita.persistence.AfterDeleteEvent;
import com.arsdigita.persistence.AfterSaveEvent;
import com.arsdigita.persistence.BeforeDeleteEvent;
import com.arsdigita.persistence.BeforeSaveEvent;
import com.arsdigita.persistence.C;
import com.arsdigita.persistence.ConnectionSource;
import com.arsdigita.persistence.DataCollection;
import com.arsdigita.persistence.DataCollectionImpl;
import com.arsdigita.persistence.DataEvent;
import com.arsdigita.persistence.DataObject;
import com.arsdigita.persistence.DataObjectImpl;
import com.arsdigita.persistence.DataOperation;
import com.arsdigita.persistence.DataQuery;
import com.arsdigita.persistence.DataQueryImpl;
import com.arsdigita.persistence.OID;
import com.arsdigita.persistence.ObjectDataEvent;
import com.arsdigita.persistence.PersistenceException;
import com.arsdigita.persistence.RemoveEvent;
import com.arsdigita.persistence.SetEvent;
import com.arsdigita.persistence.TransactionContext;
import com.arsdigita.persistence.metadata.MetadataRoot;
import com.arsdigita.persistence.metadata.ObjectType;
import com.redhat.persistence.CreateEvent;
import com.redhat.persistence.DeleteEvent;
import com.redhat.persistence.Engine;
import com.redhat.persistence.Event;
import com.redhat.persistence.EventProcessor;
import com.redhat.persistence.PropertyEvent;
import com.redhat.persistence.PropertyMap;
import com.redhat.persistence.ProtoException;
import com.redhat.persistence.QuerySource;
import com.redhat.persistence.common.Path;
import com.redhat.persistence.engine.rdbms.OracleWriter;
import com.redhat.persistence.engine.rdbms.PostgresWriter;
import com.redhat.persistence.engine.rdbms.RDBMSEngine;
import com.redhat.persistence.metadata.Adapter;
import com.redhat.persistence.metadata.Property;
import com.redhat.persistence.metadata.Root;
import com.redhat.persistence.profiler.rdbms.CompoundProfiler;
import com.redhat.persistence.profiler.rdbms.StatementProfiler;
import java.lang.ref.WeakReference;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class Session {
    private static final Logger LOG = Logger.getLogger((Class)(class$com$arsdigita$persistence$Session == null ? (class$com$arsdigita$persistence$Session = Session.class$("com.arsdigita.persistence.Session")) : class$com$arsdigita$persistence$Session));
    private MetadataRoot m_root;
    private ConnectionSource m_source;
    private int m_database;
    private TransactionContext m_ctx;
    private PSession m_ssn;
    private final RDBMSEngine m_engine;
    private final QuerySource m_qs;
    private List m_dataObjects = new ArrayList();
    FlushEventProcessor m_beforeFP;
    FlushEventProcessor m_afterFP;
    private final StatementProfiler m_prof = new StatementProfiler();
    static /* synthetic */ Class class$com$arsdigita$persistence$Session;
    static /* synthetic */ Class class$com$arsdigita$persistence$DataObjectImpl;
    static /* synthetic */ Class class$com$redhat$persistence$PropertyMap;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Session(MetadataRoot root, ConnectionSource source, int database) {
        Root r;
        this.m_root = root;
        this.m_source = source;
        this.m_database = database;
        com.redhat.persistence.engine.rdbms.ConnectionSource src = new com.redhat.persistence.engine.rdbms.ConnectionSource(){

            public Connection acquire() {
                return Session.this.m_source.acquire();
            }

            public void release(Connection conn) {
                Session.this.m_source.release(conn);
            }
        };
        CompoundProfiler profs = new CompoundProfiler();
        profs.add(this.m_prof);
        profs.add(new DeveloperSupportProfiler());
        switch (this.m_database) {
            case 1: {
                this.m_engine = new RDBMSEngine(src, new OracleWriter(), profs);
                break;
            }
            case 2: {
                this.m_engine = new RDBMSEngine(src, new PostgresWriter(), profs);
                break;
            }
            default: {
                DbHelper.unsupportedDatabaseError("persistence");
                this.m_engine = null;
            }
        }
        this.m_qs = new QuerySource();
        this.m_ssn = new PSession(this.m_root.getRoot(), this.m_engine, this.m_qs);
        this.m_ctx = new TransactionContext(this);
        this.m_ssn.addAfterActivate(new AfterActivate());
        this.m_beforeFP = new FlushEventProcessor(true);
        this.m_afterFP = new FlushEventProcessor(false);
        this.m_ssn.addBeforeFlush(this.m_beforeFP);
        this.m_ssn.addAfterFlush(this.m_afterFP);
        this.m_ssn.addBeforeDelete(new EventProcessor(){

            protected void cleanUp(boolean isCommit) {
            }

            protected void flush() {
            }

            protected void write(Event ev) {
                if (ev instanceof DeleteEvent) {
                    BeforeDeleteEvent bde = new BeforeDeleteEvent((DataObjectImpl)ev.getObject());
                    bde.fire();
                }
            }
        });
        Root root2 = r = this.m_root.getRoot();
        synchronized (root2) {
            Adapter ad = r.getAdapter(class$com$arsdigita$persistence$DataObjectImpl == null ? (class$com$arsdigita$persistence$DataObjectImpl = Session.class$("com.arsdigita.persistence.DataObjectImpl")) : class$com$arsdigita$persistence$DataObjectImpl);
            if (ad == null || !(ad instanceof DataObjectAdapter)) {
                ad = new DataObjectAdapter();
                r.addAdapter(class$com$arsdigita$persistence$DataObjectImpl == null ? (class$com$arsdigita$persistence$DataObjectImpl = Session.class$("com.arsdigita.persistence.DataObjectImpl")) : class$com$arsdigita$persistence$DataObjectImpl, ad);
                r.addAdapter(class$com$redhat$persistence$PropertyMap == null ? (class$com$redhat$persistence$PropertyMap = Session.class$("com.redhat.persistence.PropertyMap")) : class$com$redhat$persistence$PropertyMap, ad);
                r.addAdapter(null, ad);
            }
        }
    }

    public MetadataRoot getMetadataRoot() {
        return this.m_root;
    }

    public void startProfiling() {
        this.m_prof.start();
    }

    public void stopProfiling() {
        this.m_prof.stop();
    }

    Root getRoot() {
        return this.m_ssn.getRoot();
    }

    public int getDatabase() {
        return this.m_database;
    }

    com.redhat.persistence.Session getProtoSession() {
        return this.m_ssn;
    }

    RDBMSEngine getEngine() {
        return this.m_engine;
    }

    public TransactionContext getTransactionContext() {
        return this.m_ctx;
    }

    public Connection getConnection() {
        return this.m_engine.getConnection();
    }

    public DataObject create(ObjectType type) {
        if (type == null) {
            throw new IllegalArgumentException("type must be non null");
        }
        DataObjectImpl result = new DataObjectImpl(type);
        result.setSession(this.m_ssn);
        return result;
    }

    public DataObject create(String typeName) {
        ObjectType type = this.m_root.getObjectType(typeName);
        if (type == null) {
            throw new PersistenceException("no such type: " + typeName);
        }
        return this.create(type);
    }

    public DataObject create(OID oid) {
        DataObjectImpl result = new DataObjectImpl(oid);
        try {
            this.m_ssn.create(result);
        }
        catch (ProtoException e) {
            throw PersistenceException.newInstance(e);
        }
        return result;
    }

    public DataObject retrieve(OID oid) {
        return (DataObject)this.m_ssn.retrieve(C.pmap(this.getRoot(), oid));
    }

    public boolean delete(OID oid) {
        DataObject dobj = this.retrieve(oid);
        boolean result = this.m_ssn.delete(dobj);
        this.m_ssn.flush();
        this.m_ssn.assertFlushed(dobj);
        return result;
    }

    public DataCollection retrieve(ObjectType type) {
        return new DataCollectionImpl(this, this.m_ssn.getDataSet(this.getRoot().getObjectType(type.getQualifiedName())));
    }

    public DataCollection retrieve(String typeName) {
        ObjectType ot = this.m_root.getObjectType(typeName);
        if (ot == null) {
            throw new PersistenceException("no such type: " + typeName);
        }
        return this.retrieve(ot);
    }

    public DataQuery retrieveQuery(String name) {
        com.redhat.persistence.metadata.ObjectType ot = this.getRoot().getObjectType(name);
        if (ot == null) {
            throw new PersistenceException("no such query: " + name);
        }
        return new DataQueryImpl(this, this.m_ssn.getDataSet(ot));
    }

    public DataOperation retrieveDataOperation(String name) {
        com.redhat.persistence.metadata.DataOperation op = this.getRoot().getDataOperation(Path.get(name));
        if (op == null) {
            throw new PersistenceException("no such data operation: " + name);
        }
        return new DataOperation(this, op.getSQL());
    }

    public void flushAll() {
        try {
            this.getProtoSession().flushAll();
        }
        catch (ProtoException pe) {
            throw PersistenceException.newInstance(pe);
        }
    }

    private void addDataObject(DataObject obj) {
        this.m_dataObjects.add(new WeakReference<DataObject>(obj));
    }

    void invalidateDataObjects(boolean connectedOnly, boolean error) {
        Iterator it = this.m_dataObjects.iterator();
        while (it.hasNext()) {
            WeakReference ref = (WeakReference)it.next();
            DataObjectImpl obj = (DataObjectImpl)ref.get();
            if (obj == null) continue;
            obj.invalidate(connectedOnly, error);
        }
        this.m_dataObjects.clear();
    }

    static Session getSessionFromProto(com.redhat.persistence.Session ssn) {
        try {
            return ((PSession)ssn).getOldSession();
        }
        catch (ClassCastException cce) {
            return null;
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class PSession
    extends com.redhat.persistence.Session {
        PSession(Root root, Engine engine, QuerySource source) {
            super(root, engine, source);
        }

        private Session getOldSession() {
            return Session.this;
        }
    }

    private static class DataObjectAdapter
    extends Adapter {
        private DataObjectAdapter() {
        }

        public void setSession(Object obj, com.redhat.persistence.Session ssn) {
            DataObjectImpl dobj = (DataObjectImpl)obj;
            dobj.setSession(ssn);
            Session.getSessionFromProto(ssn).addDataObject(dobj);
        }

        public Object getObject(com.redhat.persistence.metadata.ObjectType type, PropertyMap props) {
            Property p;
            if (!type.isKeyed()) {
                return props;
            }
            com.redhat.persistence.metadata.ObjectType sp = type;
            if (type.hasProperty("objectType") && (p = type.getProperty("objectType")).getType().getQualifiedName().equals("global.String")) {
                String qname = (String)props.get(p);
                Root root = type.getRoot();
                if (qname != null && root.hasObjectType(qname)) {
                    sp = root.getObjectType(qname);
                }
            }
            MetadataRoot old = MetadataRoot.getMetadataRoot(sp.getRoot());
            OID oid = new OID(old.getObjectType(sp.getQualifiedName()));
            Iterator it = sp.getKeyProperties().iterator();
            while (it.hasNext()) {
                Property prop = (Property)it.next();
                oid.set(prop.getName(), props.get(prop));
            }
            return new DataObjectImpl(oid);
        }

        public PropertyMap getProperties(Object obj) {
            if (obj instanceof PropertyMap) {
                return (PropertyMap)obj;
            }
            DataObjectImpl dobj = (DataObjectImpl)obj;
            if (dobj.p_pMap == null) {
                PropertyMap pMap = new PropertyMap(this.getObjectType(obj));
                Iterator it = dobj.getOID().getProperties().entrySet().iterator();
                while (it.hasNext()) {
                    Map.Entry me = it.next();
                    pMap.put(this.getObjectType(obj).getProperty((String)me.getKey()), me.getValue());
                }
                dobj.p_pMap = pMap;
            }
            return dobj.p_pMap;
        }

        public com.redhat.persistence.metadata.ObjectType getObjectType(Object obj) {
            if (obj instanceof PropertyMap) {
                return ((PropertyMap)obj).getObjectType();
            }
            DataObjectImpl dobj = (DataObjectImpl)obj;
            if (dobj.p_objectType == null) {
                dobj.p_objectType = C.type(this.getRoot(), dobj.getObjectType());
            }
            return dobj.p_objectType;
        }
    }

    static class FlushEventProcessor
    extends EventProcessor {
        private final boolean m_before;
        private List m_events = new ArrayList();
        private List m_toFire = new LinkedList();

        FlushEventProcessor(boolean before) {
            this.m_before = before;
        }

        protected void cleanUp(boolean isCommit) {
            if (isCommit && this.m_events.size() > 0) {
                LOG.error((Object)("unfired data events: " + this.m_events));
                throw new IllegalStateException("unfired data events: " + this.m_events);
            }
            this.m_events.clear();
            if (isCommit && this.m_toFire.size() > 0) {
                LOG.error((Object)("unfired data events: " + this.m_toFire));
                throw new IllegalStateException("unfired data events: " + this.m_toFire);
            }
            this.m_toFire.clear();
        }

        protected void write(Event e) {
            if (e.getObject() instanceof DataObjectImpl) {
                if (e instanceof PropertyEvent && ((PropertyEvent)e).getProperty().getName().charAt(0) == '~') {
                    return;
                }
                this.m_events.add(e);
            }
        }

        protected void flush() {
            Object e;
            HashSet<DataObjectImpl> objs = new HashSet<DataObjectImpl>();
            LinkedList<BeforeDeleteEvent> events = new LinkedList<BeforeDeleteEvent>();
            for (int i = this.m_events.size() - 1; i >= 0; --i) {
                e = (Event)this.m_events.get(i);
                DataObjectImpl obj = (DataObjectImpl)((Event)e).getObject();
                if (objs.contains(obj)) continue;
                objs.add(obj);
                ObjectDataEvent toFire = e instanceof DeleteEvent ? (this.m_before ? new BeforeDeleteEvent(obj) : new AfterDeleteEvent(obj)) : (this.m_before ? new BeforeSaveEvent(obj) : new AfterSaveEvent(obj));
                events.add(0, (BeforeDeleteEvent)toFire);
            }
            this.m_events.clear();
            if (LOG.isDebugEnabled() && events.size() > 0) {
                LOG.debug((Object)((this.m_before ? "before flush:" : "after flush: ") + events));
            }
            this.m_toFire.addAll(events);
            Iterator it = events.iterator();
            while (it.hasNext()) {
                e = (DataEvent)it.next();
                if (e instanceof BeforeDeleteEvent) continue;
                ((DataEvent)e).schedule();
            }
            it = events.iterator();
            while (it.hasNext()) {
                e = (DataEvent)it.next();
                if (!this.m_toFire.remove(e) || e instanceof BeforeDeleteEvent) continue;
                ((DataEvent)e).fire();
            }
        }

        void fireNow(DataEvent e) {
            this.m_toFire.remove(e);
            e.fire();
        }
    }

    private static class AfterActivate
    extends EventProcessor {
        private AfterActivate() {
        }

        protected void write(Event ev) {
            if (!(ev.getObject() instanceof DataObjectImpl)) {
                return;
            }
            if (ev instanceof PropertyEvent) {
                PropertyEvent pe = (PropertyEvent)ev;
                if (pe.getProperty().getName().charAt(0) == '~') {
                    return;
                }
                DataObjectImpl doi = (DataObjectImpl)ev.getObject();
                if (doi.isDeleted()) {
                    return;
                }
            }
            ev.dispatch(new Event.Switch(this){
                private final /* synthetic */ AfterActivate this$0;
                {
                    this.this$0 = this$0;
                }

                public void onCreate(CreateEvent e) {
                }

                public void onDelete(DeleteEvent e) {
                }

                public void onSet(com.redhat.persistence.SetEvent e) {
                    new SetEvent((DataObjectImpl)e.getObject(), e.getProperty().getName(), e.getPreviousValue(), e.getArgument()).fire();
                }

                public void onAdd(com.redhat.persistence.AddEvent e) {
                    new AddEvent((DataObjectImpl)e.getObject(), e.getProperty().getName(), (DataObjectImpl)e.getArgument()).fire();
                }

                public void onRemove(com.redhat.persistence.RemoveEvent e) {
                    new RemoveEvent((DataObjectImpl)e.getObject(), e.getProperty().getName(), (DataObjectImpl)e.getArgument()).fire();
                }
            });
        }

        protected void flush() {
        }

        protected void cleanUp(boolean isCommit) {
        }
    }
}

