/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.persistence.pdl;

import com.arsdigita.persistence.pdl.PDLCompiler;
import com.arsdigita.persistence.pdl.PDLFilter;
import com.arsdigita.persistence.pdl.PDLSource;
import com.arsdigita.util.UncheckedWrapperException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.util.ArrayList;
import java.util.Iterator;

public class ManifestSource
implements PDLSource {
    public static final String versionId = "$Id: //core-platform/dev/src/com/arsdigita/persistence/pdl/ManifestSource.java#6 $ by $Author: dennis $, $DateTime: 2004/04/07 16:07:11 $";
    private final String m_manifest;
    private final PDLFilter m_filter;
    private final ClassLoader m_loader;

    public ManifestSource(String manifest, PDLFilter filter, ClassLoader loader) {
        this.m_manifest = manifest;
        this.m_filter = filter;
        this.m_loader = loader;
    }

    public ManifestSource(String manifest, PDLFilter filter) {
        this(manifest, filter, Thread.currentThread().getContextClassLoader());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void parse(PDLCompiler compiler) {
        InputStream is = this.m_loader.getResourceAsStream(this.m_manifest);
        if (is == null) {
            throw new IllegalStateException("no such resource: " + this.m_manifest);
        }
        try {
            String line;
            LineNumberReader lines = new LineNumberReader(new InputStreamReader(is));
            ArrayList<String> names = new ArrayList<String>();
            while ((line = lines.readLine()) != null) {
                line = line.trim();
                names.add(line);
            }
            Iterator accepted = this.m_filter.accept(names).iterator();
            while (accepted.hasNext()) {
                String line2 = (String)accepted.next();
                InputStream pdl = this.m_loader.getResourceAsStream(line2);
                if (pdl == null) {
                    throw new IllegalStateException(this.m_manifest + ": " + lines.getLineNumber() + ": no such resource '" + line2 + "'");
                }
                try {
                    compiler.parse(new InputStreamReader(pdl), line2);
                }
                finally {
                    pdl.close();
                }
            }
        }
        catch (IOException e) {
            throw new UncheckedWrapperException(e);
        }
        finally {
            try {
                is.close();
            }
            catch (IOException e) {
                throw new UncheckedWrapperException(e);
            }
        }
    }
}

