/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.portal;

import com.arsdigita.domain.DataObjectNotFoundException;
import com.arsdigita.domain.DomainObjectFactory;
import com.arsdigita.kernel.Resource;
import com.arsdigita.persistence.DataAssociation;
import com.arsdigita.persistence.DataAssociationCursor;
import com.arsdigita.persistence.DataCollection;
import com.arsdigita.persistence.DataObject;
import com.arsdigita.persistence.OID;
import com.arsdigita.persistence.PersistenceException;
import com.arsdigita.persistence.SessionManager;
import com.arsdigita.portal.PortalCollection;
import com.arsdigita.portal.Portlet;
import com.arsdigita.portal.PortletCollection;
import com.arsdigita.util.Assert;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class Portal
extends Resource {
    public static final String versionId = "$Id: //core-platform/dev/src/com/arsdigita/portal/Portal.java#20 $ by $Author: dennis $, $DateTime: 2004/04/07 16:07:11 $";
    public static final String BASE_DATA_OBJECT_TYPE = "com.arsdigita.portal.Portal";
    private static final Logger s_log = Logger.getLogger((Class)(class$com$arsdigita$portal$Portal == null ? (class$com$arsdigita$portal$Portal = Portal.class$("com.arsdigita.portal.Portal")) : class$com$arsdigita$portal$Portal));
    private Map m_cellPortletListMap = new HashMap();
    static /* synthetic */ Class class$com$arsdigita$portal$Portal;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$math$BigDecimal;
    static /* synthetic */ Class class$com$arsdigita$persistence$OID;
    static /* synthetic */ Class class$com$arsdigita$persistence$DataObject;
    static /* synthetic */ Class class$java$lang$Boolean;
    static /* synthetic */ Class class$com$arsdigita$portal$Portlet;

    protected String getBaseDataObjectType() {
        return BASE_DATA_OBJECT_TYPE;
    }

    protected Portal(DataObject dataObject) {
        super(dataObject);
    }

    protected Portal(String dataObjectType) {
        super(dataObjectType);
    }

    public Portal(OID oid) throws DataObjectNotFoundException {
        super(oid);
    }

    public static Portal createTemplate(String title) {
        Assert.exists(title, class$java$lang$String == null ? (class$java$lang$String = Portal.class$("java.lang.String")) : class$java$lang$String);
        Portal portal = new Portal(BASE_DATA_OBJECT_TYPE);
        portal.setTitle(title);
        portal.setTemplate(true);
        return portal;
    }

    public static Portal create(String title, Resource parent) {
        Assert.exists(title, class$java$lang$String == null ? (class$java$lang$String = Portal.class$("java.lang.String")) : class$java$lang$String);
        Portal portal = (Portal)Resource.createResource(BASE_DATA_OBJECT_TYPE, title, parent);
        portal.setTemplate(false);
        return portal;
    }

    public static Portal create(String dataobj, String title, Resource parent) {
        Assert.exists(title, class$java$lang$String == null ? (class$java$lang$String = Portal.class$("java.lang.String")) : class$java$lang$String);
        Portal portal = (Portal)Resource.createResource(dataobj, title, parent);
        portal.setTemplate(false);
        return portal;
    }

    public static Portal retrieve(BigDecimal portalID) {
        Assert.exists(portalID, class$java$math$BigDecimal == null ? (class$java$math$BigDecimal = Portal.class$("java.math.BigDecimal")) : class$java$math$BigDecimal);
        return Portal.retrieve(new OID(BASE_DATA_OBJECT_TYPE, (Object)portalID));
    }

    public static Portal retrieve(OID oid) {
        Assert.exists(oid, class$com$arsdigita$persistence$OID == null ? (class$com$arsdigita$persistence$OID = Portal.class$("com.arsdigita.persistence.OID")) : class$com$arsdigita$persistence$OID);
        DataObject dataObject = SessionManager.getSession().retrieve(oid);
        return Portal.retrieve(dataObject);
    }

    public static Portal retrieve(DataObject dataObject) {
        Assert.exists(dataObject, class$com$arsdigita$persistence$DataObject == null ? (class$com$arsdigita$persistence$DataObject = Portal.class$("com.arsdigita.persistence.DataObject")) : class$com$arsdigita$persistence$DataObject);
        return new Portal(dataObject);
    }

    public static PortalCollection retrieveAll() {
        DataCollection dataCollection = SessionManager.getSession().retrieve(BASE_DATA_OBJECT_TYPE);
        PortalCollection portalCollection = new PortalCollection(dataCollection);
        return portalCollection;
    }

    public void clearPortlets() {
        DataAssociationCursor dac = this.getPortletsAssociation().cursor();
        while (dac.next()) {
            DomainObjectFactory.newInstance(dac.getDataObject()).delete();
        }
    }

    public String getTitle() {
        String title = (String)this.get("title");
        Assert.exists(title, class$java$lang$String == null ? (class$java$lang$String = Portal.class$("java.lang.String")) : class$java$lang$String);
        return title;
    }

    public void setTitle(String title) {
        Assert.exists(title, class$java$lang$String == null ? (class$java$lang$String = Portal.class$("java.lang.String")) : class$java$lang$String);
        this.set("title", title);
    }

    public boolean isTemplate() {
        Boolean isTemplate = (Boolean)this.get("isTemplate");
        Assert.exists(isTemplate, class$java$lang$Boolean == null ? (class$java$lang$Boolean = Portal.class$("java.lang.Boolean")) : class$java$lang$Boolean);
        return isTemplate;
    }

    protected void setTemplate(boolean isTemplate) {
        this.set("isTemplate", new Boolean(isTemplate));
    }

    private synchronized LinkedList getPortletListForCell(int cellNumber) {
        Integer cellNumberInteger = new Integer(cellNumber);
        if (this.m_cellPortletListMap.get(cellNumberInteger) == null) {
            LinkedList<Portlet> portletList = new LinkedList<Portlet>();
            PortletCollection portlets = this.getPortletsForCell(cellNumber);
            while (portlets.next()) {
                portletList.add(portlets.getPortlet());
            }
            this.m_cellPortletListMap.put(cellNumberInteger, portletList);
        }
        return (LinkedList)this.m_cellPortletListMap.get(cellNumberInteger);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPortlet(Portlet portlet, int cellNumber) {
        LinkedList portletList;
        Assert.exists(portlet, class$com$arsdigita$portal$Portlet == null ? (class$com$arsdigita$portal$Portlet = Portal.class$("com.arsdigita.portal.Portlet")) : class$com$arsdigita$portal$Portlet);
        Assert.truth(cellNumber >= 1, "cellNumber >= 1");
        LinkedList linkedList = portletList = this.getPortletListForCell(cellNumber);
        synchronized (linkedList) {
            portletList.add(portlet);
        }
        portlet.setCellNumber(cellNumber);
        portlet.setPortal(this);
    }

    public PortletCollection getPortlets() {
        DataAssociation portlets = this.getPortletsAssociation();
        DataAssociationCursor portletsCursor = portlets.getDataAssociationCursor();
        portletsCursor.addOrder("cellNumber");
        portletsCursor.addOrder("sortKey");
        return new PortletCollection(portletsCursor);
    }

    public PortletCollection getPortletsForCell(int cellNumber) {
        DataAssociation portlets = this.getPortletsAssociation();
        DataAssociationCursor portletsCursor = portlets.getDataAssociationCursor();
        portletsCursor.addEqualsFilter("cellNumber", new Integer(cellNumber));
        portletsCursor.addOrder("sortKey");
        return new PortletCollection(portletsCursor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void swapPortletWithPrevious(Portlet portlet) throws PersistenceException {
        LinkedList portletList = this.getPortletListForCell(portlet.getCellNumber());
        int currentIndex = portletList.indexOf(portlet);
        Assert.truth(currentIndex != -1, "Portlet not found.");
        try {
            LinkedList linkedList = portletList;
            synchronized (linkedList) {
                portletList.remove(currentIndex);
                portletList.add(currentIndex - 1, portlet);
            }
        }
        catch (IndexOutOfBoundsException e) {
            portletList.add(currentIndex, portlet);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void swapPortletWithNext(Portlet portlet) throws PersistenceException {
        LinkedList portletList = this.getPortletListForCell(portlet.getCellNumber());
        int currentIndex = portletList.indexOf(portlet);
        Assert.truth(currentIndex != -1, "Portlet not found.");
        try {
            LinkedList linkedList = portletList;
            synchronized (linkedList) {
                portletList.remove(currentIndex);
                portletList.add(currentIndex + 1, portlet);
            }
        }
        catch (IndexOutOfBoundsException e) {
            portletList.add(currentIndex, portlet);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void movePortletToHead(Portlet portlet) throws PersistenceException {
        LinkedList portletList = this.getPortletListForCell(portlet.getCellNumber());
        int currentIndex = portletList.indexOf(portlet);
        Assert.truth(currentIndex != -1, "Portlet not found.");
        LinkedList linkedList = portletList;
        synchronized (linkedList) {
            portletList.remove(currentIndex);
            portletList.addFirst(portlet);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void movePortletToTail(Portlet portlet) throws PersistenceException {
        LinkedList portletList = this.getPortletListForCell(portlet.getCellNumber());
        int currentIndex = portletList.indexOf(portlet);
        Assert.truth(currentIndex != -1, "Portlet not found.");
        LinkedList linkedList = portletList;
        synchronized (linkedList) {
            portletList.remove(currentIndex);
            portletList.addLast(portlet);
        }
    }

    protected void beforeSave() {
        if (s_log.isDebugEnabled()) {
            s_log.debug((Object)("In before save on portal " + this));
        }
        Iterator mapIter = this.m_cellPortletListMap.entrySet().iterator();
        while (mapIter.hasNext()) {
            Map.Entry entry = mapIter.next();
            List portletList = (List)entry.getValue();
            Iterator listIter = portletList.iterator();
            int sortKey = 0;
            while (listIter.hasNext()) {
                Portlet portlet = (Portlet)listIter.next();
                portlet.setSortKey(sortKey);
                ++sortKey;
            }
        }
        super.beforeSave();
        if (s_log.isDebugEnabled()) {
            s_log.debug((Object)("Done before save on portal " + this));
        }
    }

    private DataAssociation getPortletsAssociation() {
        return (DataAssociation)this.get("portlet");
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

