/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.portal;

import com.arsdigita.domain.DataObjectNotFoundException;
import com.arsdigita.kernel.PackageType;
import com.arsdigita.kernel.ResourceType;
import com.arsdigita.persistence.DataCollection;
import com.arsdigita.persistence.DataObject;
import com.arsdigita.persistence.OID;
import com.arsdigita.persistence.SessionManager;
import com.arsdigita.portal.PortletTypeCollection;
import com.arsdigita.util.Assert;
import com.arsdigita.web.ApplicationType;
import java.math.BigDecimal;
import org.apache.log4j.Logger;

public class PortletType
extends ResourceType {
    private static final Logger s_cat = Logger.getLogger((String)(class$com$arsdigita$portal$PortletType == null ? (class$com$arsdigita$portal$PortletType = PortletType.class$("com.arsdigita.portal.PortletType")) : class$com$arsdigita$portal$PortletType).getName());
    public static final String BASE_DATA_OBJECT_TYPE = "com.arsdigita.portal.PortletType";
    public static final String WIDE_PROFILE = "wide";
    public static final String NARROW_PROFILE = "narrow";
    static /* synthetic */ Class class$com$arsdigita$portal$PortletType;

    protected String getBaseDataObjectType() {
        return BASE_DATA_OBJECT_TYPE;
    }

    protected PortletType(DataObject dataObject) {
        super(dataObject);
    }

    protected PortletType(String dataObjectType, String title, String profile, String portletObjectType) {
        super(dataObjectType);
        Assert.assertNotNull(title, "title");
        Assert.assertNotNull(profile, "profile");
        Assert.assertNotNull(portletObjectType, "portletObjectType");
        PackageType packageType = null;
        try {
            packageType = PackageType.findByKey("portal");
        }
        catch (DataObjectNotFoundException nfe) {
            String message = "The PackageType 'portal' is not installed.  It must be installed in order to create a new PortletType.";
            s_cat.error((Object)message);
            throw new IllegalStateException(message);
        }
        this.setTitle(title);
        this.setResourceObjectType(portletObjectType);
        this.setProfile(profile);
        this.setFullPageView(false);
        this.setEmbeddedView(true);
    }

    public static PortletType createPortletType(String title, String profile, String portletObjectType) {
        return new PortletType(BASE_DATA_OBJECT_TYPE, title, profile, portletObjectType);
    }

    public static PortletType retrievePortletType(BigDecimal id) {
        Assert.assertNotNull(id, "id");
        return PortletType.retrievePortletType(new OID(BASE_DATA_OBJECT_TYPE, (Object)id));
    }

    public static PortletType retrievePortletType(OID oid) {
        Assert.assertNotNull(oid, "oid");
        DataObject dataObject = SessionManager.getSession().retrieve(oid);
        Assert.assertNotNull(dataObject);
        return PortletType.retrievePortletType(dataObject);
    }

    public static PortletType retrievePortletType(DataObject dataObject) {
        Assert.assertNotNull(dataObject, "dataObject");
        return new PortletType(dataObject);
    }

    public static PortletType retrievePortletTypeForPortlet(String portletObjectType) {
        Assert.assertNotNull(portletObjectType, "portletObjectType");
        DataCollection collection = SessionManager.getSession().retrieve(BASE_DATA_OBJECT_TYPE);
        Assert.assertNotNull(collection, "collection");
        collection.addEqualsFilter("objectType", portletObjectType);
        PortletType portletType = null;
        if (collection.next()) {
            portletType = PortletType.retrievePortletType(collection.getDataObject());
        } else {
            s_cat.warn((Object)("No portlet type found that matches \"" + portletObjectType + ".\"  Check that the portlet " + "type is registered in the system."));
        }
        collection.close();
        return portletType;
    }

    public static PortletTypeCollection retrieveAllPortletTypes() {
        DataCollection collection = SessionManager.getSession().retrieve(BASE_DATA_OBJECT_TYPE);
        Assert.assertNotNull(collection, "collection");
        collection.addEqualsFilter("hasEmbeddedView", Boolean.TRUE);
        return new PortletTypeCollection(collection);
    }

    public void setProviderApplicationType(ApplicationType applicationType) {
        Assert.assertNotNull(applicationType, "applicationType");
        this.setAssociation("providerApplicationType", applicationType);
    }

    public void setProviderApplicationType(String applicationObjectType) {
        ApplicationType applicationType = ApplicationType.retrieveApplicationTypeForApplication(applicationObjectType);
        this.setProviderApplicationType(applicationType);
    }

    public ApplicationType getProviderApplicationType() {
        DataObject dobj = (DataObject)this.get("providerApplicationType");
        if (dobj == null) {
            return null;
        }
        return ApplicationType.retrieveApplicationType(dobj);
    }

    public boolean hasFullPageView() {
        Boolean hasFullPageView = (Boolean)this.get("hasFullPageView");
        Assert.assertNotNull(hasFullPageView, "hasFullPageView");
        return hasFullPageView;
    }

    protected void setFullPageView(boolean hasFullPageView) {
        this.set("hasFullPageView", new Boolean(hasFullPageView));
    }

    public boolean hasEmbeddedView() {
        Boolean hasEmbeddedView = (Boolean)this.get("hasEmbeddedView");
        Assert.assertNotNull(hasEmbeddedView, "hasEmbeddedView");
        return hasEmbeddedView;
    }

    protected void setEmbeddedView(boolean hasEmbeddedView) {
        this.set("hasEmbeddedView", new Boolean(hasEmbeddedView));
    }

    public String getProfile() {
        String profile = (String)this.get("profile");
        return profile;
    }

    protected void setProfile(String profile) {
        this.set("profile", profile);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

