/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.runtime;

import com.arsdigita.util.UncheckedWrapperException;
import com.arsdigita.util.parameter.ErrorList;
import com.arsdigita.util.parameter.Parameter;
import com.arsdigita.util.parameter.ParameterInfo;
import com.arsdigita.util.parameter.ParameterLoader;
import com.arsdigita.util.parameter.ParameterValue;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.util.Iterator;

public final class InteractiveParameterLoader
implements ParameterLoader {
    public static final String versionId = "$Id: //core-platform/dev/src/com/arsdigita/runtime/InteractiveParameterLoader.java#6 $ by $Author: dennis $, $DateTime: 2004/04/07 16:07:11 $";
    private final InputStream m_in;
    private final PrintStream m_out;
    private final BufferedReader m_lines;

    public InteractiveParameterLoader(InputStream in, PrintStream out) {
        this.m_in = in;
        this.m_out = out;
        this.m_lines = new BufferedReader(new InputStreamReader(this.m_in));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Lifted jumps to return sites
     */
    public final String read(Parameter param, ErrorList errors) {
        if (!param.isRequired()) {
            return null;
        }
        Object dephault = param.getDefaultValue();
        if (dephault != null) {
            return null;
        }
        this.m_out.println("Parameter: " + param.getName());
        ParameterInfo info = param.getInfo();
        if (info != null) {
            String str = info.getTitle();
            if (str != null) {
                this.m_out.println("Title: " + str);
            }
            if ((str = info.getPurpose()) != null) {
                this.m_out.println("Purpose: " + str);
            }
            if ((str = info.getExample()) != null) {
                this.m_out.println("Example: " + str);
            }
            if ((str = info.getFormat()) != null) {
                this.m_out.println("Format: " + str);
            }
        }
        while (true) {
            this.m_out.print("Value: ");
            this.m_out.flush();
            try {
                String line = this.m_lines.readLine();
                if (!line.equals("")) return line;
            }
            catch (IOException e) {
                throw new UncheckedWrapperException(e);
            }
        }
    }

    public ParameterValue load(Parameter param) {
        ParameterValue value = new ParameterValue();
        value.setObject(param.read(this, value.getErrors()));
        param.validate(value.getObject(), value.getErrors());
        ErrorList errs = value.getErrors();
        if (errs.isEmpty()) {
            return value;
        }
        Iterator it = errs.iterator();
        while (it.hasNext()) {
            this.m_out.println(it.next());
        }
        return null;
    }
}

