/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.search;

import com.arsdigita.search.FilterType;
import com.arsdigita.search.IndexerType;
import com.arsdigita.search.NoopQueryEngine;
import com.arsdigita.search.QueryEngine;
import com.arsdigita.util.Assert;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class QueryEngineRegistry {
    private static Map s_engines = new HashMap();
    private static final Logger s_log = Logger.getLogger((Class)(class$com$arsdigita$search$QueryEngineRegistry == null ? (class$com$arsdigita$search$QueryEngineRegistry = QueryEngineRegistry.class$("com.arsdigita.search.QueryEngineRegistry")) : class$com$arsdigita$search$QueryEngineRegistry));
    static /* synthetic */ Class class$com$arsdigita$search$QueryEngineRegistry;
    static /* synthetic */ Class class$com$arsdigita$search$IndexerType;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$com$arsdigita$search$FilterType;
    static /* synthetic */ Class class$com$arsdigita$search$QueryEngine;

    public static void registerEngine(IndexerType indexer, FilterType[] filters, QueryEngine engine) {
        Assert.exists(indexer, class$com$arsdigita$search$IndexerType == null ? (class$com$arsdigita$search$IndexerType = QueryEngineRegistry.class$("com.arsdigita.search.IndexerType")) : class$com$arsdigita$search$IndexerType);
        QueryEngineRegistry.registerEngine(indexer.getKey(), filters, engine);
    }

    public static void registerEngine(String indexer, FilterType[] filters, QueryEngine engine) {
        Assert.exists(indexer, class$java$lang$String == null ? (class$java$lang$String = QueryEngineRegistry.class$("java.lang.String")) : class$java$lang$String);
        Assert.exists(filters, class$com$arsdigita$search$FilterType == null ? (class$com$arsdigita$search$FilterType = QueryEngineRegistry.class$("com.arsdigita.search.FilterType")) : class$com$arsdigita$search$FilterType);
        Assert.exists(engine, class$com$arsdigita$search$QueryEngine == null ? (class$com$arsdigita$search$QueryEngine = QueryEngineRegistry.class$("com.arsdigita.search.QueryEngine")) : class$com$arsdigita$search$QueryEngine);
        if (s_log.isDebugEnabled()) {
            s_log.debug((Object)("Register engine " + engine.getClass() + " for " + indexer));
            for (int i = 0; i < filters.length; ++i) {
                s_log.debug((Object)("  Filter: " + filters[i].getKey() + " (" + filters[i].getClass() + ")"));
            }
        }
        s_engines.put(new EngineKey(indexer, filters), engine);
    }

    public static QueryEngine getEngine(String indexer, FilterType[] filters) {
        Assert.exists(indexer, class$java$lang$String == null ? (class$java$lang$String = QueryEngineRegistry.class$("java.lang.String")) : class$java$lang$String);
        Assert.exists(filters, class$com$arsdigita$search$FilterType == null ? (class$com$arsdigita$search$FilterType = QueryEngineRegistry.class$("com.arsdigita.search.FilterType")) : class$com$arsdigita$search$FilterType);
        if (s_log.isDebugEnabled()) {
            s_log.debug((Object)("Lookup engine for " + indexer));
            for (int i = 0; i < filters.length; ++i) {
                s_log.debug((Object)("  Filter: " + filters[i].getKey() + " (" + filters[i].getClass() + ")"));
            }
        }
        return (QueryEngine)s_engines.get(new EngineKey(indexer, filters));
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        QueryEngineRegistry.registerEngine(IndexerType.NOOP, new FilterType[0], (QueryEngine)new NoopQueryEngine());
    }

    private static class EngineKey {
        private String m_indexer;
        private Set m_filters;

        public EngineKey(String indexer, FilterType[] filters) {
            this.m_indexer = indexer;
            this.m_filters = new HashSet();
            for (int i = 0; i < filters.length; ++i) {
                this.m_filters.add(filters[i]);
            }
        }

        public int hashCode() {
            return ((Object)this.m_filters).hashCode();
        }

        public boolean equals(Object o) {
            if (!(o instanceof EngineKey)) {
                return false;
            }
            EngineKey key = (EngineKey)o;
            if (!this.m_indexer.equals(key.m_indexer)) {
                return false;
            }
            return ((Object)this.m_filters).equals(key.m_filters);
        }
    }
}

