/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.search;

import com.arsdigita.search.FilterSpecification;
import com.arsdigita.search.FilterType;
import com.arsdigita.search.IndexerType;
import com.arsdigita.search.QueryEngine;
import com.arsdigita.search.QueryEngineRegistry;
import com.arsdigita.search.QuerySpecification;
import com.arsdigita.search.ResultCache;
import com.arsdigita.search.ResultSet;
import com.arsdigita.search.SearchConfig;
import com.arsdigita.search.TimedResultCache;
import com.arsdigita.util.Assert;
import com.arsdigita.xml.Element;
import java.util.Collections;
import java.util.Iterator;
import org.apache.log4j.Logger;

public class Search {
    public static final Logger s_log = Logger.getLogger((Class)(class$com$arsdigita$search$Search == null ? (class$com$arsdigita$search$Search = Search.class$("com.arsdigita.search.Search")) : class$com$arsdigita$search$Search));
    private static SearchConfig s_config = new SearchConfig();
    public static final ResultSet EMPTY_RESULT_SET;
    public static final long CACHE_LIFETIME = 300000L;
    public static final long CACHE_SIZE = 50L;
    public static final int CACHE_DOCUMENT_COUNT = 50;
    public static final ResultCache NOP_RESULT_CACHE;
    public static final ResultCache DEFAULT_RESULT_CACHE;
    public static final String INDEXER_INTERMEDIA;
    public static final String INDEXER_LUCENE;
    public static final String XML_PREFIX = "search:";
    public static final String XML_NS = "http://rhea.redhat.com/search/1.0";
    static /* synthetic */ Class class$com$arsdigita$search$Search;
    static /* synthetic */ Class class$com$arsdigita$search$QuerySpecification;
    static /* synthetic */ Class class$com$arsdigita$search$ResultCache;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$com$arsdigita$search$ResultSet;

    public static SearchConfig getConfig() {
        return s_config;
    }

    public static ResultSet process(QuerySpecification spec) {
        return Search.process(spec, DEFAULT_RESULT_CACHE, Search.getConfig().getIndexer());
    }

    public static ResultSet process(QuerySpecification spec, ResultCache cache) {
        return Search.process(spec, cache, Search.getConfig().getIndexer());
    }

    public static ResultSet process(QuerySpecification spec, ResultCache cache, String engine) {
        ResultSet results;
        Assert.exists(spec, class$com$arsdigita$search$QuerySpecification == null ? (class$com$arsdigita$search$QuerySpecification = Search.class$("com.arsdigita.search.QuerySpecification")) : class$com$arsdigita$search$QuerySpecification);
        Assert.exists(cache, class$com$arsdigita$search$ResultCache == null ? (class$com$arsdigita$search$ResultCache = Search.class$("com.arsdigita.search.ResultCache")) : class$com$arsdigita$search$ResultCache);
        Assert.exists(engine, class$java$lang$String == null ? (class$java$lang$String = Search.class$("java.lang.String")) : class$java$lang$String);
        if (s_log.isDebugEnabled()) {
            s_log.debug((Object)("Processing " + spec + " using cache " + cache + " on " + engine));
        }
        if ((results = cache.get(spec)) == null) {
            ResultSet rawResults = Search.processInternal(spec, engine);
            Assert.exists(rawResults, class$com$arsdigita$search$ResultSet == null ? (class$com$arsdigita$search$ResultSet = Search.class$("com.arsdigita.search.ResultSet")) : class$com$arsdigita$search$ResultSet);
            cache.put(spec, rawResults);
            results = cache.get(spec);
            if (results == null) {
                results = rawResults;
            }
        }
        return results;
    }

    public static ResultSet processInternal(QuerySpecification spec, String engine) {
        if (s_log.isDebugEnabled()) {
            s_log.debug((Object)("Processing query specification " + spec));
        }
        FilterSpecification[] filters = spec.getFilters();
        FilterType[] types = new FilterType[filters.length];
        for (int i = 0; i < filters.length; ++i) {
            types[i] = filters[i].getType();
        }
        QueryEngine engineImpl = QueryEngineRegistry.getEngine(engine, types);
        if (engineImpl == null) {
            throw new RuntimeException("cannot find engine to process query " + spec + " on indexer '" + engine + "'");
        }
        return engineImpl.process(spec);
    }

    public static Element newElement(String name) {
        return new Element(XML_PREFIX + name, XML_NS);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        s_config.load();
        EMPTY_RESULT_SET = new EmptyResultSet();
        NOP_RESULT_CACHE = new NopResultCache();
        DEFAULT_RESULT_CACHE = new TimedResultCache(50, 50L, 300000L);
        INDEXER_INTERMEDIA = IndexerType.INTERMEDIA.getKey();
        INDEXER_LUCENE = IndexerType.LUCENE.getKey();
    }

    private static class NopResultCache
    implements ResultCache {
        private NopResultCache() {
        }

        public void put(QuerySpecification query, ResultSet results) {
        }

        public ResultSet get(QuerySpecification query) {
            return null;
        }
    }

    private static class EmptyResultSet
    implements ResultSet {
        private EmptyResultSet() {
        }

        public Iterator getDocuments(long offset, long count) {
            return Collections.EMPTY_LIST.iterator();
        }

        public String getEngine() {
            return Search.getConfig().getIndexer();
        }

        public long getCount() {
            return 0L;
        }

        public long getQueryTime() {
            return 0L;
        }

        public void close() {
        }
    }
}

