/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.search;

import com.arsdigita.runtime.AbstractConfig;
import com.arsdigita.search.ContentType;
import com.arsdigita.search.DocumentObserver;
import com.arsdigita.search.IndexerType;
import com.arsdigita.util.parameter.BooleanParameter;
import com.arsdigita.util.parameter.EnumerationParameter;
import com.arsdigita.util.parameter.IntegerParameter;
import com.arsdigita.util.parameter.Parameter;
import org.apache.log4j.Logger;

public final class SearchConfig
extends AbstractConfig {
    private static Logger s_log = Logger.getLogger((Class)(class$com$arsdigita$search$SearchConfig == null ? (class$com$arsdigita$search$SearchConfig = SearchConfig.class$("com.arsdigita.search.SearchConfig")) : class$com$arsdigita$search$SearchConfig));
    private EnumerationParameter m_indexer = new IndexerParameter("waf.search.indexer", 1, IndexerType.LUCENE);
    private Parameter m_lazyUpdates;
    private Parameter m_xmlContentWeight;
    private Parameter m_rawContentWeight;
    static /* synthetic */ Class class$com$arsdigita$search$SearchConfig;

    public SearchConfig() {
        this.m_indexer.put(IndexerType.INTERMEDIA.getKey(), IndexerType.INTERMEDIA);
        this.m_indexer.put(IndexerType.LUCENE.getKey(), IndexerType.LUCENE);
        this.m_indexer.put(IndexerType.NOOP.getKey(), IndexerType.NOOP);
        this.m_lazyUpdates = new BooleanParameter("waf.search.lazy_updates", 1, new Boolean(true));
        this.m_xmlContentWeight = new IntegerParameter("waf.search.intermedia.xml_content_weight", 1, new Integer(1));
        this.m_rawContentWeight = new IntegerParameter("waf.search.intermedia.raw_content_weight", 1, new Integer(1));
        this.register(this.m_indexer);
        this.register(this.m_lazyUpdates);
        this.register(this.m_xmlContentWeight);
        this.register(this.m_rawContentWeight);
        this.loadInfo();
    }

    public IndexerType getIndexerType() {
        return (IndexerType)this.get(this.m_indexer);
    }

    public String getIndexer() {
        return this.getIndexerType().getKey();
    }

    void setIndexerType(IndexerType indexer) {
        this.set(this.m_indexer, indexer);
    }

    public boolean isIntermediaEnabled() {
        return IndexerType.INTERMEDIA.equals(this.getIndexerType());
    }

    public boolean isLuceneEnabled() {
        return IndexerType.LUCENE.equals(this.getIndexerType());
    }

    public ContentType[] getContent() {
        return this.getIndexerType().getContent();
    }

    public boolean allowsRawContent() {
        ContentType[] types = this.getContent();
        for (int i = 0; i < types.length; ++i) {
            if (!types[i].equals(ContentType.RAW)) continue;
            return true;
        }
        return false;
    }

    public boolean allowsTextContent() {
        ContentType[] types = this.getContent();
        for (int i = 0; i < types.length; ++i) {
            if (!types[i].equals(ContentType.TEXT)) continue;
            return true;
        }
        return false;
    }

    public boolean allowsXMLContent() {
        ContentType[] types = this.getContent();
        for (int i = 0; i < types.length; ++i) {
            if (!types[i].equals(ContentType.XML)) continue;
            return true;
        }
        return false;
    }

    public boolean allowsContent(ContentType content) {
        ContentType[] types = this.getContent();
        for (int i = 0; i < types.length; ++i) {
            if (!types[i].equals(content)) continue;
            return true;
        }
        return false;
    }

    public DocumentObserver getObserver() {
        return this.getIndexerType().getObserver();
    }

    public boolean getLazyUpdates() {
        return (Boolean)this.get(this.m_lazyUpdates);
    }

    void setLazyUpdates(boolean lazyUpdates) {
        this.set(this.m_lazyUpdates, new Boolean(lazyUpdates));
    }

    public Integer getXMLContentWeight() {
        return (Integer)this.get(this.m_xmlContentWeight);
    }

    public Integer getRawContentWeight() {
        return (Integer)this.get(this.m_rawContentWeight);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class IndexerParameter
    extends EnumerationParameter {
        public IndexerParameter(String name, int multiplicity, Object defaalt) {
            super(name, multiplicity, defaalt);
        }
    }
}

