/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.search.converter;

import com.arsdigita.search.converter.BaseConverter;
import com.arsdigita.search.converter.ConversionException;
import com.arsdigita.util.StringUtils;
import com.arsdigita.xml.Document;
import com.arsdigita.xml.Element;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.LinkedList;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.xml.parsers.ParserConfigurationException;
import org.xml.sax.SAXException;

public class OOConverter
extends BaseConverter {
    public static final String CONTENT_XML = "content.xml";

    protected String[] getFileExtensions() {
        String[] extensions = new String[]{"sxw", "stw", "sxi", "sti", "sxc", "stc", "sxd", "sxm", "sxg", "std"};
        return extensions;
    }

    public String convertDocument(InputStream stream) throws ConversionException {
        try {
            ZipInputStream zipStream = new ZipInputStream(stream);
            ZipEntry entry = zipStream.getNextEntry();
            while (entry != null && !CONTENT_XML.equals(entry.getName())) {
                entry = zipStream.getNextEntry();
            }
            if (entry != null) {
                int position;
                ByteArrayOutputStream output = new ByteArrayOutputStream();
                byte[] buf = new byte[1024];
                while ((position = zipStream.read(buf)) != -1) {
                    output.write(buf, 0, position);
                }
                Document doc = new Document(StringUtils.replace(new String(output.toByteArray()), "<!DOCTYPE office:document-content PUBLIC \"-//OpenOffice.org//DTD OfficeDocument 1.0//EN\" \"office.dtd\">", ""));
                Element element = doc.getRootElement();
                StringBuffer outBuf = new StringBuffer();
                LinkedList list = new LinkedList();
                list.addAll(element.getChildren());
                while (list.size() > 0) {
                    outBuf.append(element.getText()).append(" ");
                    if (list.size() <= 0) continue;
                    element = (Element)list.removeFirst();
                    list.addAll(element.getChildren());
                }
                return outBuf.toString();
            }
            return "";
        }
        catch (IOException ioe) {
            throw new ConversionException(ioe);
        }
        catch (ParserConfigurationException pce) {
            throw new ConversionException(pce);
        }
        catch (SAXException se) {
            throw new ConversionException(se);
        }
    }
}

