/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.search.intermedia;

import com.arsdigita.db.DbHelper;
import com.arsdigita.initializer.Configuration;
import com.arsdigita.initializer.InitializationException;
import com.arsdigita.search.FilterType;
import com.arsdigita.search.IndexerType;
import com.arsdigita.search.QueryEngine;
import com.arsdigita.search.QueryEngineRegistry;
import com.arsdigita.search.Search;
import com.arsdigita.search.filters.CategoryFilterType;
import com.arsdigita.search.filters.ObjectTypeFilterType;
import com.arsdigita.search.filters.PermissionFilterType;
import com.arsdigita.search.intermedia.BaseQueryEngine;
import com.arsdigita.search.intermedia.BuildIndex;
import org.apache.log4j.Logger;

public class Initializer
implements com.arsdigita.initializer.Initializer {
    private Configuration m_conf = new Configuration();
    private static final Logger s_log = Logger.getLogger((Class)(class$com$arsdigita$search$intermedia$Initializer == null ? (class$com$arsdigita$search$intermedia$Initializer = Initializer.class$("com.arsdigita.search.intermedia.Initializer")) : class$com$arsdigita$search$intermedia$Initializer));
    public static final String versionId = "$Id";
    private static final String TIMER_DELAY = "timerDelay";
    private static final String TIMER_DELAY_DESCRIPTION = "Delay between triggering of search indexing Timer, in seconds.";
    private static final String SYNC_DELAY = "syncDelay";
    private static final String SYNC_DELAY_DESCRIPTION = "Time (in seconds) after which if a content change is made the index should be resynced if there are no other changes during that time.";
    private static final String MAX_SYNC_DELAY = "maxSyncDelay";
    private static final String MAX_SYNC_DELAY_DESCRIPTION = "Time (in seconds) after which a change is made, the index will be resynced, regardless of whether or not any changes have subsequently been made.";
    private static final String MAX_INDEXING_TIME = "maxIndexingTime";
    private static final String MAX_INDEXING_TIME_DESCRIPTION = "Time (in seconds) after which a indexing operation that has not finished is considered to have failed.";
    private static final String INDEXING_RETRY_DELAY = "indexingRetryDelay";
    private static final String INDEXING_RETRY_DELAY_DESCRIPTION = "Time (in seconds) after which an indexing operation that failed will be retried.";
    static /* synthetic */ Class class$com$arsdigita$search$intermedia$Initializer;
    static /* synthetic */ Class class$java$lang$Integer;

    public Initializer() throws InitializationException {
        this.m_conf.initParameter(TIMER_DELAY, TIMER_DELAY_DESCRIPTION, class$java$lang$Integer == null ? (class$java$lang$Integer = Initializer.class$("java.lang.Integer")) : class$java$lang$Integer, new Integer(60));
        this.m_conf.initParameter(SYNC_DELAY, SYNC_DELAY_DESCRIPTION, class$java$lang$Integer == null ? (class$java$lang$Integer = Initializer.class$("java.lang.Integer")) : class$java$lang$Integer, new Integer(60));
        this.m_conf.initParameter(MAX_SYNC_DELAY, MAX_SYNC_DELAY_DESCRIPTION, class$java$lang$Integer == null ? (class$java$lang$Integer = Initializer.class$("java.lang.Integer")) : class$java$lang$Integer, new Integer(7200));
        this.m_conf.initParameter(MAX_INDEXING_TIME, MAX_INDEXING_TIME_DESCRIPTION, class$java$lang$Integer == null ? (class$java$lang$Integer = Initializer.class$("java.lang.Integer")) : class$java$lang$Integer, new Integer(7200));
        this.m_conf.initParameter(INDEXING_RETRY_DELAY, INDEXING_RETRY_DELAY_DESCRIPTION, class$java$lang$Integer == null ? (class$java$lang$Integer = Initializer.class$("java.lang.Integer")) : class$java$lang$Integer, new Integer(60));
    }

    public Configuration getConfiguration() {
        return this.m_conf;
    }

    public void startup() {
        if (Search.getConfig().isIntermediaEnabled()) {
            if (DbHelper.getDatabase() != 1) {
                throw new InitializationException("Intermedia searching only works on Oracle, not " + DbHelper.getDatabaseName(DbHelper.getDatabase()));
            }
            int timerDelay = (Integer)this.m_conf.getParameter(TIMER_DELAY) * 1000;
            int syncDelay = (Integer)this.m_conf.getParameter(TIMER_DELAY) * 1000;
            int maxSyncDelay = (Integer)this.m_conf.getParameter(MAX_SYNC_DELAY) * 1000;
            int maxIndexingTime = (Integer)this.m_conf.getParameter(MAX_INDEXING_TIME) * 1000;
            int indexingRetryDelay = (Integer)this.m_conf.getParameter(INDEXING_RETRY_DELAY) * 1000;
            BuildIndex.setParameterValues(timerDelay, syncDelay, maxSyncDelay, maxIndexingTime, indexingRetryDelay);
            BuildIndex.startTimer();
            QueryEngineRegistry.registerEngine(IndexerType.INTERMEDIA, new FilterType[0], (QueryEngine)new BaseQueryEngine());
            QueryEngineRegistry.registerEngine(IndexerType.INTERMEDIA, new FilterType[]{new PermissionFilterType(), new ObjectTypeFilterType(), new CategoryFilterType()}, (QueryEngine)new BaseQueryEngine());
        }
    }

    public void shutdown() {
        if (Search.getConfig().isIntermediaEnabled()) {
            BuildIndex.stopTimer();
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

