/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.search.intermedia;

import com.arsdigita.persistence.DataQuery;
import com.arsdigita.persistence.SessionManager;
import com.arsdigita.search.SearchDataQuery;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class SearchSpecification {
    public static final String versionId = "$Id: //core-platform/dev/src/com/arsdigita/search/intermedia/SearchSpecification.java#3 $ by $Author: dennis $, $DateTime: 2004/04/07 16:07:11 $";
    private static final int DEFAULT_MAXROWS = 1000;
    private static final int DEFAULT_ROWSPERPAGE = 100;
    private String m_sql;
    private String[] m_columns;
    private int m_maxRows;
    private int m_rowsPerPage;
    private HashMap m_parameters = new HashMap();

    public SearchSpecification(String sql, String[] columns, int maxRows, int rowsPerPage) {
        this.m_sql = sql;
        this.m_columns = columns;
        this.m_maxRows = maxRows;
        this.m_rowsPerPage = rowsPerPage;
        this.assertInvariant();
    }

    public SearchSpecification(String sql, String[] columns) {
        this(sql, columns, 1000, 100);
    }

    public void setParameter(String name, Object value) {
        this.m_parameters.put(name, value);
    }

    public Object getParameter(String parameterName) {
        return this.m_parameters.get(parameterName);
    }

    public void setSelect(String sql, String[] columns) {
        this.validateSQL(sql);
        this.validateColumns(columns);
        this.m_sql = sql;
        this.m_columns = columns;
    }

    public void setMaxResultRows(int maxRows) {
        this.validateMaxRows(maxRows);
        this.m_maxRows = maxRows;
    }

    public void setRowsPerPage(int rowsPerPage) {
        this.validateRowsPerPage(rowsPerPage);
        this.m_rowsPerPage = rowsPerPage;
    }

    private void assertInvariant() {
        this.validateMaxRows(this.m_maxRows);
        this.validateRowsPerPage(this.m_rowsPerPage);
        this.validateSQL(this.m_sql);
        this.validateColumns(this.m_columns);
    }

    private void validateColumns(String[] columns) {
        if (null == columns) {
            throw new IllegalArgumentException("Columns cannot be null");
        }
    }

    private void validateRowsPerPage(int rowsPerPage) {
        if (rowsPerPage <= 0) {
            throw new IllegalStateException("rowsPerPage must be greater than 0, Specified value was: " + this.m_rowsPerPage);
        }
    }

    private void validateMaxRows(int maxRows) {
        if (maxRows <= 0) {
            throw new IllegalStateException("maxRows must be greater than 0, Specified value was: " + this.m_maxRows);
        }
    }

    private void validateSQL(String sql) {
        String lc_sql = sql.toLowerCase();
        int pos_select = lc_sql.indexOf("select");
        int pos_from = lc_sql.indexOf("from");
        if (pos_select == -1 || pos_from == -1) {
            throw new IllegalStateException("Invalid SQL statement. Must be a complete SELECT statement. Specified SQL was: " + this.m_sql);
        }
    }

    public String getSelect() {
        return this.m_sql;
    }

    public String[] getColumns() {
        return this.m_columns;
    }

    public int getMaxResultRows() {
        return this.m_maxRows;
    }

    public int getRowsPerPage() {
        return this.m_rowsPerPage;
    }

    protected String reformatSqlForPage(int page) {
        return this.m_sql;
    }

    public DataQuery getPage(int page) {
        if (page <= 0) {
            throw new IllegalArgumentException("Invalid page specified, must be > 0. Value specified was: " + page);
        }
        int firstRow = (page - 1) * this.m_rowsPerPage + 1;
        int lastRow = Math.min(page * this.m_rowsPerPage, this.m_maxRows);
        if (lastRow < this.m_maxRows) {
            ++lastRow;
        }
        String sql_for_page = this.m_sql;
        SearchDataQuery dq = new SearchDataQuery(SessionManager.getSession(), sql_for_page, this.m_columns);
        dq.setRange(new Integer(firstRow), new Integer(lastRow));
        Iterator it = this.m_parameters.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry me = it.next();
            String key = (String)me.getKey();
            Object value = me.getValue();
            dq.setParameter(key, value);
        }
        return dq;
    }
}

