/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.search.lucene;

import com.arsdigita.domain.DomainObject;
import com.arsdigita.persistence.DataObject;
import com.arsdigita.persistence.OID;
import com.arsdigita.persistence.Session;
import com.arsdigita.persistence.SessionManager;
import com.arsdigita.search.lucene.Index;
import com.arsdigita.util.Assert;
import com.arsdigita.util.StringUtils;
import java.math.BigDecimal;
import java.util.Date;
import java.util.Locale;
import org.apache.log4j.Logger;

public class Document
extends DomainObject {
    private static final Logger s_log = Logger.getLogger((Class)(class$com$arsdigita$search$lucene$Document == null ? (class$com$arsdigita$search$lucene$Document = Document.class$("com.arsdigita.search.lucene.Document")) : class$com$arsdigita$search$lucene$Document));
    public static final String versionId = "$Id: //core-platform/dev/src/com/arsdigita/search/lucene/Document.java#4 $ by $Author: dennis $, $DateTime: 2004/04/07 16:07:11 $";
    public static final String BASE_DATA_OBJECT_TYPE = "com.arsdigita.search.lucene.Document";
    public static final String ID = "id";
    public static final String LANGUAGE = "language";
    public static final String COUNTRY = "country";
    public static final String TYPE = "type";
    public static final String TYPE_SPECIFIC_INFO = "typeSpecificInfo";
    public static final String TITLE = "title";
    public static final String SUMMARY = "summary";
    public static final String CONTENT = "content";
    public static final String CREATION_DATE = "creationDate";
    public static final String CREATION_PARTY = "creationParty";
    public static final String LAST_MODIFIED_DATE = "lastModifiedDate";
    public static final String LAST_MODIFIED_PARTY = "lastModifiedParty";
    static final String IS_DELETED = "isDeleted";
    static final String DIRTY = "dirty";
    static final String TIMESTAMP = "timestamp";
    private static final Integer BITMASK = new Integer(Integer.MAX_VALUE);
    static /* synthetic */ Class class$com$arsdigita$search$lucene$Document;
    static /* synthetic */ Class class$java$lang$String;

    protected static final Document create(BigDecimal id) {
        Session ssn = SessionManager.getSession();
        DataObject data = ssn.create(new OID(BASE_DATA_OBJECT_TYPE, (Object)id));
        Document doc = new Document(data);
        doc.setDeleted(false);
        return doc;
    }

    protected static final Document retrieve(BigDecimal id) {
        Session ssn = SessionManager.getSession();
        return Document.retrieve(ssn.retrieve(new OID(BASE_DATA_OBJECT_TYPE, (Object)id)));
    }

    protected static final Document retrieve(DataObject data) {
        if (data == null) {
            return null;
        }
        return new Document(data);
    }

    public void initialize() {
        super.initialize();
        if (this.isNew()) {
            this.setDirty(true);
        }
    }

    private Document(DataObject data) {
        super(data);
    }

    public BigDecimal getID() {
        return (BigDecimal)this.get(ID);
    }

    public void setType(String type) {
        this.set(TYPE, type);
    }

    public String getType() {
        return (String)this.get(TYPE);
    }

    public void setTypeSpecificInfo(String info) {
        this.set(TYPE_SPECIFIC_INFO, info);
    }

    public String getTypeSpecificInfo() {
        return (String)this.get(TYPE_SPECIFIC_INFO);
    }

    public Date getTimestamp() {
        return (Date)this.get(TIMESTAMP);
    }

    public void setDeleted(boolean value) {
        this.set(IS_DELETED, new Boolean(value));
    }

    public boolean isDeleted() {
        return Boolean.TRUE.equals(this.get(IS_DELETED));
    }

    public void setLocale(Locale locale) {
        if (locale == null) {
            this.set(LANGUAGE, null);
            this.set(COUNTRY, null);
        } else {
            this.set(LANGUAGE, locale.getLanguage());
            this.set(COUNTRY, locale.getCountry());
        }
    }

    public Locale getLocale() {
        String language = (String)this.get(LANGUAGE);
        String country = (String)this.get(COUNTRY);
        if (language == null && country == null) {
            return null;
        }
        if (language == null) {
            language = "";
        }
        if (country == null) {
            country = "";
        }
        return new Locale(language, country);
    }

    public void setTitle(String title) {
        if (StringUtils.emptyString(title)) {
            s_log.warn((Object)("Adding empty title! " + title));
        }
        Assert.exists(title, class$java$lang$String == null ? (class$java$lang$String = Document.class$("java.lang.String")) : class$java$lang$String);
        this.set(TITLE, title);
    }

    public String getTitle() {
        return (String)this.get(TITLE);
    }

    public void setSummary(String summary) {
        this.set(SUMMARY, summary);
    }

    public String getSummary() {
        return (String)this.get(SUMMARY);
    }

    public void setContent(String content) {
        this.set(CONTENT, content);
    }

    public String getContent() {
        return (String)this.get(CONTENT);
    }

    public void setCreationDate(Date creationDate) {
        this.set(CREATION_DATE, creationDate);
    }

    public Date getCreationDate() {
        return (Date)this.get(CREATION_DATE);
    }

    public void setCreationParty(BigDecimal creationParty) {
        this.set(CREATION_PARTY, creationParty);
    }

    public BigDecimal getCreationParty() {
        return (BigDecimal)this.get(CREATION_PARTY);
    }

    public void setLastModifiedDate(Date lastModifiedDate) {
        this.set(LAST_MODIFIED_DATE, lastModifiedDate);
    }

    public Date getLastModifiedDate() {
        return (Date)this.get(LAST_MODIFIED_DATE);
    }

    public void setLastModifiedParty(BigDecimal lastModifiedParty) {
        this.set(LAST_MODIFIED_PARTY, lastModifiedParty);
    }

    public BigDecimal getLastModifiedParty() {
        return (BigDecimal)this.get(LAST_MODIFIED_PARTY);
    }

    boolean isDirty() {
        int dirty = (Integer)this.get(DIRTY);
        return (dirty & 1 << Index.getIndexID()) != 0;
    }

    void setDirty(boolean dirty) {
        if (dirty) {
            this.set(DIRTY, BITMASK);
            this.set(TIMESTAMP, new Date());
        } else {
            this.set(DIRTY, new Integer(~(1 << Index.getIndexID())));
            this.set(TIMESTAMP, this.getTimestamp());
        }
    }

    protected void beforeSave() {
        super.beforeSave();
        if (!this.isPropertyModified(DIRTY)) {
            this.set(DIRTY, BITMASK);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

