/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.search.lucene;

import com.arsdigita.search.lucene.Index;
import com.arsdigita.search.lucene.LuceneLock;
import com.arsdigita.search.lucene.ObjectTypeFilter;
import com.arsdigita.util.UncheckedWrapperException;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.Date;
import java.util.Locale;
import org.apache.log4j.Logger;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.standard.StandardAnalyzer;
import org.apache.lucene.document.DateField;
import org.apache.lucene.document.Document;
import org.apache.lucene.queryParser.ParseException;
import org.apache.lucene.queryParser.QueryParser;
import org.apache.lucene.search.Filter;
import org.apache.lucene.search.Hits;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;

public class LuceneSearch {
    private static final Logger LOG = Logger.getLogger((Class)(class$com$arsdigita$search$lucene$LuceneSearch == null ? (class$com$arsdigita$search$lucene$LuceneSearch = LuceneSearch.class$("com.arsdigita.search.lucene.LuceneSearch")) : class$com$arsdigita$search$lucene$LuceneSearch));
    private IndexSearcher m_index;
    private Hits m_hits;
    private int m_hitIndex;
    private Document m_doc;
    private float m_score;
    private static final LuceneLock LOCK = LuceneLock.getInstance();
    static /* synthetic */ Class class$com$arsdigita$search$lucene$LuceneSearch;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LuceneSearch(String searchString) {
        try {
            LuceneLock luceneLock = LOCK;
            synchronized (luceneLock) {
                this.m_index = new IndexSearcher(Index.getLocation());
                Query query = QueryParser.parse((String)searchString, (String)"content", (Analyzer)new StandardAnalyzer());
                this.m_hits = this.m_index.search(query);
            }
            this.m_hitIndex = 0;
        }
        catch (IOException ex) {
            LOG.fatal((Object)("failed the search for " + searchString), (Throwable)ex);
        }
        catch (ParseException ex) {
            LOG.fatal((Object)("failed the search for " + searchString), (Throwable)ex);
        }
    }

    public LuceneSearch(String searchString, String objectType) {
        this(searchString, new ObjectTypeFilter(objectType));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LuceneSearch(String searchString, Filter f) {
        try {
            LuceneLock luceneLock = LOCK;
            synchronized (luceneLock) {
                this.m_index = new IndexSearcher(Index.getLocation());
                Query query = QueryParser.parse((String)searchString, (String)"content", (Analyzer)new StandardAnalyzer());
                this.m_hits = this.m_index.search(query, f);
            }
            this.m_hitIndex = 0;
        }
        catch (IOException ex) {
            LOG.fatal((Object)("failed the search for " + searchString), (Throwable)ex);
        }
        catch (ParseException ex) {
            LOG.fatal((Object)("failed the search for " + searchString), (Throwable)ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LuceneSearch(Query q) {
        try {
            LuceneLock luceneLock = LOCK;
            synchronized (luceneLock) {
                this.m_index = new IndexSearcher(Index.getLocation());
                this.m_hits = this.m_index.search(q);
            }
            this.m_hitIndex = 0;
        }
        catch (IOException e) {
            LOG.fatal((Object)"search failed", (Throwable)e);
        }
    }

    public int size() {
        return this.m_hits == null ? 0 : this.m_hits.length();
    }

    public boolean next() {
        if (this.m_hits == null) {
            return false;
        }
        if (this.m_hitIndex < this.m_hits.length()) {
            try {
                this.m_doc = this.m_hits.doc(this.m_hitIndex);
                this.m_score = this.m_hits.score(this.m_hitIndex);
                ++this.m_hitIndex;
                return true;
            }
            catch (IOException e) {
                return false;
            }
        }
        return false;
    }

    public void close() {
        try {
            if (this.m_index != null) {
                this.m_index.close();
            }
        }
        catch (IOException ioe) {
            throw new UncheckedWrapperException(ioe);
        }
    }

    public float getScore() {
        return this.m_score;
    }

    public BigDecimal getID() {
        return new BigDecimal(this.m_doc.get("id"));
    }

    public Locale getLocale() {
        String language = this.m_doc.get("language");
        String country = this.m_doc.get("country");
        if ("".equals(language) && "".equals(country)) {
            return null;
        }
        return new Locale(language, country);
    }

    public String getType() {
        return this.m_doc.get("type");
    }

    public String getTypeSpecificInfo() {
        return this.m_doc.get("typeSpecificInfo");
    }

    public String getTitle() {
        return this.m_doc.get("title");
    }

    public String getSummary() {
        return this.m_doc.get("summary");
    }

    public String getContent() {
        return this.m_doc.get("content");
    }

    public Date getCreationDate() {
        return this.toDate(this.m_doc.get("creationDate"));
    }

    public Date getLastModifiedDate() {
        return this.toDate(this.m_doc.get("lastModifiedDate"));
    }

    private Date toDate(String date) {
        if (date == null || date.equals("")) {
            return null;
        }
        return DateField.stringToDate((String)date);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

