/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.search.lucene;

import com.arsdigita.domain.DomainObject;
import com.arsdigita.domain.DomainServiceInterfaceExposer;
import com.arsdigita.kernel.Party;
import com.arsdigita.persistence.DataObject;
import com.arsdigita.persistence.metadata.MetadataRoot;
import com.arsdigita.persistence.metadata.ObjectType;
import com.arsdigita.persistence.metadata.Property;
import com.arsdigita.search.lucene.Adapter;
import com.arsdigita.util.StringUtils;
import java.math.BigDecimal;
import java.util.Date;
import java.util.Locale;

public class StandardAdapter
extends Adapter {
    public static final String versionId = "$Id: //core-platform/dev/src/com/arsdigita/search/lucene/StandardAdapter.java#3 $ by $Author: dennis $, $DateTime: 2004/04/07 16:07:11 $";
    private ObjectType m_type;
    private Property m_id;
    private Property m_title;
    private Property m_summary;
    private Property[] m_content;

    public StandardAdapter(ObjectType type, Property id, Property title, Property summary, Property[] content) {
        this.m_type = type;
        this.m_id = id;
        this.m_title = title;
        this.m_summary = summary;
        this.m_content = content;
    }

    public StandardAdapter(ObjectType type, String id, String title, String summary, String[] content) {
        this(type, StandardAdapter.getProperty(type, id), StandardAdapter.getProperty(type, title), StandardAdapter.getProperty(type, summary), StandardAdapter.getProperties(type, content));
    }

    private static final Property getProperty(ObjectType type, String prop) {
        if (prop == null) {
            return null;
        }
        return type.getProperty(prop);
    }

    private static final Property[] getProperties(ObjectType type, String[] props) {
        Property[] result = new Property[props.length];
        for (int i = 0; i < result.length; ++i) {
            result[i] = type.getProperty(props[i]);
        }
        return result;
    }

    public StandardAdapter(String type, String id, String title, String summary, String[] content) {
        this(MetadataRoot.getMetadataRoot().getObjectType(type), id, title, summary, content);
    }

    public BigDecimal getID(DomainObject dobj) {
        return (BigDecimal)StandardAdapter.get(dobj, this.m_id);
    }

    public ObjectType getObjectType(DomainObject dobj) {
        return dobj.getObjectType();
    }

    public String getTypeSpecificInfo(DomainObject dobj) {
        return null;
    }

    public Locale getLocale(DomainObject dobj) {
        return null;
    }

    public String getTitle(DomainObject dobj) {
        return StandardAdapter.getString(dobj, this.m_title);
    }

    public String getSummary(DomainObject dobj) {
        return StandardAdapter.getString(dobj, this.m_summary);
    }

    public String getContent(DomainObject dobj) {
        StringBuffer result = new StringBuffer();
        boolean first = true;
        for (int i = 0; i < this.m_content.length; ++i) {
            String str = StandardAdapter.getString(dobj, this.m_content[i]);
            if (str == null) continue;
            if (first) {
                first = false;
            } else {
                result.append(" ");
            }
            result.append(str);
        }
        if (first) {
            return null;
        }
        String content = result.toString().replace('\n', ' ');
        return StringUtils.htmlToText(content);
    }

    public Date getCreationDate(DomainObject dobj) {
        return null;
    }

    public Party getCreationParty(DomainObject dobj) {
        return null;
    }

    public Date getLastModifiedDate(DomainObject dobj) {
        return null;
    }

    public Party getLastModifiedParty(DomainObject dobj) {
        return null;
    }

    private static final String getString(DomainObject dobj, Property prop) {
        if (prop == null) {
            return null;
        }
        Object result = StandardAdapter.get(dobj, prop);
        if (result == null) {
            return null;
        }
        return result.toString();
    }

    private static final Object get(DomainObject dobj, Property prop) {
        return StandardAdapter.getDataObject(dobj).get(prop.getName());
    }

    private static final DataObject getDataObject(DomainObject dobj) {
        return DomainServiceInterfaceExposer.getDataObject(dobj);
    }
}

