/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.search.ui;

import com.arsdigita.bebop.Page;
import com.arsdigita.bebop.PageState;
import com.arsdigita.bebop.SimpleComponent;
import com.arsdigita.bebop.parameters.IntegerParameter;
import com.arsdigita.kernel.Party;
import com.arsdigita.search.Document;
import com.arsdigita.search.QuerySpecification;
import com.arsdigita.search.ResultSet;
import com.arsdigita.search.Search;
import com.arsdigita.search.ui.QueryGenerator;
import com.arsdigita.web.ParameterMap;
import com.arsdigita.web.URL;
import com.arsdigita.web.Web;
import com.arsdigita.xml.Element;
import com.arsdigita.xml.XML;
import java.util.Date;
import java.util.Iterator;
import org.apache.log4j.Logger;

public class ResultsPane
extends SimpleComponent {
    private static final Logger s_log = Logger.getLogger((Class)(class$com$arsdigita$search$ui$ResultsPane == null ? (class$com$arsdigita$search$ui$ResultsPane = ResultsPane.class$("com.arsdigita.search.ui.ResultsPane")) : class$com$arsdigita$search$ui$ResultsPane));
    public static final int PAGE_SIZE = 10;
    private int m_pageSize = 10;
    private String m_engine;
    private QueryGenerator m_query;
    private IntegerParameter m_pageNumber;
    static /* synthetic */ Class class$com$arsdigita$search$ui$ResultsPane;

    public ResultsPane(QueryGenerator query) {
        this(query, null);
    }

    public ResultsPane(QueryGenerator query, String engine) {
        this.m_query = query;
        this.m_engine = engine;
        this.m_pageNumber = new IntegerParameter("page");
    }

    public void register(Page p) {
        super.register(p);
        p.addGlobalStateParam(this.m_pageNumber);
    }

    public void generateXML(PageState state, Element parent) {
        Integer page;
        ResultSet resultSet;
        if (!this.m_query.hasQuery(state)) {
            if (s_log.isDebugEnabled()) {
                s_log.debug((Object)"No query available, skipping XMl generation");
            }
            return;
        }
        QuerySpecification spec = this.m_query.getQuerySpecification(state);
        ResultSet resultSet2 = resultSet = this.m_engine == null ? Search.process(spec) : Search.process(spec, Search.DEFAULT_RESULT_CACHE, this.m_engine);
        if (s_log.isDebugEnabled()) {
            s_log.debug((Object)("Got result set " + resultSet.getClass() + " count: " + resultSet.getCount()));
        }
        int pageNumber = (page = (Integer)state.getValue(this.m_pageNumber)) == null ? 1 : page;
        long objectCount = resultSet.getCount();
        int pageCount = (int)Math.ceil((double)objectCount / (double)this.m_pageSize);
        if (pageNumber < 1) {
            pageNumber = 1;
        }
        if (pageNumber > pageCount) {
            pageNumber = pageCount == 0 ? 1 : pageCount;
        }
        long begin = (pageNumber - 1) * this.m_pageSize;
        int count = (int)Math.min((long)this.m_pageSize, objectCount - begin);
        long end = begin + (long)count;
        Iterator results = resultSet.getDocuments(begin, count);
        Element content = Search.newElement("results");
        this.exportAttributes(content);
        if (s_log.isDebugEnabled()) {
            s_log.debug((Object)("Paginator stats\n  page number:" + pageNumber + "\n  page count: " + pageCount + "\n  page size: " + this.m_pageSize + "\n start " + begin + "\n  end: " + end + "\n count: " + objectCount));
        }
        content.addContent(this.generatePaginatorXML(state, this.m_pageNumber.getName(), pageNumber, pageCount, this.m_pageSize, begin, end, objectCount));
        content.addContent(this.generateDocumentsXML(state, results));
        parent.addContent(content);
        resultSet.close();
    }

    protected Element generatePaginatorXML(PageState state, String pageParam, int pageNumber, int pageCount, int pageSize, long begin, long end, long objectCount) {
        Element paginator = Search.newElement("paginator");
        URL url = Web.getContext().getRequestURL();
        ParameterMap map = new ParameterMap();
        Iterator current = url.getParameterMap().keySet().iterator();
        while (current.hasNext()) {
            String key = (String)current.next();
            if (key.equals(pageParam)) continue;
            map.setParameterValues(key, url.getParameterValues(key));
        }
        paginator.addAttribute("pageParam", this.m_pageNumber.getName());
        paginator.addAttribute("baseURL", URL.there(url.getPathInfo(), map).toString());
        paginator.addAttribute("pageNumber", XML.format(new Integer(pageNumber)));
        paginator.addAttribute("pageCount", XML.format(new Integer(pageCount)));
        paginator.addAttribute("pageSize", XML.format(new Integer(pageSize)));
        paginator.addAttribute("objectBegin", XML.format(new Long(begin + 1L)));
        paginator.addAttribute("objectEnd", XML.format(new Long(end)));
        paginator.addAttribute("objectCount", XML.format(new Long(objectCount)));
        return paginator;
    }

    protected Element generateDocumentsXML(PageState state, Iterator results) {
        Element documents = Search.newElement("documents");
        if (s_log.isDebugEnabled()) {
            s_log.debug((Object)"Outputting documents");
        }
        while (results.hasNext()) {
            Document doc = (Document)results.next();
            if (s_log.isDebugEnabled()) {
                s_log.debug((Object)("One doc " + doc.getOID() + " " + doc.getTitle()));
            }
            documents.addContent(this.generateDocumentXML(state, doc));
        }
        return documents;
    }

    protected Element generateDocumentXML(PageState state, Document doc) {
        Party lastModifiedParty;
        Date lastModifiedDate;
        Party creationParty;
        Element entry = Search.newElement("object");
        String summary = doc.getSummary();
        entry.addAttribute("oid", XML.format(doc.getOID()));
        entry.addAttribute("url", XML.format(doc.getURL()));
        entry.addAttribute("score", XML.format(doc.getScore()));
        entry.addAttribute("title", XML.format(doc.getTitle()));
        if (summary != null) {
            entry.addAttribute("summary", XML.format(summary));
        }
        entry.addAttribute("locale", XML.format(doc.getLocale()));
        Date creationDate = doc.getCreationDate();
        if (creationDate != null) {
            entry.addAttribute("creationDate", XML.format(creationDate.toString()));
        }
        if ((creationParty = doc.getCreationParty()) != null) {
            entry.addAttribute("creationParty", XML.format(creationParty.getDisplayName()));
        }
        if ((lastModifiedDate = doc.getLastModifiedDate()) != null) {
            entry.addAttribute("lastModifiedDate", XML.format(lastModifiedDate));
        }
        if ((lastModifiedParty = doc.getLastModifiedParty()) != null) {
            entry.addAttribute("lastModifiedParty", XML.format(lastModifiedParty.getDisplayName()));
        }
        return entry;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

