/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.search.ui.filters;

import com.arsdigita.bebop.PageState;
import com.arsdigita.search.FilterSpecification;
import com.arsdigita.search.FilterType;
import com.arsdigita.search.Search;
import com.arsdigita.search.filters.DateRangeFilterSpecification;
import com.arsdigita.search.ui.FilterWidget;
import com.arsdigita.search.ui.filters.DateRange;
import com.arsdigita.search.ui.filters.DateRangeParameter;
import com.arsdigita.xml.Element;
import java.text.DateFormatSymbols;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;

public class DateRangeFilterWidget
extends FilterWidget {
    private FilterType m_type;

    public DateRangeFilterWidget(FilterType type, String name) {
        super(type, new DateRangeParameter(name));
        this.m_type = type;
    }

    public FilterSpecification getFilter(PageState state) {
        DateRange range = (DateRange)this.getValue(state);
        if (range == null) {
            return new DateRangeFilterSpecification(null, null, this.m_type);
        }
        return new DateRangeFilterSpecification(range.getStartDate(), range.getEndDate(), this.m_type);
    }

    public void generateBodyXML(PageState state, Element parent) {
        super.generateBodyXML(state, parent);
        DateRange range = (DateRange)this.getValue(state);
        int startDay = -1;
        int startMonth = -1;
        int startYear = -1;
        int endDay = -1;
        int endMonth = -1;
        int endYear = -1;
        if (range != null) {
            Date end;
            Date start = range.getStartDate();
            if (start != null) {
                Calendar cal = GregorianCalendar.getInstance();
                cal.setTime(start);
                startDay = cal.get(5);
                startMonth = cal.get(2);
                startYear = cal.get(1);
            }
            if ((end = range.getEndDate()) != null) {
                Element value = Search.newElement("end");
                Calendar cal = GregorianCalendar.getInstance();
                cal.setTime(end);
                endDay = cal.get(5);
                endMonth = cal.get(2);
                endYear = cal.get(1);
            }
        }
        Element day = Search.newElement("day");
        if (startDay != -1) {
            day.addAttribute("startDay", "1");
        }
        if (endDay != -1) {
            day.addAttribute("endDay", "1");
        }
        DateFormatSymbols dfs = new DateFormatSymbols();
        Calendar currentTime = GregorianCalendar.getInstance();
        if (startMonth == -1) {
            startMonth = currentTime.get(2);
        }
        if (endMonth == -1) {
            endMonth = currentTime.get(2);
        }
        String[] monthsList = dfs.getMonths();
        for (int i = 0; i < monthsList.length; ++i) {
            if (monthsList[i].length() <= 0) continue;
            Element month = Search.newElement("month");
            month.addAttribute("value", String.valueOf(i));
            month.addAttribute("title", monthsList[i]);
            if (startMonth == i) {
                month.addAttribute("startMonth", "1");
            }
            if (endMonth == i) {
                month.addAttribute("endMonth", "1");
            }
            parent.addContent(month);
        }
        if (startYear == -1) {
            startYear = currentTime.get(1);
        }
        if (endYear == -1) {
            endYear = currentTime.get(1);
        }
        int currentYear = currentTime.get(1);
        for (int i = currentYear - 5; i <= currentYear + 5; ++i) {
            Element year = Search.newElement("year");
            year.addAttribute("value", String.valueOf(i));
            year.addAttribute("title", String.valueOf(i));
            if (startYear == i) {
                year.addAttribute("startYear", "1");
            }
            if (endYear == i) {
                year.addAttribute("endYear", "1");
            }
            parent.addContent(year);
        }
    }
}

