/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.search.ui.filters;

import com.arsdigita.bebop.PageState;
import com.arsdigita.bebop.parameters.StringParameter;
import com.arsdigita.kernel.Party;
import com.arsdigita.kernel.PartyCollection;
import com.arsdigita.search.FilterSpecification;
import com.arsdigita.search.FilterType;
import com.arsdigita.search.Search;
import com.arsdigita.search.filters.PartyFilterSpecification;
import com.arsdigita.search.ui.FilterWidget;
import com.arsdigita.util.StringUtils;
import com.arsdigita.xml.Element;

public class PartyFilterWidget
extends FilterWidget {
    public static final String PARTY_TEXT = "partyText";
    private FilterType m_type;
    private String m_paramName;

    public PartyFilterWidget(FilterType type, String parameterName) {
        super(type, new StringParameter(parameterName));
        this.m_type = type;
        this.m_paramName = parameterName;
    }

    public FilterSpecification getFilter(PageState state) {
        String searchTerm = (String)this.getValue(state);
        if (searchTerm == null || searchTerm.trim().length() == 0) {
            return new PartyFilterSpecification(null, this.m_type);
        }
        return new PartyFilterSpecification(this.getParties(searchTerm), this.m_type);
    }

    private PartyCollection getParties(String searchTerm) {
        searchTerm = StringUtils.stripWhiteSpace(searchTerm);
        PartyCollection parties = Party.retrieveAllParties();
        parties.filter(searchTerm);
        return parties;
    }

    public void generateBodyXML(PageState state, Element parent) {
        super.generateBodyXML(state, parent);
        Element partyElement = Search.newElement(PARTY_TEXT);
        partyElement.addAttribute("name", this.m_paramName);
        partyElement.addAttribute("value", (String)this.getValue(state));
        parent.addContent(partyElement);
    }
}

